/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.transport.spring.binder.hivemqv5;

import de.iip_ecosphere.platform.transport.spring.binder.hivemqv5.HivemqV5Client;
import org.springframework.cloud.stream.provisioning.ConsumerDestination;
import org.springframework.integration.endpoint.MessageProducerSupport;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.messaging.Message;

public class HivemqV5MessageProducer
extends MessageProducerSupport {
    private final ConsumerDestination destination;
    private HivemqV5Client client;

    public HivemqV5MessageProducer(ConsumerDestination destination, HivemqV5Client client) {
        this.destination = destination;
        this.client = client;
    }

    public void doStart() {
        this.client.subscribeTo(this.destination.getName(), new Callback());
    }

    protected void doStop() {
        this.client.unsubscribeFrom(this.destination.getName());
    }

    private class Callback
    implements HivemqV5Client.ArrivedCallback {
        private Callback() {
        }

        @Override
        public void messageArrived(String topic, byte[] payload) {
            Message msg = MessageBuilder.withPayload((Object)payload).build();
            HivemqV5MessageProducer.this.sendMessage(msg);
        }
    }
}

