/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.transport.spring.binder.hivemqv5;

import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.TimeUtils;
import de.iip_ecosphere.platform.transport.connectors.ReceptionCallback;
import de.iip_ecosphere.platform.transport.connectors.TransportParameter;
import de.iip_ecosphere.platform.transport.mqttv5.PahoMqttV5TransportConnector;
import de.iip_ecosphere.platform.transport.serialization.SerializerRegistry;
import de.iip_ecosphere.platform.transport.spring.SerializerMessageConverter;
import de.iip_ecosphere.platform.transport.spring.binder.hivemqv5.HivemqV5Client;
import java.io.File;
import java.io.IOException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.util.TestPropertyValues;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestPropertySource;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.util.MimeType;
import test.de.iip_ecosphere.platform.test.mqtt.hivemq.TestHiveMqServer;
import test.de.iip_ecosphere.platform.transport.spring.StringSerializer;

@SpringBootTest
@TestPropertySource(locations={"classpath:test.properties"})
@ContextConfiguration(initializers={Initializer.class})
@RunWith(value=SpringRunner.class)
public class HivemqV5MessageBinderTest {
    private static ServerAddress addr = new ServerAddress(Schema.IGNORE);
    private static TestHiveMqServer server;
    private static String received;
    private static File secCfg;
    @Autowired
    private TransportParameter params;

    protected static void setSecCfg(File folder) {
        secCfg = folder;
    }

    protected static File getKeystore() {
        return null == secCfg ? null : new File(secCfg, "keystore.jks");
    }

    protected static String getKeystorePassword() {
        return null == secCfg ? null : "a1234567";
    }

    protected static ServerAddress resetAddr(Schema schema) {
        received = null;
        addr = new ServerAddress(schema);
        return addr;
    }

    @BeforeClass
    public static void init() {
        TestHiveMqServer.setConfigDir((File)secCfg);
        server = new TestHiveMqServer(addr);
        server.start();
        TimeUtils.sleep((int)1000);
        SerializerRegistry.registerSerializer(StringSerializer.class);
        final PahoMqttV5TransportConnector infra = new PahoMqttV5TransportConnector();
        try {
            TransportParameter.TransportParameterBuilder tpBuilder = TransportParameter.TransportParameterBuilder.newBuilder((ServerAddress)addr).setApplicationId("infra");
            if (null != secCfg) {
                tpBuilder.setKeystore(HivemqV5MessageBinderTest.getKeystore(), HivemqV5MessageBinderTest.getKeystorePassword());
                tpBuilder.setActionTimeout(3000);
            }
            infra.connect(tpBuilder.build());
            infra.setReceptionCallback("hivemqBinder", (ReceptionCallback)new ReceptionCallback<String>(){

                public void received(String data) {
                    try {
                        infra.asyncSend("input2", (Object)("config " + data));
                    }
                    catch (IOException e) {
                        System.out.println("SEND PROBLEM " + e.getMessage());
                    }
                }

                public Class<String> getType() {
                    return String.class;
                }
            });
        }
        catch (IOException e) {
            System.out.println("CONNECTOR PROBLEM " + e.getMessage());
        }
        System.out.println("Started infra client on " + addr.getHost() + " " + addr.getPort());
        TimeUtils.sleep((int)1000);
    }

    @AfterClass
    public static void shutdown() {
        if (HivemqV5Client.getLastInstance() != null) {
            HivemqV5Client.getLastInstance().stopClient();
        }
        server.stop(true);
        SerializerRegistry.unregisterSerializer(StringSerializer.class);
        SerializerRegistry.resetDefaults();
    }

    @Test
    public void testMessages() {
        TimeUtils.sleep((int)2000);
        Assert.assertEquals((String)"Received value on configuration stream does not match", (Object)"config DMG-1 world", (Object)received);
        Assert.assertNotNull((String)"The autowired transport parameters shall not be null", (Object)this.params);
        Assert.assertEquals((Object)"localhost", (Object)this.params.getHost());
        Assert.assertEquals((Object)"test", (Object)this.params.getApplicationId());
    }

    @SpringBootApplication
    public static class MyProcessor {
        @Bean
        public Supplier<String> in() {
            return () -> "DMG-1";
        }

        @Bean
        public Function<String, String> transform() {
            return in -> in + " world";
        }

        @Bean
        public Consumer<String> receiveInput() {
            return s -> received = s;
        }

        @Bean
        public MessageConverter customMessageConverter() {
            return new SerializerMessageConverter(new MimeType("application", "ser-string"));
        }
    }

    public static class Initializer
    implements ApplicationContextInitializer<ConfigurableApplicationContext> {
        public void initialize(ConfigurableApplicationContext applicationContext) {
            TestPropertyValues.of((String[])new String[]{"mqtt.port=" + addr.getPort()}).applyTo(applicationContext);
            if (null == HivemqV5Client.getLastInstance() && null != HivemqV5MessageBinderTest.getKeystore()) {
                TestPropertyValues.of((String[])new String[]{"mqtt.keystore=" + HivemqV5MessageBinderTest.getKeystore(), "mqtt.keyPassword=" + HivemqV5MessageBinderTest.getKeystorePassword(), "mqtt.keyAlias=qpid"}).applyTo(applicationContext);
            }
        }
    }
}

