/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.transport.mqttv5;

import de.iip_ecosphere.platform.support.net.SslUtils;
import de.iip_ecosphere.platform.transport.connectors.ReceptionCallback;
import de.iip_ecosphere.platform.transport.connectors.TransportParameter;
import de.iip_ecosphere.platform.transport.connectors.basics.AbstractMqttTransportConnector;
import de.iip_ecosphere.platform.transport.connectors.basics.MqttQoS;
import java.io.File;
import java.io.IOException;
import javax.net.SocketFactory;
import org.eclipse.paho.mqttv5.client.IMqttToken;
import org.eclipse.paho.mqttv5.client.MqttAsyncClient;
import org.eclipse.paho.mqttv5.client.MqttCallback;
import org.eclipse.paho.mqttv5.client.MqttClientPersistence;
import org.eclipse.paho.mqttv5.client.MqttConnectionOptions;
import org.eclipse.paho.mqttv5.client.MqttDisconnectResponse;
import org.eclipse.paho.mqttv5.client.persist.MemoryPersistence;
import org.eclipse.paho.mqttv5.common.MqttException;
import org.eclipse.paho.mqttv5.common.MqttMessage;
import org.eclipse.paho.mqttv5.common.packet.MqttProperties;
import org.slf4j.LoggerFactory;

public class PahoMqttV5TransportConnector
extends AbstractMqttTransportConnector {
    public static final String NAME = "MQTT v5";
    private MqttAsyncClient client;
    private boolean tlsEnabled = false;
    private int qos = MqttQoS.AT_LEAST_ONCE.value();

    public void connect(TransportParameter params) throws IOException {
        super.connect(params);
        this.qos = params.getMqttQoS().value();
        try {
            String broker = params.getKeystore() != null ? "ssl://" : "tcp://";
            broker = broker + params.getHost() + ":" + params.getPort();
            this.client = new MqttAsyncClient(broker, this.getApplicationId(), (MqttClientPersistence)new MemoryPersistence());
            this.client.setCallback((MqttCallback)new Callback());
            MqttConnectionOptions connOpts = new MqttConnectionOptions();
            connOpts.setCleanStart(false);
            connOpts.setKeepAliveInterval(params.getKeepAlive());
            connOpts.setAutomaticReconnect(true);
            if (null != params.getKeystore()) {
                try {
                    connOpts.setHttpsHostnameVerificationEnabled(params.getHostnameVerification());
                    connOpts.setSocketFactory((SocketFactory)SslUtils.createTlsContext((File)params.getKeystore(), (String)params.getKeystorePassword(), (String)params.getKeyAlias()).getSocketFactory());
                    this.tlsEnabled = true;
                }
                catch (IOException e) {
                    LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("MQTT: Loading keystore " + e.getMessage() + ". Trying with no TLS.");
                }
            }
            this.waitForCompletion(this.client.connect(connOpts));
        }
        catch (MqttException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public void setReceptionCallback(String stream, ReceptionCallback<?> callback) throws IOException {
        super.setReceptionCallback(stream, callback);
        try {
            this.waitForCompletion(this.client.subscribe(stream, MqttQoS.AT_LEAST_ONCE.value()));
        }
        catch (MqttException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public void unsubscribe(String stream, boolean delete) throws IOException {
        super.unsubscribe(stream, delete);
        try {
            this.waitForCompletion(this.client.unsubscribe(stream));
        }
        catch (MqttException e) {
            throw new IOException(e);
        }
    }

    public void disconnect() throws IOException {
        super.disconnect();
        try {
            this.waitForCompletion(this.client.disconnect());
            this.client.close();
        }
        catch (MqttException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public void asyncSend(String stream, Object data) throws IOException {
        this.send(stream, data, false);
    }

    public void syncSend(String stream, Object data) throws IOException {
        this.send(stream, data, true);
    }

    private void send(String stream, Object data, boolean block) throws IOException {
        byte[] payload = this.serialize(stream, data);
        MqttMessage message = new MqttMessage(payload);
        message.setQos(this.qos);
        try {
            IMqttToken token = this.client.publish(stream, message);
            if (block) {
                this.waitForCompletion(token);
            }
        }
        catch (MqttException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    private void waitForCompletion(IMqttToken token) throws MqttException {
        token.waitForCompletion((long)this.getActionTimeout());
    }

    public String getName() {
        return NAME;
    }

    public String supportedEncryption() {
        return "TLS";
    }

    public String enabledEncryption() {
        return this.tlsEnabled ? "TLS" : null;
    }

    private class Callback
    implements MqttCallback {
        private Callback() {
        }

        public void messageArrived(String topic, MqttMessage message) throws Exception {
            PahoMqttV5TransportConnector.this.notifyCallback(topic, message.getPayload());
        }

        public void disconnected(MqttDisconnectResponse disconnectResponse) {
        }

        public void mqttErrorOccurred(MqttException exception) {
        }

        public void deliveryComplete(IMqttToken token) {
        }

        public void connectComplete(boolean reconnect, String serverURI) {
        }

        public void authPacketArrived(int reasonCode, MqttProperties properties) {
        }
    }
}

