/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.transport.mqttv5;

import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.transport.TransportFactory;
import de.iip_ecosphere.platform.transport.connectors.TransportParameter;
import java.io.File;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import test.de.iip_ecosphere.platform.test.mqtt.hivemq.TestHiveMqServer;
import test.de.iip_ecosphere.platform.transport.AbstractTransportConnectorTest;
import test.de.iip_ecosphere.platform.transport.ProductJsonSerializer;
import test.de.iip_ecosphere.platform.transport.ProductProtobufSerializer;

public class PahoMqttV5TransportConnectorTest {
    @Test(timeout=180000L)
    public void testPahoConnector() throws IOException {
        TestHiveMqServer.setConfigDir(null);
        this.doTest(null);
    }

    @Test(timeout=540000L)
    public void testPahoTlsConnector() throws IOException {
        final File secCfg = new File("./src/test/secCfg");
        TestHiveMqServer.setConfigDir((File)secCfg);
        this.doTest(new AbstractTransportConnectorTest.TransportParameterConfigurer(){

            public void configure(TransportParameter.TransportParameterBuilder builder) {
                builder.setKeystore(new File(secCfg, "client-trust-store.jks"), "a1234567");
                builder.setKeyAlias("qpid");
            }
        });
    }

    private void doTest(AbstractTransportConnectorTest.TransportParameterConfigurer configurer) throws IOException {
        Assert.assertEquals((Object)"MQTT v5", (Object)TransportFactory.getConnectorName());
        ServerAddress addr = new ServerAddress(Schema.IGNORE);
        TestHiveMqServer server = new TestHiveMqServer(addr);
        server.start();
        try {
            AbstractTransportConnectorTest.doTest((ServerAddress)addr, ProductJsonSerializer.class, (AbstractTransportConnectorTest.TransportParameterConfigurer)configurer);
            AbstractTransportConnectorTest.doTest((ServerAddress)addr, ProductProtobufSerializer.class, (AbstractTransportConnectorTest.TransportParameterConfigurer)configurer);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            server.stop(true);
        }
    }
}

