/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.transport.mqttv3;

import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.transport.TransportFactory;
import de.iip_ecosphere.platform.transport.connectors.TransportParameter;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.BasicConfigurator;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import test.de.iip_ecosphere.platform.test.mqtt.moquette.TestMoquetteServer;
import test.de.iip_ecosphere.platform.transport.AbstractTransportConnectorTest;
import test.de.iip_ecosphere.platform.transport.ProductJsonSerializer;
import test.de.iip_ecosphere.platform.transport.ProductProtobufSerializer;

public class PahoMqttV3TransportConnectorTest {
    @BeforeClass
    public static void init() {
        BasicConfigurator.configure();
    }

    @Test
    public void testPahoConnector() throws IOException {
        TestMoquetteServer.setConfigDir(null);
        TestMoquetteServer.setBasicAuth((String)"user", (String)"user");
        this.doTest(new AbstractTransportConnectorTest.TransportParameterConfigurer(){

            public void configure(TransportParameter.TransportParameterBuilder builder) {
                builder.setAuthenticationKey("mqttAuth");
            }
        });
        TestMoquetteServer.clearAuth();
    }

    @Test
    public void testPahoTlsConnector() throws IOException {
        File secCfg = new File("./src/test/secCfg");
        TestMoquetteServer.setConfigDir((File)secCfg);
        this.doTest(new AbstractTransportConnectorTest.TransportParameterConfigurer(){

            public void configure(TransportParameter.TransportParameterBuilder builder) {
                builder.setKeystoreKey("mqttKeyStore");
                builder.setKeyAlias("qpid");
                builder.setActionTimeout(3000);
            }
        });
    }

    private void doTest(AbstractTransportConnectorTest.TransportParameterConfigurer configurer) throws IOException {
        Assert.assertEquals((Object)"MQTT v3", (Object)TransportFactory.getConnectorName());
        ServerAddress addr = new ServerAddress(Schema.IGNORE);
        TestMoquetteServer server = new TestMoquetteServer(addr);
        server.start();
        AbstractTransportConnectorTest.doTest((ServerAddress)addr, ProductJsonSerializer.class, (AbstractTransportConnectorTest.TransportParameterConfigurer)configurer);
        AbstractTransportConnectorTest.doTest((ServerAddress)addr, ProductProtobufSerializer.class, (AbstractTransportConnectorTest.TransportParameterConfigurer)configurer);
        server.stop(true);
    }
}

