/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.test.mqtt.moquette;

import de.iip_ecosphere.platform.support.NetUtils;
import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.ServerAddress;
import io.moquette.broker.Server;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.apache.log4j.BasicConfigurator;
import org.slf4j.LoggerFactory;
import test.de.iip_ecosphere.platform.transport.AbstractTestServer;

public class TestMoquetteServer
extends AbstractTestServer {
    public static final String KEYSTORE_PASSWORD = "a1234567";
    public static final String KEY_ALIAS = "qpid";
    private Server mqttBroker;
    private ServerAddress addr;

    public TestMoquetteServer(ServerAddress addr) {
        this.addr = addr;
    }

    public de.iip_ecosphere.platform.support.Server start() {
        if (null == this.mqttBroker) {
            Properties properties = new Properties();
            properties.setProperty("host", this.addr.getHost());
            properties.setProperty("allow_anonymous", "true");
            File cfgDir = TestMoquetteServer.getConfigDir((String)"./src/test");
            File f = new File(cfgDir, "keystore.jks");
            if (f.exists()) {
                properties.setProperty("jks_path", f.getAbsolutePath());
                properties.setProperty("ssl_provider", "JDK");
                properties.setProperty("key_store_type", "jks");
                properties.setProperty("key_store_password", KEYSTORE_PASSWORD);
                properties.setProperty("key_manager_password", KEYSTORE_PASSWORD);
                properties.setProperty("ssl_port", String.valueOf(this.addr.getPort()));
                properties.setProperty("port", String.valueOf(NetUtils.getEphemeralPort()));
            } else {
                properties.setProperty("port", String.valueOf(this.addr.getPort()));
            }
            this.mqttBroker = new Server();
            try {
                this.mqttBroker.startServer(properties);
            }
            catch (IOException e) {
                LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(e.getMessage());
                this.mqttBroker = null;
            }
        }
        return this;
    }

    public void stop(boolean dispose) {
        if (null != this.mqttBroker) {
            this.mqttBroker.stopServer();
            this.mqttBroker = null;
        }
    }

    public static void main(String[] args) {
        BasicConfigurator.configure();
        TestMoquetteServer server = new TestMoquetteServer(new ServerAddress(Schema.IGNORE, TestMoquetteServer.getInteger((String[])args, (int)8883)));
        server.start();
    }
}

