/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.test.mqtt.hivemq;

import com.hivemq.embedded.EmbeddedHiveMQ;
import com.hivemq.embedded.EmbeddedHiveMQBuilder;
import de.iip_ecosphere.platform.support.FileUtils;
import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.Server;
import de.iip_ecosphere.platform.support.ServerAddress;
import java.io.File;
import test.de.iip_ecosphere.platform.transport.AbstractTestServer;

public class TestHiveMqServer
extends AbstractTestServer {
    private EmbeddedHiveMQ hiveMQ;
    private ServerAddress addr;

    public TestHiveMqServer(ServerAddress addr) {
        this.addr = addr;
    }

    public Server start() {
        if (null == this.hiveMQ) {
            File hiveTmp = FileUtils.createTmpFolder((String)"hivemq_v5");
            System.setProperty("HIVEMQ_PORT", Integer.toString(this.addr.getPort()));
            System.setProperty("HIVEMQ_ADDRESS", this.addr.getHost());
            System.setProperty("hivemq.log.folder", hiveTmp.getAbsolutePath());
            System.setProperty("hivemq.data.folder", hiveTmp.getAbsolutePath());
            File cfg = TestHiveMqServer.getConfigDir((String)"./src/test");
            EmbeddedHiveMQBuilder embeddedHiveMQBuilder = EmbeddedHiveMQBuilder.builder().withConfigurationFolder(cfg.toPath()).withDataFolder(hiveTmp.toPath()).withExtensionsFolder(new File(cfg, "extensions").toPath());
            this.hiveMQ = embeddedHiveMQBuilder.build();
            this.hiveMQ.start().join();
        }
        return this;
    }

    public void stop(boolean dispose) {
        this.hiveMQ.stop().join();
        this.hiveMQ = null;
    }

    public static void main(String[] args) {
        TestHiveMqServer server = new TestHiveMqServer(new ServerAddress(Schema.IGNORE, TestHiveMqServer.getInteger((String[])args, (int)8883)));
        server.start();
    }
}

