/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.support.semanticId.eclass;

import de.iip_ecosphere.platform.support.semanticId.DefaultSemanticIdResolutionResult;
import de.iip_ecosphere.platform.support.semanticId.SemanticIdResolutionResult;
import de.iip_ecosphere.platform.support.semanticId.SemanticIdResolver;
import de.iip_ecosphere.platform.support.semanticId.eclass.EclassSemanticIdResolver;
import de.iip_ecosphere.platform.support.semanticId.eclass.model.TranslatableLabel;
import java.io.File;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import org.junit.Assert;
import org.junit.Test;

public class EclassSemanticIdResolverTest {
    private static final String IRDI_UNIT_DEGREES_CELSIUS = "0173-1#05-AAA567#004";

    @Test
    public void testResolution() {
        if (new File("./resources.ipr").exists() || new File("./resources").exists()) {
            EclassSemanticIdResolver resolver = new EclassSemanticIdResolver();
            SemanticIdResolutionResult res = resolver.resolveSemanticId(IRDI_UNIT_DEGREES_CELSIUS);
            Assert.assertNotNull((Object)res);
            Assert.assertEquals((Object)IRDI_UNIT_DEGREES_CELSIUS, (Object)res.getSemanticId());
            Assert.assertNotNull((Object)res.getKind());
            Assert.assertNotNull((Object)res.getPublisher());
            Assert.assertNotNull((Object)res.getRevision());
            Assert.assertNotNull((Object)res.getVersion());
            Assert.assertNotNull((Object)res.getNaming());
        }
    }

    @Test
    public void testInstance() {
        Assert.assertTrue((boolean)SemanticIdResolver.hasResolver(EclassSemanticIdResolver.class));
        EclassSemanticIdResolver resolver = new EclassSemanticIdResolver();
        Assert.assertTrue((boolean)resolver.isResponsible(IRDI_UNIT_DEGREES_CELSIUS));
        Assert.assertFalse((boolean)resolver.isResponsible("0173-1#05#AAA567-004"));
        Assert.assertFalse((boolean)resolver.isResponsible("abba"));
        DefaultSemanticIdResolutionResult res = EclassSemanticIdResolver.createInstance((String)IRDI_UNIT_DEGREES_CELSIUS);
        Assert.assertNotNull((Object)res);
        Assert.assertEquals((Object)IRDI_UNIT_DEGREES_CELSIUS, (Object)res.getSemanticId());
        Assert.assertNotNull((Object)res.getKind());
        Assert.assertNotNull((Object)res.getPublisher());
        Assert.assertEquals((Object)"1", (Object)res.getRevision());
        Assert.assertEquals((Object)"4", (Object)res.getVersion());
        Map naming = EclassSemanticIdResolver.createNaming(null, null, null);
        Assert.assertNotNull((Object)naming);
        Assert.assertTrue((boolean)naming.isEmpty());
        TranslatableLabel p = new TranslatableLabel();
        p.put((Object)Locale.GERMAN.toString(), (Object)"Deutsch");
        p.put((Object)Locale.ENGLISH.toLanguageTag(), (Object)"English");
        TranslatableLabel s = new TranslatableLabel();
        s.put((Object)Locale.GERMAN.toString(), (Object)"Deutsch!");
        s.put((Object)Locale.ENGLISH.toLanguageTag(), (Object)"English!");
        TranslatableLabel d = new TranslatableLabel();
        s.put((Object)Locale.GERMAN.toString(), (Object)"D1");
        s.put((Object)Locale.ENGLISH.toLanguageTag(), (Object)"E1");
        naming = EclassSemanticIdResolver.createNaming((TranslatableLabel)p, null, null);
        this.assertNaming(p, naming, n -> n.getName());
        naming = EclassSemanticIdResolver.createNaming(null, (TranslatableLabel)s, null);
        this.assertNaming(s, naming, n -> n.getStructuredName());
        naming = EclassSemanticIdResolver.createNaming((TranslatableLabel)p, (TranslatableLabel)s, (TranslatableLabel)d);
        this.assertNaming(p, naming, n -> n.getName());
        this.assertNaming(s, naming, n -> n.getStructuredName());
        this.assertNaming(d, naming, n -> n.getDescription());
    }

    private void assertNaming(TranslatableLabel label, Map<String, DefaultSemanticIdResolutionResult.DefaultNaming> naming, Function<DefaultSemanticIdResolutionResult.DefaultNaming, String> namingGetter) {
        for (Map.Entry e : label.entrySet()) {
            Locale loc = new Locale((String)e.getKey());
            DefaultSemanticIdResolutionResult.DefaultNaming n = naming.get(loc.getLanguage());
            Assert.assertNotNull((Object)n);
            Assert.assertEquals(e.getValue(), (Object)namingGetter.apply(n));
        }
    }
}

