/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.semanticId.eclass.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import de.iip_ecosphere.platform.support.semanticId.eclass.model.AllOfvalueDataReferencedClass;
import de.iip_ecosphere.platform.support.semanticId.eclass.model.AllOfvalueDataUnit;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

public class ValueData {
    @JsonProperty(value="value")
    private String value = null;
    @JsonProperty(value="valueDataType")
    private ValueDataTypeEnum valueDataType = null;
    @JsonProperty(value="unit")
    private AllOfvalueDataUnit unit = null;
    @JsonProperty(value="referencedClass")
    private AllOfvalueDataReferencedClass referencedClass = null;

    public ValueData value(String value) {
        this.value = value;
        return this;
    }

    @Schema(required=true, description="The coded value (required for all data types except Reference)<br />must match the selected data type (especially important when selecting data types time, date, timestamp or rational)")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public ValueData valueDataType(ValueDataTypeEnum valueDataType) {
        this.valueDataType = valueDataType;
        return this;
    }

    @Schema(required=true, description="")
    public ValueDataTypeEnum getValueDataType() {
        return this.valueDataType;
    }

    public void setValueDataType(ValueDataTypeEnum valueDataType) {
        this.valueDataType = valueDataType;
    }

    public ValueData unit(AllOfvalueDataUnit unit) {
        this.unit = unit;
        return this;
    }

    @Schema(description="<span style='color: red;'>Important:</span> Used only with the following value data types:<ul><li>Real (measure)</li></ul>")
    public AllOfvalueDataUnit getUnit() {
        return this.unit;
    }

    public void setUnit(AllOfvalueDataUnit unit) {
        this.unit = unit;
    }

    public ValueData referencedClass(AllOfvalueDataReferencedClass referencedClass) {
        this.referencedClass = referencedClass;
        return this;
    }

    @Schema(description="<span style='color: red;'>Important:</span> Used only with the following value data types:<ul><li>Reference</li></ul>")
    public AllOfvalueDataReferencedClass getReferencedClass() {
        return this.referencedClass;
    }

    public void setReferencedClass(AllOfvalueDataReferencedClass referencedClass) {
        this.referencedClass = referencedClass;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValueData valueData = (ValueData)o;
        return Objects.equals(this.value, valueData.value) && Objects.equals((Object)this.valueDataType, (Object)valueData.valueDataType) && Objects.equals(this.unit, valueData.unit) && Objects.equals(this.referencedClass, valueData.referencedClass);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.value, this.valueDataType, this.unit, this.referencedClass});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ValueData {\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    valueDataType: ").append(this.toIndentedString((Object)this.valueDataType)).append("\n");
        sb.append("    unit: ").append(this.toIndentedString(this.unit)).append("\n");
        sb.append("    referencedClass: ").append(this.toIndentedString(this.referencedClass)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ValueDataTypeEnum {
        DATE("Date"),
        INTEGER_COUNT_("Integer (count)"),
        RATIONAL_COUNT_("Rational (count)"),
        REAL_COUNT_("Real (count)"),
        REAL_MEASURE_("Real (measure)"),
        REFERENCE("Reference"),
        STRING("String"),
        TIME("Time"),
        TIMESTAMP("Timestamp");

        private String value;

        private ValueDataTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ValueDataTypeEnum fromValue(String text) {
            for (ValueDataTypeEnum b : ValueDataTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

