/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.semanticId.eclass.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import de.iip_ecosphere.platform.support.semanticId.eclass.model.Definition;
import de.iip_ecosphere.platform.support.semanticId.eclass.model.LevelType;
import de.iip_ecosphere.platform.support.semanticId.eclass.model.PreferredName;
import de.iip_ecosphere.platform.support.semanticId.eclass.model.StructureElementLink;
import de.iip_ecosphere.platform.support.semanticId.eclass.model.StructureElementSystemData;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ReadProperty
extends StructureElementSystemData {
    @JsonProperty(value="preferredName")
    private PreferredName preferredName = null;
    @JsonProperty(value="definition")
    private Definition definition = null;
    @JsonProperty(value="propertyType")
    private PropertyTypeEnum propertyType = null;
    @JsonProperty(value="propertyDataType")
    private PropertyDataTypeEnum propertyDataType = null;
    @JsonProperty(value="isLevelType")
    private Boolean isLevelType = false;
    @JsonProperty(value="isMultivalent")
    private Boolean isMultivalent = null;
    @JsonProperty(value="suggestedValueList")
    private Boolean suggestedValueList = null;
    @JsonProperty(value="definedLevels")
    private List<LevelType> definedLevels = null;
    @JsonProperty(value="unit")
    private Object unit = null;
    @JsonProperty(value="alternativeUnits")
    private List<StructureElementLink> alternativeUnits = null;
    @JsonProperty(value="quantity")
    private Object quantity = null;
    @JsonProperty(value="currency")
    private Object currency = null;
    @JsonProperty(value="referencedClass")
    private Object referencedClass = null;
    @JsonProperty(value="conditionProperties")
    private List<StructureElementLink> conditionProperties = null;
    @JsonProperty(value="dependentProperties")
    private List<StructureElementLink> dependentProperties = null;
    @JsonProperty(value="valueList")
    private Object valueList = null;
    @JsonProperty(value="synonyms")
    private List<StructureElementLink> synonyms = null;

    public ReadProperty preferredName(PreferredName preferredName) {
        this.preferredName = preferredName;
        return this;
    }

    @Schema(description="")
    public PreferredName getPreferredName() {
        return this.preferredName;
    }

    public void setPreferredName(PreferredName preferredName) {
        this.preferredName = preferredName;
    }

    public ReadProperty definition(Definition definition) {
        this.definition = definition;
        return this;
    }

    @Schema(description="")
    public Definition getDefinition() {
        return this.definition;
    }

    public void setDefinition(Definition definition) {
        this.definition = definition;
    }

    public ReadProperty propertyType(PropertyTypeEnum propertyType) {
        this.propertyType = propertyType;
        return this;
    }

    @Schema(required=true, description="")
    public PropertyTypeEnum getPropertyType() {
        return this.propertyType;
    }

    public void setPropertyType(PropertyTypeEnum propertyType) {
        this.propertyType = propertyType;
    }

    public ReadProperty propertyDataType(PropertyDataTypeEnum propertyDataType) {
        this.propertyDataType = propertyDataType;
        return this;
    }

    @Schema(required=true, description="")
    public PropertyDataTypeEnum getPropertyDataType() {
        return this.propertyDataType;
    }

    public void setPropertyDataType(PropertyDataTypeEnum propertyDataType) {
        this.propertyDataType = propertyDataType;
    }

    public ReadProperty isLevelType(Boolean isLevelType) {
        this.isLevelType = isLevelType;
        return this;
    }

    @Schema(description="Property is of level type<br /><span style='color: red;'>Important:</span> Used only with the following property data types:<ul>          <li>Integer (measure)</li>          <li>Rational (measure)</li>          <li>Real (measure)</li>          <li>Integer (count)</li>          <li>Rational (count)</li>          <li>Real (count)</li>          <li>Integer (currency)</li>          <li>Real (currency)</li>        <li>Date</li>          <li>Time</li>          <li>Timestamp</li>          <ul>")
    public Boolean isIsLevelType() {
        return this.isLevelType;
    }

    public void setIsLevelType(Boolean isLevelType) {
        this.isLevelType = isLevelType;
    }

    public ReadProperty isMultivalent(Boolean isMultivalent) {
        this.isMultivalent = isMultivalent;
        return this;
    }

    @Schema(example="true", description="")
    public Boolean isIsMultivalent() {
        return this.isMultivalent;
    }

    public void setIsMultivalent(Boolean isMultivalent) {
        this.isMultivalent = isMultivalent;
    }

    public ReadProperty suggestedValueList(Boolean suggestedValueList) {
        this.suggestedValueList = suggestedValueList;
        return this;
    }

    @Schema(example="true", description="")
    public Boolean isSuggestedValueList() {
        return this.suggestedValueList;
    }

    public void setSuggestedValueList(Boolean suggestedValueList) {
        this.suggestedValueList = suggestedValueList;
    }

    public ReadProperty definedLevels(List<LevelType> definedLevels) {
        this.definedLevels = definedLevels;
        return this;
    }

    public ReadProperty addDefinedLevelsItem(LevelType definedLevelsItem) {
        if (this.definedLevels == null) {
            this.definedLevels = new ArrayList<LevelType>();
        }
        this.definedLevels.add(definedLevelsItem);
        return this;
    }

    @Schema(description="If isLevelType is true, 1-4 of the levels MIN, MAX, NOM, TYP can be defined for the property")
    public List<LevelType> getDefinedLevels() {
        return this.definedLevels;
    }

    public void setDefinedLevels(List<LevelType> definedLevels) {
        this.definedLevels = definedLevels;
    }

    public ReadProperty unit(Object unit) {
        this.unit = unit;
        return this;
    }

    @Schema(description="<span style='color: red;'>Important:</span> Used only with the following property data types:<ul>          <li>Integer (measure)</li>          <li>Rational (measure)</li>          <li>Real (measure)</li></ul>")
    public Object getUnit() {
        return this.unit;
    }

    public void setUnit(Object unit) {
        this.unit = unit;
    }

    @Schema(description="")
    public List<StructureElementLink> getAlternativeUnits() {
        return this.alternativeUnits;
    }

    public ReadProperty quantity(Object quantity) {
        this.quantity = quantity;
        return this;
    }

    @Schema(description="<span style='color: red;'>Important:</span> Used only with the following property data types:<ul>          <li>Integer (measure)</li>          <li>Rational (measure)</li>          <li>Real (measure)</li></ul>")
    public Object getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Object quantity) {
        this.quantity = quantity;
    }

    public ReadProperty currency(Object currency) {
        this.currency = currency;
        return this;
    }

    @Schema(description="<span style='color: red;'>Important:</span> Used only with the following property data types:<ul> <li>Integer (currency)</li><li>Real (currency)</li></ul>")
    public Object getCurrency() {
        return this.currency;
    }

    public void setCurrency(Object currency) {
        this.currency = currency;
    }

    public ReadProperty referencedClass(Object referencedClass) {
        this.referencedClass = referencedClass;
        return this;
    }

    @Schema(description="<span style='color: red;'>Important:</span> Used only with the following property data types:<ul><li>Reference</li></ul>")
    public Object getReferencedClass() {
        return this.referencedClass;
    }

    public void setReferencedClass(Object referencedClass) {
        this.referencedClass = referencedClass;
    }

    @Schema(description="If propertyType is dependent, the property may depend on condition properties")
    public List<StructureElementLink> getConditionProperties() {
        return this.conditionProperties;
    }

    @Schema(description="If propertyType is condition, the property may have depend properties")
    public List<StructureElementLink> getDependentProperties() {
        return this.dependentProperties;
    }

    @Schema(description="Assigned value list")
    public Object getValueList() {
        return this.valueList;
    }

    @Schema(description="Assigned synonyms")
    public List<StructureElementLink> getSynonyms() {
        return this.synonyms;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReadProperty readProperty = (ReadProperty)o;
        return Objects.equals(this.preferredName, readProperty.preferredName) && Objects.equals(this.definition, readProperty.definition) && Objects.equals((Object)this.propertyType, (Object)readProperty.propertyType) && Objects.equals((Object)this.propertyDataType, (Object)readProperty.propertyDataType) && Objects.equals(this.isLevelType, readProperty.isLevelType) && Objects.equals(this.isMultivalent, readProperty.isMultivalent) && Objects.equals(this.suggestedValueList, readProperty.suggestedValueList) && Objects.equals(this.definedLevels, readProperty.definedLevels) && Objects.equals(this.unit, readProperty.unit) && Objects.equals(this.alternativeUnits, readProperty.alternativeUnits) && Objects.equals(this.quantity, readProperty.quantity) && Objects.equals(this.currency, readProperty.currency) && Objects.equals(this.referencedClass, readProperty.referencedClass) && Objects.equals(this.conditionProperties, readProperty.conditionProperties) && Objects.equals(this.dependentProperties, readProperty.dependentProperties) && Objects.equals(this.valueList, readProperty.valueList) && Objects.equals(this.synonyms, readProperty.synonyms) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.preferredName, this.definition, this.propertyType, this.propertyDataType, this.isLevelType, this.isMultivalent, this.suggestedValueList, this.definedLevels, this.unit, this.alternativeUnits, this.quantity, this.currency, this.referencedClass, this.conditionProperties, this.dependentProperties, this.valueList, this.synonyms, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ReadProperty {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    preferredName: ").append(this.toIndentedString(this.preferredName)).append("\n");
        sb.append("    definition: ").append(this.toIndentedString(this.definition)).append("\n");
        sb.append("    propertyType: ").append(this.toIndentedString((Object)this.propertyType)).append("\n");
        sb.append("    propertyDataType: ").append(this.toIndentedString((Object)this.propertyDataType)).append("\n");
        sb.append("    isLevelType: ").append(this.toIndentedString(this.isLevelType)).append("\n");
        sb.append("    isMultivalent: ").append(this.toIndentedString(this.isMultivalent)).append("\n");
        sb.append("    suggestedValueList: ").append(this.toIndentedString(this.suggestedValueList)).append("\n");
        sb.append("    definedLevels: ").append(this.toIndentedString(this.definedLevels)).append("\n");
        sb.append("    unit: ").append(this.toIndentedString(this.unit)).append("\n");
        sb.append("    alternativeUnits: ").append(this.toIndentedString(this.alternativeUnits)).append("\n");
        sb.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    referencedClass: ").append(this.toIndentedString(this.referencedClass)).append("\n");
        sb.append("    conditionProperties: ").append(this.toIndentedString(this.conditionProperties)).append("\n");
        sb.append("    dependentProperties: ").append(this.toIndentedString(this.dependentProperties)).append("\n");
        sb.append("    valueList: ").append(this.toIndentedString(this.valueList)).append("\n");
        sb.append("    synonyms: ").append(this.toIndentedString(this.synonyms)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum PropertyDataTypeEnum {
        AXIS_1D("Axis 1D"),
        AXIS_2D("Axis 2D"),
        AXIS_3D("Axis 3D"),
        BOOLEAN("Boolean"),
        DATE("Date"),
        INTEGER_COUNT_("Integer (count)"),
        INTEGER_CURRENCY_("Integer (currency)"),
        INTEGER_MEASURE_("Integer (measure)"),
        RATIONAL_COUNT_("Rational (count)"),
        RATIONAL_MEASURE_("Rational (measure)"),
        REAL_COUNT_("Real (count)"),
        REAL_CURRENCY_("Real (currency)"),
        REAL_MEASURE_("Real (measure)"),
        REFERENCE("Reference"),
        STRING("String"),
        STRING_TRANSLATABLE_("String (translatable)"),
        TIME("Time"),
        TIMESTAMP("Timestamp"),
        URL("URL"),
        FILE("File"),
        BLOB("Blob");

        private String value;

        private PropertyDataTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PropertyDataTypeEnum fromValue(String text) {
            for (PropertyDataTypeEnum b : PropertyDataTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum PropertyTypeEnum {
        NON_DEPENDENT("non-dependent"),
        DEPENDENT("dependent"),
        CONDITION("condition");

        private String value;

        private PropertyTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PropertyTypeEnum fromValue(String text) {
            for (PropertyTypeEnum b : PropertyTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

