/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.semanticId.eclass.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import de.iip_ecosphere.platform.support.semanticId.eclass.model.AllOfpropertyDataCurrency;
import de.iip_ecosphere.platform.support.semanticId.eclass.model.AllOfpropertyDataQuantity;
import de.iip_ecosphere.platform.support.semanticId.eclass.model.AllOfpropertyDataReferencedClass;
import de.iip_ecosphere.platform.support.semanticId.eclass.model.AllOfpropertyDataUnit;
import de.iip_ecosphere.platform.support.semanticId.eclass.model.LevelType;
import de.iip_ecosphere.platform.support.semanticId.eclass.model.StructureElementLink;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class PropertyData {
    @JsonProperty(value="propertyType")
    private PropertyTypeEnum propertyType = null;
    @JsonProperty(value="propertyDataType")
    private PropertyDataTypeEnum propertyDataType = null;
    @JsonProperty(value="isLevelType")
    private Boolean isLevelType = false;
    @JsonProperty(value="isMultivalent")
    private Boolean isMultivalent = null;
    @JsonProperty(value="suggestedValueList")
    private Boolean suggestedValueList = null;
    @JsonProperty(value="definedLevels")
    private List<LevelType> definedLevels = null;
    @JsonProperty(value="unit")
    private AllOfpropertyDataUnit unit = null;
    @JsonProperty(value="alternativeUnits")
    private List<StructureElementLink> alternativeUnits = null;
    @JsonProperty(value="quantity")
    private AllOfpropertyDataQuantity quantity = null;
    @JsonProperty(value="currency")
    private AllOfpropertyDataCurrency currency = null;
    @JsonProperty(value="referencedClass")
    private AllOfpropertyDataReferencedClass referencedClass = null;
    @JsonProperty(value="conditionProperties")
    private List<StructureElementLink> conditionProperties = null;
    @JsonProperty(value="dependentProperties")
    private List<StructureElementLink> dependentProperties = null;

    public PropertyData propertyType(PropertyTypeEnum propertyType) {
        this.propertyType = propertyType;
        return this;
    }

    @Schema(required=true, description="")
    public PropertyTypeEnum getPropertyType() {
        return this.propertyType;
    }

    public void setPropertyType(PropertyTypeEnum propertyType) {
        this.propertyType = propertyType;
    }

    public PropertyData propertyDataType(PropertyDataTypeEnum propertyDataType) {
        this.propertyDataType = propertyDataType;
        return this;
    }

    @Schema(required=true, description="")
    public PropertyDataTypeEnum getPropertyDataType() {
        return this.propertyDataType;
    }

    public void setPropertyDataType(PropertyDataTypeEnum propertyDataType) {
        this.propertyDataType = propertyDataType;
    }

    public PropertyData isLevelType(Boolean isLevelType) {
        this.isLevelType = isLevelType;
        return this;
    }

    @Schema(description="Property is of level type<br /><span style='color: red;'>Important:</span> Used only with the following property data types:<ul>          <li>Integer (measure)</li>          <li>Rational (measure)</li>          <li>Real (measure)</li>          <li>Integer (count)</li>          <li>Rational (count)</li>          <li>Real (count)</li>          <li>Integer (currency)</li>          <li>Real (currency)</li>        <li>Date</li>          <li>Time</li>          <li>Timestamp</li>          <ul>")
    public Boolean isIsLevelType() {
        return this.isLevelType;
    }

    public void setIsLevelType(Boolean isLevelType) {
        this.isLevelType = isLevelType;
    }

    public PropertyData isMultivalent(Boolean isMultivalent) {
        this.isMultivalent = isMultivalent;
        return this;
    }

    @Schema(example="true", description="")
    public Boolean isIsMultivalent() {
        return this.isMultivalent;
    }

    public void setIsMultivalent(Boolean isMultivalent) {
        this.isMultivalent = isMultivalent;
    }

    public PropertyData suggestedValueList(Boolean suggestedValueList) {
        this.suggestedValueList = suggestedValueList;
        return this;
    }

    @Schema(example="true", description="")
    public Boolean isSuggestedValueList() {
        return this.suggestedValueList;
    }

    public void setSuggestedValueList(Boolean suggestedValueList) {
        this.suggestedValueList = suggestedValueList;
    }

    public PropertyData definedLevels(List<LevelType> definedLevels) {
        this.definedLevels = definedLevels;
        return this;
    }

    public PropertyData addDefinedLevelsItem(LevelType definedLevelsItem) {
        if (this.definedLevels == null) {
            this.definedLevels = new ArrayList<LevelType>();
        }
        this.definedLevels.add(definedLevelsItem);
        return this;
    }

    @Schema(description="If isLevelType is true, 1-4 of the levels MIN, MAX, NOM, TYP can be defined for the property")
    public List<LevelType> getDefinedLevels() {
        return this.definedLevels;
    }

    public void setDefinedLevels(List<LevelType> definedLevels) {
        this.definedLevels = definedLevels;
    }

    public PropertyData unit(AllOfpropertyDataUnit unit) {
        this.unit = unit;
        return this;
    }

    @Schema(description="<span style='color: red;'>Important:</span> Used only with the following property data types:<ul>          <li>Integer (measure)</li>          <li>Rational (measure)</li>          <li>Real (measure)</li></ul>")
    public AllOfpropertyDataUnit getUnit() {
        return this.unit;
    }

    public void setUnit(AllOfpropertyDataUnit unit) {
        this.unit = unit;
    }

    @Schema(description="")
    public List<StructureElementLink> getAlternativeUnits() {
        return this.alternativeUnits;
    }

    public PropertyData quantity(AllOfpropertyDataQuantity quantity) {
        this.quantity = quantity;
        return this;
    }

    @Schema(description="<span style='color: red;'>Important:</span> Used only with the following property data types:<ul>          <li>Integer (measure)</li>          <li>Rational (measure)</li>          <li>Real (measure)</li></ul>")
    public AllOfpropertyDataQuantity getQuantity() {
        return this.quantity;
    }

    public void setQuantity(AllOfpropertyDataQuantity quantity) {
        this.quantity = quantity;
    }

    public PropertyData currency(AllOfpropertyDataCurrency currency) {
        this.currency = currency;
        return this;
    }

    @Schema(description="<span style='color: red;'>Important:</span> Used only with the following property data types:<ul> <li>Integer (currency)</li><li>Real (currency)</li></ul>")
    public AllOfpropertyDataCurrency getCurrency() {
        return this.currency;
    }

    public void setCurrency(AllOfpropertyDataCurrency currency) {
        this.currency = currency;
    }

    public PropertyData referencedClass(AllOfpropertyDataReferencedClass referencedClass) {
        this.referencedClass = referencedClass;
        return this;
    }

    @Schema(description="<span style='color: red;'>Important:</span> Used only with the following property data types:<ul><li>Reference</li></ul>")
    public AllOfpropertyDataReferencedClass getReferencedClass() {
        return this.referencedClass;
    }

    public void setReferencedClass(AllOfpropertyDataReferencedClass referencedClass) {
        this.referencedClass = referencedClass;
    }

    @Schema(description="If propertyType is dependent, the property may depend on condition properties")
    public List<StructureElementLink> getConditionProperties() {
        return this.conditionProperties;
    }

    @Schema(description="If propertyType is condition, the property may have depend properties")
    public List<StructureElementLink> getDependentProperties() {
        return this.dependentProperties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertyData propertyData = (PropertyData)o;
        return Objects.equals((Object)this.propertyType, (Object)propertyData.propertyType) && Objects.equals((Object)this.propertyDataType, (Object)propertyData.propertyDataType) && Objects.equals(this.isLevelType, propertyData.isLevelType) && Objects.equals(this.isMultivalent, propertyData.isMultivalent) && Objects.equals(this.suggestedValueList, propertyData.suggestedValueList) && Objects.equals(this.definedLevels, propertyData.definedLevels) && Objects.equals(this.unit, propertyData.unit) && Objects.equals(this.alternativeUnits, propertyData.alternativeUnits) && Objects.equals(this.quantity, propertyData.quantity) && Objects.equals(this.currency, propertyData.currency) && Objects.equals(this.referencedClass, propertyData.referencedClass) && Objects.equals(this.conditionProperties, propertyData.conditionProperties) && Objects.equals(this.dependentProperties, propertyData.dependentProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.propertyType, this.propertyDataType, this.isLevelType, this.isMultivalent, this.suggestedValueList, this.definedLevels, this.unit, this.alternativeUnits, this.quantity, this.currency, this.referencedClass, this.conditionProperties, this.dependentProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PropertyData {\n");
        sb.append("    propertyType: ").append(this.toIndentedString((Object)this.propertyType)).append("\n");
        sb.append("    propertyDataType: ").append(this.toIndentedString((Object)this.propertyDataType)).append("\n");
        sb.append("    isLevelType: ").append(this.toIndentedString(this.isLevelType)).append("\n");
        sb.append("    isMultivalent: ").append(this.toIndentedString(this.isMultivalent)).append("\n");
        sb.append("    suggestedValueList: ").append(this.toIndentedString(this.suggestedValueList)).append("\n");
        sb.append("    definedLevels: ").append(this.toIndentedString(this.definedLevels)).append("\n");
        sb.append("    unit: ").append(this.toIndentedString(this.unit)).append("\n");
        sb.append("    alternativeUnits: ").append(this.toIndentedString(this.alternativeUnits)).append("\n");
        sb.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    referencedClass: ").append(this.toIndentedString(this.referencedClass)).append("\n");
        sb.append("    conditionProperties: ").append(this.toIndentedString(this.conditionProperties)).append("\n");
        sb.append("    dependentProperties: ").append(this.toIndentedString(this.dependentProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum PropertyDataTypeEnum {
        AXIS_1D("Axis 1D"),
        AXIS_2D("Axis 2D"),
        AXIS_3D("Axis 3D"),
        BOOLEAN("Boolean"),
        DATE("Date"),
        INTEGER_COUNT_("Integer (count)"),
        INTEGER_CURRENCY_("Integer (currency)"),
        INTEGER_MEASURE_("Integer (measure)"),
        RATIONAL_COUNT_("Rational (count)"),
        RATIONAL_MEASURE_("Rational (measure)"),
        REAL_COUNT_("Real (count)"),
        REAL_CURRENCY_("Real (currency)"),
        REAL_MEASURE_("Real (measure)"),
        REFERENCE("Reference"),
        STRING("String"),
        STRING_TRANSLATABLE_("String (translatable)"),
        TIME("Time"),
        TIMESTAMP("Timestamp"),
        URL("URL"),
        FILE("File"),
        BLOB("Blob");

        private String value;

        private PropertyDataTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PropertyDataTypeEnum fromValue(String text) {
            for (PropertyDataTypeEnum b : PropertyDataTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum PropertyTypeEnum {
        NON_DEPENDENT("non-dependent"),
        DEPENDENT("dependent"),
        CONDITION("condition");

        private String value;

        private PropertyTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PropertyTypeEnum fromValue(String text) {
            for (PropertyTypeEnum b : PropertyTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

