/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.semanticId.eclass.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import de.iip_ecosphere.platform.support.semanticId.eclass.model.AllOfblockDataParentClass;
import de.iip_ecosphere.platform.support.semanticId.eclass.model.ClassValueAssignments;
import de.iip_ecosphere.platform.support.semanticId.eclass.model.PropertyValueConstraints;
import de.iip_ecosphere.platform.support.semanticId.eclass.model.StructureElementLink;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class BlockData {
    @JsonProperty(value="parentClass")
    private AllOfblockDataParentClass parentClass = null;
    @JsonProperty(value="classType")
    private ClassTypeEnum classType = null;
    @JsonProperty(value="childBlocks")
    private List<StructureElementLink> childBlocks = null;
    @JsonProperty(value="properties")
    private List<StructureElementLink> properties = null;
    @JsonProperty(value="propertyValueConstraints")
    private PropertyValueConstraints propertyValueConstraints = null;
    @JsonProperty(value="classValueAssignments")
    private ClassValueAssignments classValueAssignments = null;

    public BlockData parentClass(AllOfblockDataParentClass parentClass) {
        this.parentClass = parentClass;
        return this;
    }

    @Schema(description="Parent class of block. when not set in a change request, the root block is assumed.")
    public AllOfblockDataParentClass getParentClass() {
        return this.parentClass;
    }

    public void setParentClass(AllOfblockDataParentClass parentClass) {
        this.parentClass = parentClass;
    }

    @Schema(description="")
    public ClassTypeEnum getClassType() {
        return this.classType;
    }

    public BlockData childBlocks(List<StructureElementLink> childBlocks) {
        this.childBlocks = childBlocks;
        return this;
    }

    public BlockData addChildBlocksItem(StructureElementLink childBlocksItem) {
        if (this.childBlocks == null) {
            this.childBlocks = new ArrayList<StructureElementLink>();
        }
        this.childBlocks.add(childBlocksItem);
        return this;
    }

    @Schema(description="")
    public List<StructureElementLink> getChildBlocks() {
        return this.childBlocks;
    }

    public void setChildBlocks(List<StructureElementLink> childBlocks) {
        this.childBlocks = childBlocks;
    }

    public BlockData properties(List<StructureElementLink> properties) {
        this.properties = properties;
        return this;
    }

    public BlockData addPropertiesItem(StructureElementLink propertiesItem) {
        if (this.properties == null) {
            this.properties = new ArrayList<StructureElementLink>();
        }
        this.properties.add(propertiesItem);
        return this;
    }

    @Schema(description="")
    public List<StructureElementLink> getProperties() {
        return this.properties;
    }

    public void setProperties(List<StructureElementLink> properties) {
        this.properties = properties;
    }

    public BlockData propertyValueConstraints(PropertyValueConstraints propertyValueConstraints) {
        this.propertyValueConstraints = propertyValueConstraints;
        return this;
    }

    @Schema(description="")
    public PropertyValueConstraints getPropertyValueConstraints() {
        return this.propertyValueConstraints;
    }

    public void setPropertyValueConstraints(PropertyValueConstraints propertyValueConstraints) {
        this.propertyValueConstraints = propertyValueConstraints;
    }

    public BlockData classValueAssignments(ClassValueAssignments classValueAssignments) {
        this.classValueAssignments = classValueAssignments;
        return this;
    }

    @Schema(description="")
    public ClassValueAssignments getClassValueAssignments() {
        return this.classValueAssignments;
    }

    public void setClassValueAssignments(ClassValueAssignments classValueAssignments) {
        this.classValueAssignments = classValueAssignments;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockData blockData = (BlockData)o;
        return Objects.equals(this.parentClass, blockData.parentClass) && Objects.equals((Object)this.classType, (Object)blockData.classType) && Objects.equals(this.childBlocks, blockData.childBlocks) && Objects.equals(this.properties, blockData.properties) && Objects.equals(this.propertyValueConstraints, blockData.propertyValueConstraints) && Objects.equals(this.classValueAssignments, blockData.classValueAssignments);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.parentClass, this.classType, this.childBlocks, this.properties, this.propertyValueConstraints, this.classValueAssignments});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BlockData {\n");
        sb.append("    parentClass: ").append(this.toIndentedString(this.parentClass)).append("\n");
        sb.append("    classType: ").append(this.toIndentedString((Object)this.classType)).append("\n");
        sb.append("    childBlocks: ").append(this.toIndentedString(this.childBlocks)).append("\n");
        sb.append("    properties: ").append(this.toIndentedString(this.properties)).append("\n");
        sb.append("    propertyValueConstraints: ").append(this.toIndentedString(this.propertyValueConstraints)).append("\n");
        sb.append("    classValueAssignments: ").append(this.toIndentedString(this.classValueAssignments)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ClassTypeEnum {
        BLOCK("block");

        private String value;

        private ClassTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ClassTypeEnum fromValue(String text) {
            for (ClassTypeEnum b : ClassTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

