/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.semanticId.eclass;

import de.iip_ecosphere.platform.support.identities.IdentityStore;
import de.iip_ecosphere.platform.support.identities.IdentityToken;
import de.iip_ecosphere.platform.support.semanticId.DefaultSemanticIdResolutionResult;
import de.iip_ecosphere.platform.support.semanticId.SemanticIdResolutionResult;
import de.iip_ecosphere.platform.support.semanticId.SemanticIdResolver;
import de.iip_ecosphere.platform.support.semanticId.eclass.AuthApiClient;
import de.iip_ecosphere.platform.support.semanticId.eclass.api.EclassJsonReadServicesApi;
import de.iip_ecosphere.platform.support.semanticId.eclass.handler.ApiException;
import de.iip_ecosphere.platform.support.semanticId.eclass.model.ReadProperty;
import de.iip_ecosphere.platform.support.semanticId.eclass.model.ReadUnit;
import de.iip_ecosphere.platform.support.semanticId.eclass.model.StructureElementSystemData;
import de.iip_ecosphere.platform.support.semanticId.eclass.model.TranslatableLabel;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import org.slf4j.LoggerFactory;

public class EclassSemanticIdResolver
extends SemanticIdResolver {
    private static final String REGEX = "^[0-9]{4}-[A-Z0-9:_.]{1,35}((-[A-Z0-9:_.]{1,35}(-[A-Z0-9]{1}(-[A-Z0-9:_.]{1,70})?)?)?|-([A-Z0-9:_.]{1,35})?--[A-Z0-9:_.]{1,70}|---[A-Z0-9:_.]{1,70})#[0-9A-Z]{2}-[A-Z0-9:_.]{1,131}#[0-9]{1,10}$";
    private Pattern pattern;
    private EclassJsonReadServicesApi eclassApi;
    private boolean disabled = false;
    private Map<String, DefaultSemanticIdResolutionResult> cache = Collections.synchronizedMap(new HashMap());
    private String keystoreKey = System.getProperty("iip.eclass.keystoreKey", "eclassCert");
    private Locale preferredLanguage = new Locale(System.getProperty("iip.eclass.locale", Locale.getDefault().toString()));

    public EclassSemanticIdResolver() {
        try {
            this.pattern = Pattern.compile(REGEX);
        }
        catch (PatternSyntaxException e) {
            LoggerFactory.getLogger(EclassSemanticIdResolver.class).error("Syntax error in IRDI RegEx: {} Disabling this resolver.", (Object)e.getMessage());
            this.disabled = true;
        }
    }

    private void initialize() {
        if (null == this.eclassApi) {
            try {
                IdentityStore iStore = IdentityStore.getInstance();
                IdentityToken tok = iStore.getToken(this.keystoreKey, new String[0]);
                if (null == tok) {
                    LoggerFactory.getLogger(EclassSemanticIdResolver.class).error("No authentication token for '{}'. Disabling this resolver.", (Object)this.keystoreKey);
                    this.disabled = true;
                } else {
                    InputStream keyStoreStream = iStore.getKeystoreAsStream(this.keystoreKey, new String[0]);
                    if (null != keyStoreStream) {
                        try {
                            KeyStore keyStores = KeyStore.getInstance("PKCS12");
                            char[] pw = tok.getTokenDataAsCharArray();
                            if (null == pw) {
                                pw = "".toCharArray();
                            }
                            keyStores.load(keyStoreStream, pw);
                            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
                            keyManagerFactory.init(keyStores, pw);
                            SSLContext context = SSLContext.getInstance("TLS");
                            context.init(keyManagerFactory.getKeyManagers(), null, null);
                            AuthApiClient.setSslContext(context);
                        }
                        catch (GeneralSecurityException e) {
                            LoggerFactory.getLogger(EclassSemanticIdResolver.class).error("Cannot load certificate. Disabling this resolver.", (Object)e.getMessage());
                            this.disabled = true;
                        }
                    } else {
                        LoggerFactory.getLogger(EclassSemanticIdResolver.class).error("No keystore stream found. Disabling this resolver.");
                        this.disabled = true;
                    }
                    EclassJsonReadServicesApi api = new EclassJsonReadServicesApi();
                    AuthApiClient apiClient = new AuthApiClient();
                    api.setApiClient(apiClient);
                    apiClient.setBasePath("https://eclass-cdp.com/");
                    this.eclassApi = api;
                }
            }
            catch (IOException e) {
                LoggerFactory.getLogger(EclassSemanticIdResolver.class).error("Cannot create Eclass API/connection. Disabling this resolver.", (Object)e.getMessage());
                this.disabled = true;
            }
        }
    }

    public static DefaultSemanticIdResolutionResult createInstance(String semanticId) {
        DefaultSemanticIdResolutionResult result = new DefaultSemanticIdResolutionResult();
        result.setSemanticId(semanticId);
        result.setPublisher("Eclass");
        result.setKind("IRDI");
        int pos1 = semanticId.indexOf(45);
        int pos2 = semanticId.indexOf(35, pos1);
        if (pos1 > 0 && pos2 > pos1) {
            result.setRevision(semanticId.substring(pos1 + 1, pos2));
        }
        if ((pos2 = semanticId.lastIndexOf(35)) > 0) {
            String ver = semanticId.substring(pos2 + 1);
            while (ver.startsWith("0") && ver.length() > 0) {
                ver = ver.substring(1);
            }
            result.setVersion(ver);
        }
        return result;
    }

    public static Map<String, DefaultSemanticIdResolutionResult.DefaultNaming> createNaming(TranslatableLabel preferredName, TranslatableLabel structuredName) {
        HashMap<String, DefaultSemanticIdResolutionResult.DefaultNaming> result = new HashMap<String, DefaultSemanticIdResolutionResult.DefaultNaming>();
        if (null != preferredName) {
            EclassSemanticIdResolver.createNaming(preferredName, (n, v) -> n.setName(v), result);
        }
        if (null != structuredName) {
            EclassSemanticIdResolver.createNaming(structuredName, (n, v) -> n.setStructuredName(v), result);
        }
        return result;
    }

    private static void createNaming(TranslatableLabel label, Setter setter, Map<String, DefaultSemanticIdResolutionResult.DefaultNaming> result) {
        for (Map.Entry e : label.entrySet()) {
            Locale loc = new Locale((String)e.getKey());
            DefaultSemanticIdResolutionResult.DefaultNaming naming = result.get(loc.getLanguage());
            if (null == naming) {
                naming = new DefaultSemanticIdResolutionResult.DefaultNaming();
                result.put(loc.getLanguage(), naming);
            }
            setter.apply(naming, (String)e.getValue());
        }
    }

    public SemanticIdResolutionResult resolveSemanticId(String semanticId) {
        DefaultSemanticIdResolutionResult result = this.cache.get(semanticId);
        if (null == result) {
            this.initialize();
            if (null != this.eclassApi) {
                StructureElementSystemData res;
                String prefLang = this.preferredLanguage.toString();
                try {
                    res = this.eclassApi.jsonapiV1UnitsIrdiGet(semanticId, prefLang, "false");
                    if (res != null) {
                        result = EclassSemanticIdResolver.createInstance(semanticId);
                        result.setNamingTyped(EclassSemanticIdResolver.createNaming(((ReadUnit)res).getShortName(), ((ReadUnit)res).getPreferredName()));
                    }
                }
                catch (ApiException e) {
                    LoggerFactory.getLogger(EclassSemanticIdResolver.class).error("API error: {} code {} body {}", new Object[]{e.getMessage(), e.getCode(), e.getResponseBody()});
                }
                if (null == result) {
                    try {
                        res = this.eclassApi.jsonapiV1PropertiesIrdiGet(semanticId, prefLang, "false");
                        if (res != null) {
                            result = EclassSemanticIdResolver.createInstance(semanticId);
                            result.setNamingTyped(EclassSemanticIdResolver.createNaming(null, ((ReadProperty)res).getPreferredName()));
                        }
                    }
                    catch (ApiException e) {
                        LoggerFactory.getLogger(EclassSemanticIdResolver.class).error("API error: {} code {} body {}", new Object[]{e.getMessage(), e.getCode(), e.getResponseBody()});
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
            }
            if (null != result) {
                this.cache.put(semanticId, result);
            }
        }
        return result;
    }

    public boolean isResponsible(String semanticId) {
        return this.disabled ? false : this.pattern.matcher(semanticId).matches();
    }

    private static interface Setter {
        public void apply(DefaultSemanticIdResolutionResult.DefaultNaming var1, String var2);
    }
}

