/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.support.iip_aas;

import de.iip_ecosphere.platform.support.iip_aas.config.YamlFile;
import de.iip_ecosphere.platform.support.resources.ResourceLoader;
import de.iip_ecosphere.platform.support.resources.ResourceResolver;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class YamlFileTest {
    @Test
    public void testYamlFile() throws IOException {
        Object data = YamlFile.read((InputStream)ResourceLoader.getResourceAsStream((String)"nameplate.yml", (ResourceResolver[])new ResourceResolver[0]));
        Map map = YamlFile.asMap(null);
        Assert.assertNotNull((Object)map);
        Assert.assertTrue((boolean)map.isEmpty());
        List list = YamlFile.getFieldAsList((Object)data, (String)"services");
        Assert.assertNotNull((Object)list);
        Assert.assertFalse((boolean)list.isEmpty());
        map = YamlFile.asMap((Object)data);
        Assert.assertNotNull((Object)map);
        Assert.assertFalse((boolean)map.isEmpty());
        list = YamlFile.asList(null);
        Assert.assertNotNull((Object)list);
        Assert.assertTrue((boolean)list.isEmpty());
        data = YamlFile.asString(null, (String)"");
        Assert.assertNotNull((Object)data);
        Assert.assertEquals((Object)"", (Object)data);
    }

    @Test
    public void testYamlFileSpring() throws IOException {
        Object data = YamlFile.read((InputStream)ResourceLoader.getResourceAsStream((String)"YamlFile.yml", (ResourceResolver[])new ResourceResolver[0]));
        String bindingsPath = "spring.cloud.stream.bindings";
        String[] bindingsFieldPath = "spring.cloud.stream.bindings".split("\\.");
        Map tmp = YamlFile.getFieldAsMap((Object)data, (String[])bindingsFieldPath);
        boolean found = false;
        for (Map.Entry ent : tmp.entrySet()) {
            String dest = YamlFile.getFieldAsString(ent.getValue(), (String)"destination", null);
            Assert.assertNotNull((Object)dest);
            found = true;
        }
        Assert.assertTrue((boolean)found);
    }

    @Test
    public void testFixList() {
        Assert.assertNull((Object)YamlFile.fixListSafe(null, TestType.class));
        List list = new ArrayList();
        Assert.assertEquals(list, (Object)YamlFile.fixListSafe(list, TestType.class));
        HashMap<String, Integer> oMap = new HashMap<String, Integer>();
        oMap.put("iValue", 10);
        ArrayList<HashMap<String, Integer>> oList = new ArrayList<HashMap<String, Integer>>();
        oList.add(oMap);
        list = oList;
        list = YamlFile.fixListSafe(list, TestType.class);
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)(list.get(0) instanceof TestType));
        Assert.assertEquals((long)10L, (long)((TestType)list.get(0)).getIValue());
    }

    public static class TestType
    extends BasicTestType {
    }

    public static class BasicTestType {
        private int iValue;

        public int getIValue() {
            return this.iValue;
        }

        public void setIValue(int iValue) {
            this.iValue = iValue;
        }
    }
}

