/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.support.iip_aas;

import de.iip_ecosphere.platform.support.Server;
import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.AasPrintVisitor;
import de.iip_ecosphere.platform.support.aas.AasVisitor;
import de.iip_ecosphere.platform.support.aas.Property;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.iip_aas.AasPartRegistry;
import de.iip_ecosphere.platform.support.iip_aas.ApplicationInstanceAasConstructor;
import de.iip_ecosphere.platform.support.iip_aas.ApplicationInstancesAasClient;
import de.iip_ecosphere.platform.support.iip_aas.PlatformAas;
import de.iip_ecosphere.platform.support.iip_aas.PlatformAasClient;
import de.iip_ecosphere.platform.support.semanticId.SemanticIdResolutionResult;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.junit.Assert;
import org.junit.Test;

public class PlatformAasTest {
    @Test
    public void testAas() throws ExecutionException, IOException {
        Assert.assertTrue((boolean)AasPartRegistry.contributorClasses().contains(PlatformAas.class));
        AasPartRegistry.AasSetup oldSetup = AasPartRegistry.setAasSetup((AasPartRegistry.AasSetup)AasPartRegistry.AasSetup.createLocalEphemeralSetup());
        AasPartRegistry.AasBuildResult res = AasPartRegistry.build(c -> c instanceof PlatformAas);
        Server implServer = (Server)res.getProtocolServerBuilder().build();
        implServer.start();
        Server aasServer = AasPartRegistry.deploy((List)res.getAas(), (String[])new String[0]);
        aasServer.start();
        AasPartRegistry.retrieveIipAas().accept((AasVisitor)new AasPrintVisitor());
        Aas aas = (Aas)res.getAas().get(0);
        Assert.assertNotNull((Object)aas);
        Submodel psm = aas.getSubmodel("platform");
        Assert.assertNotNull((Object)psm);
        Property prop = psm.getProperty("version");
        Assert.assertNotNull((Object)prop);
        Object val = prop.getValue();
        Assert.assertNotNull((Object)val);
        Assert.assertFalse((boolean)val.toString().equals("??"));
        prop = psm.getProperty("buildId");
        Assert.assertNotNull((Object)prop);
        val = prop.getValue();
        Assert.assertNotNull((Object)val);
        Assert.assertFalse((boolean)val.toString().equals("??"));
        prop = psm.getProperty("isRelease");
        Assert.assertNotNull((Object)prop);
        val = prop.getValue();
        Assert.assertNotNull((Object)val);
        Assert.assertTrue((val.toString().equals("true") || val.toString().equals("false") ? 1 : 0) != 0);
        prop = psm.getProperty("name");
        Assert.assertNotNull((Object)prop);
        val = prop.getValue();
        Assert.assertNotNull((Object)val);
        Assert.assertTrue((val.toString().length() > 0 ? 1 : 0) != 0);
        PlatformAasClient client = new PlatformAasClient();
        try {
            client.snapshotAas("xyz");
            Assert.fail((String)"No exception thrown");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        SemanticIdResolutionResult sres = client.resolveSemanticId("0173-1#05-AAA766#003");
        Assert.assertNotNull((Object)sres);
        PlatformAasTest.assertApplicationInstances();
        AasPartRegistry.setAasSupplier(() -> res.getAas());
        PlatformAasTest.assertString(client.snapshotAas("xyz"), "xyz");
        aasServer.stop(true);
        implServer.stop(true);
        AasPartRegistry.setAasSetup((AasPartRegistry.AasSetup)oldSetup);
    }

    private static void assertApplicationInstances() throws IOException {
        Aas aas = AasPartRegistry.retrieveIipAas();
        aas.createSubmodelBuilder("ApplicationInstances", null).build();
        ApplicationInstancesAasClient instClient = new ApplicationInstancesAasClient();
        Assert.assertEquals((long)0L, (long)instClient.getInstanceCount("app-1"));
        Assert.assertEquals((long)0L, (long)instClient.getInstanceCount("app-1", "plan-1"));
        String id1 = ApplicationInstanceAasConstructor.notifyAppNewInstance((String)"app-1", (String)"plan-1");
        Assert.assertNull((Object)id1);
        String id2 = ApplicationInstanceAasConstructor.notifyAppNewInstance((String)"app-1", (String)"plan-1");
        Assert.assertNotNull((Object)id2);
        instClient = new ApplicationInstancesAasClient();
        Assert.assertEquals((long)2L, (long)instClient.getInstanceCount("app-1"));
        Assert.assertEquals((long)2L, (long)instClient.getInstanceCount("app-1", "plan-1"));
        int count = ApplicationInstanceAasConstructor.notifyAppInstanceStopped((String)"app-1", (String)id2);
        Assert.assertEquals((long)1L, (long)count);
        count = ApplicationInstanceAasConstructor.notifyAppInstanceStopped((String)"app-1", (String)id1);
        Assert.assertEquals((long)0L, (long)count);
        instClient = new ApplicationInstancesAasClient();
        Assert.assertEquals((long)0L, (long)instClient.getInstanceCount("app-1"));
        Assert.assertEquals((long)0L, (long)instClient.getInstanceCount("app-1", "plan-1"));
    }

    private static void assertString(String string, String substring) {
        Assert.assertNotNull((Object)string);
        Assert.assertTrue((string.length() > 0 ? 1 : 0) != 0);
        if (null != substring) {
            Assert.assertTrue((string.indexOf(substring) > 0 ? 1 : 0) != 0);
        }
    }
}

