/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.support.iip_aas;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.iip_aas.json.JsonUtils;
import org.junit.Assert;
import org.junit.Test;

public class JsonUtilsTest {
    @Test
    public void testOptionals() {
        Data obj;
        String data = "{\"intValue\":\"1\"}";
        ObjectMapper objectMapper = new ObjectMapper();
        JsonUtils.defineOptionals((ObjectMapper)objectMapper, Data.class, (String[])new String[]{"stringValue"});
        try {
            obj = (Data)objectMapper.readValue(data, Data.class);
            Assert.assertEquals((long)1L, (long)obj.getIntValue());
            Assert.assertNull((Object)obj.getStringValue());
        }
        catch (JsonProcessingException e) {
            Assert.fail((String)"Shall not occur");
        }
        data = "{\"stringValue\":\"xyz\"}";
        objectMapper = new ObjectMapper();
        JsonUtils.defineOptionals((ObjectMapper)objectMapper, Data.class, (String[])new String[]{"intValue"});
        try {
            obj = (Data)objectMapper.readValue(data, Data.class);
            Assert.assertEquals((long)0L, (long)obj.getIntValue());
            Assert.assertEquals((Object)"xyz", (Object)obj.getStringValue());
        }
        catch (JsonProcessingException e) {
            Assert.fail((String)"Shall not occur");
        }
        data = "{}";
        objectMapper = new ObjectMapper();
        JsonUtils.defineOptionals((ObjectMapper)objectMapper, Data.class, (String[])new String[]{"stringValue", "intValue"});
        try {
            obj = (Data)objectMapper.readValue(data, Data.class);
            Assert.assertEquals((long)0L, (long)obj.getIntValue());
            Assert.assertNull((Object)obj.getStringValue());
        }
        catch (JsonProcessingException e) {
            Assert.fail((String)"Shall not occur");
        }
    }

    @Test
    public void testToFromJson() {
        String json = JsonUtils.toJson(null);
        Data data = (Data)JsonUtils.fromJson((Object)json, Data.class);
        Assert.assertNull((Object)data);
        data = new Data(25, "abba");
        json = JsonUtils.toJson((Object)data);
        Data tmp = (Data)JsonUtils.fromJson((Object)json, Data.class);
        Assert.assertNotNull((Object)tmp);
        Assert.assertEquals((Object)data.getStringValue(), (Object)tmp.getStringValue());
        Assert.assertEquals((long)data.getIntValue(), (long)tmp.getIntValue());
    }

    @Test
    public void testServerAddress() {
        ServerAddress addr = null;
        String json = JsonUtils.toJson(addr);
        ServerAddress tmp = JsonUtils.serverAddressFromJson((Object)json);
        Assert.assertNull((Object)tmp);
        addr = new ServerAddress(Schema.TCP, "me.here", 10321);
        json = JsonUtils.toJson((ServerAddress)addr);
        tmp = JsonUtils.serverAddressFromJson((Object)json);
        Assert.assertNotNull((Object)tmp);
        Assert.assertEquals((Object)addr.getSchema(), (Object)tmp.getSchema());
        Assert.assertEquals((Object)addr.getHost(), (Object)tmp.getHost());
        Assert.assertEquals((long)addr.getPort(), (long)tmp.getPort());
    }

    @Test
    public void testEscapeUnescape() {
        JsonUtilsTest.assertEscapeUnescape("");
        JsonUtilsTest.assertEscapeUnescape("aaa");
        JsonUtilsTest.assertEscapeUnescape("{}");
        JsonUtilsTest.assertEscapeUnescape("{\"name\": \"abc\", \"value\": 1, \"enum\":20, \"enumName\":\"TEST1\"}");
        JsonUtilsTest.assertEscapeUnescape("{\"obj\": {\"name\": \"abc\", \"value\": 1}}");
    }

    private static void assertEscapeUnescape(String string) {
        Assert.assertEquals((Object)string, (Object)JsonUtils.unescape((String)JsonUtils.escape((String)string)));
    }

    public static class Data {
        private int intValue;
        private String stringValue;

        private Data() {
        }

        private Data(int intValue, String stringValue) {
            this.intValue = intValue;
            this.stringValue = stringValue;
        }

        public int getIntValue() {
            return this.intValue;
        }

        void setIntValue(int intValue) {
            this.intValue = intValue;
        }

        public String getStringValue() {
            return this.stringValue;
        }

        void setStringValue(String stringValue) {
            this.stringValue = stringValue;
        }
    }
}

