/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.support.iip_aas;

import de.iip_ecosphere.platform.support.iip_aas.config.CmdLine;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;

public class CmdLineTest {
    @Test
    public void testParseToArgs() {
        ArrayList result = new ArrayList();
        CmdLine.parseToArgs((String)"", result);
        Assert.assertTrue((result.size() == 0 ? 1 : 0) != 0);
        CmdLine.parseToArgs((String)"--a=0", result);
        Assert.assertTrue((result.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"--a=0", result.get(0));
        result.clear();
        CmdLine.parseToArgs((String)"--a=0 --b=5", result);
        Assert.assertTrue((result.size() == 2 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"--a=0", result.get(0));
        Assert.assertEquals((Object)"--b=5", result.get(1));
        result.clear();
        CmdLine.parseToArgs((String)"\"--a=0 --b=5\"", result);
        Assert.assertTrue((result.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"\"--a=0 --b=5\"", result.get(0));
        result.clear();
        CmdLine.parseToArgs((String)"--a=0 --c=\"x y\" --b=5", result);
        Assert.assertTrue((result.size() == 3 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"--a=0", result.get(0));
        Assert.assertEquals((Object)"--c=\"x y\"", result.get(1));
        Assert.assertEquals((Object)"--b=5", result.get(2));
        result.clear();
    }

    @Test
    public void testGetArg() {
        String[] args = new String[]{"--bli=5", "--bla=6", "--xyz=String", "whatever", "--bVal=true"};
        Assert.assertEquals((Object)"6", (Object)CmdLine.getArg((String[])args, (String)"bla", (String)""));
        Assert.assertEquals((Object)"5", (Object)CmdLine.getArg((String[])args, (String)"bli", (String)""));
        Assert.assertEquals((Object)"String", (Object)CmdLine.getArg((String[])args, (String)"xyz", (String)""));
        Assert.assertEquals((long)5L, (long)CmdLine.getIntArg((String[])args, (String)"bli", (int)0));
        Assert.assertEquals((long)0L, (long)CmdLine.getIntArg((String[])args, (String)"blii", (int)0));
        Assert.assertEquals((Object)true, (Object)CmdLine.getBooleanArg((String[])args, (String)"bVal", (boolean)false));
        Assert.assertEquals((Object)false, (Object)CmdLine.getBooleanArg((String[])args, (String)"xVal", (boolean)false));
        Assert.assertEquals((Object)false, (Object)CmdLine.getBooleanArg((String[])args, (String)"bla", (boolean)false));
    }

    @Test
    public void testToArgs() {
        String[] tmp = CmdLine.toArgs((String)"");
        Assert.assertNotNull((Object)tmp);
        Assert.assertEquals((long)0L, (long)tmp.length);
        tmp = CmdLine.toArgs((String)"--iip.app.p=5 --iip.app.w=7 --transport=5");
        Assert.assertNotNull((Object)tmp);
        Assert.assertEquals((long)3L, (long)tmp.length);
        Assert.assertEquals((Object)"--iip.app.p=5", (Object)tmp[0]);
        Assert.assertEquals((Object)"--iip.app.w=7", (Object)tmp[1]);
        Assert.assertEquals((Object)"--transport=5", (Object)tmp[2]);
        tmp = CmdLine.toArgs((String)"--iip.app.p='5' --iip.app.w=\"7\" --transport=5");
        Assert.assertNotNull((Object)tmp);
        Assert.assertEquals((long)3L, (long)tmp.length);
        Assert.assertEquals((Object)"--iip.app.p='5'", (Object)tmp[0]);
        Assert.assertEquals((Object)"--iip.app.w=\"7\"", (Object)tmp[1]);
        Assert.assertEquals((Object)"--transport=5", (Object)tmp[2]);
    }

    @Test
    public void testComposeArgument() {
        Assert.assertEquals((Object)"--iip.app.p=5", (Object)CmdLine.composeArgument((String)"iip.app.p", (Object)"5"));
    }
}

