/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.support.iip_aas;

import de.iip_ecosphere.platform.support.iip_aas.AasUtils;
import de.iip_ecosphere.platform.support.resources.ResourceResolver;
import java.net.URI;
import java.net.URISyntaxException;
import org.junit.Assert;
import org.junit.Test;

public class AasUtilsTest {
    @Test
    public void testString() {
        Object[] noArgs = new Object[]{};
        Object[] args = new Object[]{"abba", 5};
        Assert.assertEquals((Object)"", (Object)AasUtils.readString((Object[])noArgs, (int)0, (String)""));
        Assert.assertEquals((Object)"abba", (Object)AasUtils.readString((Object[])args, (int)0, null));
        Assert.assertEquals((Object)"", (Object)AasUtils.readString((Object[])noArgs, (int)0));
        Assert.assertEquals((Object)"", (Object)AasUtils.readString((Object[])noArgs));
    }

    @Test
    public void testInt() {
        Object[] noArgs = new Object[]{};
        Object[] args = new Object[]{"abba", 5};
        Assert.assertEquals((long)-1L, (long)AasUtils.readInt((Object[])noArgs, (int)1, (int)-1));
        Assert.assertEquals((long)5L, (long)AasUtils.readInt((Object[])args, (int)1, (int)0));
    }

    @Test
    public void testDouble() {
        Object[] noArgs = new Object[]{};
        Object[] args = new Object[]{"abba", 5.23};
        Assert.assertEquals((double)-1.0, (double)AasUtils.readDouble((Object[])noArgs, (int)1, (int)-1), (double)0.01);
        Assert.assertEquals((double)5.23, (double)AasUtils.readDouble((Object[])args, (int)1, (int)0), (double)0.01);
    }

    @Test
    public void testUri() {
        Object[] noArgs = new Object[]{};
        Object[] args = new Object[]{"http://me.here/my/file.txt"};
        URI uri = AasUtils.readUri((Object[])noArgs, (int)0, null);
        Assert.assertNull((Object)uri);
        uri = AasUtils.readUri((Object[])args, (int)0, null);
        Assert.assertNotNull((Object)uri);
        Assert.assertEquals((Object)args[0], (Object)uri.toString());
        args[0] = "<x>";
        uri = AasUtils.readUri((Object[])args, (int)0, null);
        Assert.assertNull((Object)uri);
        try {
            AasUtils.readUriEx((Object[])args, (int)0, null);
            Assert.fail((String)"no exception");
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }

    @Test
    public void testFixId() {
        Assert.assertEquals((Object)"id", (Object)AasUtils.fixId((String)"id"));
    }

    @Test
    public void resolveImageTest() {
        AasUtils.resolveImage((String)"nix.png", (ResourceResolver)AasUtils.CLASSPATH_RESOLVER, (boolean)false, (n, r, m) -> Assert.fail((String)"Shall not be called. Not resolved."));
        AasUtils.resolveImage((String)"nix.png", null, (boolean)true, (n, r, m) -> Assert.assertEquals((Object)"", (Object)r));
        String uri = "https://www.iip-ecosphere.de/wp-content/uploads/2020/08/Picture4.jpg";
        AasUtils.resolveImage((String)uri, (ResourceResolver)AasUtils.CLASSPATH_RESOLVER, (boolean)true, (n, r, m) -> {
            Assert.assertEquals((Object)"text/x-uri", (Object)m);
            Assert.assertEquals((Object)uri, (Object)r);
        });
        AasUtils.resolveImage((String)"IIP-Ecosphere-Platform.png", (ResourceResolver)AasUtils.CLASSPATH_RESOLVER, (boolean)false, (n, r, m) -> {
            Assert.assertTrue((r.length() > 0 ? 1 : 0) != 0);
            Assert.assertEquals((Object)"image/png", (Object)m);
        });
        AasUtils.resolveImage((String)"IIP-Ecosphere-Platform.png", (ResourceResolver)AasUtils.CLASSPATH_RESOURCE_RESOLVER, (boolean)false, (n, r, m) -> {
            Assert.assertTrue((r.length() > 0 ? 1 : 0) != 0);
            Assert.assertEquals((Object)"image/png", (Object)m);
        });
    }
}

