/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.iip_aas.uri;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;

public class UriResolver {
    public static File resolveToFile(URI uri, File dir) throws IOException {
        File result = null;
        if ("file".equals(uri.getScheme())) {
            result = new File(uri);
        } else {
            URL url = uri.toURL();
            File f = null;
            try (InputStream in = url.openStream();){
                String path = uri.getPath();
                int pos = path.lastIndexOf("/");
                if (pos > 0 && pos < path.length() - 1) {
                    path = path.substring(pos + 1);
                }
                pos = path.lastIndexOf(".");
                String suffix = "";
                if (pos > 0) {
                    suffix = path.substring(pos);
                    path = path.substring(0, pos);
                }
                if (null == dir) {
                    f = File.createTempFile("iip", suffix);
                } else {
                    path = path + "-" + System.currentTimeMillis() + suffix;
                    f = new File(dir, path);
                }
                Files.copy(in, f.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            result = f;
        }
        return result;
    }
}

