/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.iip_aas.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.iip_aas.config.ServerAddressHolder;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class JsonUtils {
    public static ServerAddress serverAddressFromJson(Object json) {
        ServerAddress result = null;
        if (null != json) {
            try {
                ObjectMapper objectMapper = new ObjectMapper();
                ServerAddressHolder tmp = (ServerAddressHolder)objectMapper.readValue(json.toString(), ServerAddressHolder.class);
                result = new ServerAddress(tmp.getSchema(), tmp.getHost(), tmp.getPort());
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
        }
        return result;
    }

    public static String toJson(ServerAddress address) {
        String result = "";
        if (null != address) {
            try {
                ObjectMapper objectMapper = new ObjectMapper();
                ServerAddressHolder tmp = new ServerAddressHolder(address);
                result = objectMapper.writeValueAsString((Object)tmp);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
        }
        return result;
    }

    public static String toJson(Object obj) {
        String result = "";
        if (null != obj) {
            try {
                ObjectMapper objectMapper = new ObjectMapper();
                result = objectMapper.writeValueAsString(obj);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
        }
        return result;
    }

    public static <R> R fromJson(Object json, Class<R> cls) {
        Object result = null;
        if (null != json) {
            try {
                ObjectMapper objectMapper = new ObjectMapper();
                result = objectMapper.readValue(json.toString(), cls);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
        }
        return (R)result;
    }

    public static String escape(String input) {
        StringBuilder output = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char ch;
            char chx = ch = input.charAt(i);
            assert (chx != '\u0000');
            if (ch == '\n') {
                output.append("\\n");
                continue;
            }
            if (ch == '\t') {
                output.append("\\t");
                continue;
            }
            if (ch == '\r') {
                output.append("\\r");
                continue;
            }
            if (ch == '\\') {
                output.append("\\\\");
                continue;
            }
            if (ch == '\"') {
                output.append("\\\"");
                continue;
            }
            if (ch == '\b') {
                output.append("\\b");
                continue;
            }
            if (ch == '\f') {
                output.append("\\f");
                continue;
            }
            if (chx >= '\u10000') {
                assert (false) : "Java stores as u16, so it should never give us a character that's bigger than 2 bytes. It literally can't.";
                continue;
            }
            if (chx > '\u007f') {
                output.append(String.format("\\u%04x", chx));
                continue;
            }
            output.append(ch);
        }
        return output.toString();
    }

    public static String unescape(String input) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < input.length()) {
            char delimiter = input.charAt(i);
            if (delimiter == '\\' && ++i < input.length()) {
                char ch = input.charAt(i);
                ++i;
                if (ch == '\\' || ch == '/' || ch == '\"' || ch == '\'') {
                    builder.append(ch);
                    continue;
                }
                if (ch == 'n') {
                    builder.append('\n');
                    continue;
                }
                if (ch == 'r') {
                    builder.append('\r');
                    continue;
                }
                if (ch == 't') {
                    builder.append('\t');
                    continue;
                }
                if (ch == 'b') {
                    builder.append('\b');
                    continue;
                }
                if (ch == 'f') {
                    builder.append('\f');
                    continue;
                }
                if (ch == 'u') {
                    StringBuilder hex = new StringBuilder();
                    if (i + 4 > input.length()) {
                        throw new RuntimeException("Not enough unicode digits! ");
                    }
                    for (char x : input.substring(i, i + 4).toCharArray()) {
                        if (!Character.isLetterOrDigit(x)) {
                            throw new RuntimeException("Bad character in unicode escape.");
                        }
                        hex.append(Character.toLowerCase(x));
                    }
                    i += 4;
                    int code = Integer.parseInt(hex.toString(), 16);
                    builder.append((char)code);
                    continue;
                }
                throw new RuntimeException("Illegal escape sequence: \\" + ch);
            }
            builder.append(delimiter);
        }
        return builder.toString();
    }

    public static void defineOptionals(ObjectMapper mapper, Class<?> cls, String ... fieldNames) {
        mapper.addHandler((DeserializationProblemHandler)new OptionalFieldsDeserializationProblemHandler(cls, fieldNames));
    }

    public static class OptionalFieldsDeserializationProblemHandler
    extends DeserializationProblemHandler {
        private Class<?> cls;
        private Set<String> optionalFields = new HashSet<String>();

        public OptionalFieldsDeserializationProblemHandler(Class<?> cls, String ... fieldNames) {
            this.cls = cls;
            for (String f : fieldNames) {
                this.optionalFields.add(f);
            }
        }

        public boolean handleUnknownProperty(DeserializationContext ctxt, JsonParser parser, JsonDeserializer<?> deserializer, Object beanOrClass, String propertyName) throws IOException {
            boolean result = this.optionalFields.contains(propertyName) && beanOrClass.getClass().equals(this.cls);
            return result;
        }
    }
}

