/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.iip_aas.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;

public class JsonResultWrapper
implements Function<Object[], Object>,
Serializable {
    private static final long serialVersionUID = 6531890963314078947L;
    private ExceptionFunction func;

    public JsonResultWrapper(ExceptionFunction func) {
        this.func = func;
    }

    @Override
    public Object apply(Object[] param) {
        Result result;
        try {
            Object funcRes = this.func.apply(param);
            result = new Result(null == funcRes ? null : funcRes.toString());
        }
        catch (Exception e) {
            result = new Result(e);
        }
        return JsonResultWrapper.toJson(result);
    }

    public static String toJson(Result res) {
        String result = "";
        if (null != res) {
            try {
                ObjectMapper objectMapper = new ObjectMapper();
                result = objectMapper.writeValueAsString((Object)res);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
        }
        return result;
    }

    public static Result resultFromJson(Object json) {
        Result result = null;
        if (null != json) {
            try {
                ObjectMapper objectMapper = new ObjectMapper();
                result = (Result)objectMapper.readValue(json.toString(), Result.class);
            }
            catch (JsonProcessingException e) {
                result = new Result((Exception)((Object)e));
            }
        }
        return result;
    }

    public static String fromJson(Object json) throws ExecutionException {
        String result;
        Result res = JsonResultWrapper.resultFromJson(json);
        if (null != res) {
            if (res.isException()) {
                throw new ExecutionException(res.getException(), null);
            }
            result = res.getResult();
        } else {
            result = null;
        }
        return result;
    }

    public static String fromJson(Function<Object[], Object> function, Object ... params) throws ExecutionException {
        try {
            return JsonResultWrapper.fromJson(function.apply(params));
        }
        catch (Throwable t) {
            throw new ExecutionException(t.getMessage(), t);
        }
    }

    public static interface ExceptionFunction {
        public Object apply(Object[] var1) throws Exception;
    }

    public static class Result
    implements Serializable {
        private static final long serialVersionUID = -4586150559933545643L;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private String result;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private String exception;

        private Result() {
        }

        private Result(String result) {
            this.result = result;
        }

        private Result(Exception ex) {
            this.exception = ex.getMessage();
        }

        public String getResult() {
            return this.result;
        }

        public String getException() {
            return this.exception;
        }

        public boolean isException() {
            return null != this.exception;
        }

        public void setResult(String result) {
            this.result = result;
        }

        public void setException(String exception) {
            this.exception = exception;
        }
    }
}

