/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.iip_aas.config;

import java.util.List;

public class CmdLine {
    public static final String PARAM_PREFIX = "--";
    public static final String PARAM_ARG_NAME_SEP = ".";
    public static final String PARAM_VALUE_SEP = "=";

    public static void parseToArgs(String text, List<String> cmds) {
        CmdLine.parseToArgs(text, cmds, ' ');
    }

    public static void parseToArgs(String text, List<String> cmds, char separator) {
        boolean inQuote = false;
        text = text.trim();
        int lastStart = 0;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if ('\"' == c) {
                boolean bl = inQuote = !inQuote;
            }
            if ((separator != c || inQuote) && i + 1 != text.length()) continue;
            String cmd = text.substring(lastStart, i + 1).trim();
            if (cmd.length() > 0) {
                cmds.add(cmd);
            }
            lastStart = i + 1;
        }
    }

    public static String getArg(String[] args, String argName, String dflt) {
        String result = dflt;
        String prefix = PARAM_PREFIX + argName + PARAM_VALUE_SEP;
        for (int a = 0; a < args.length; ++a) {
            String arg = args[a];
            if (!arg.startsWith(prefix)) continue;
            result = arg.substring(prefix.length());
            break;
        }
        return result;
    }

    public static int getIntArg(String[] args, String argName, int dflt) {
        int result;
        try {
            result = Integer.parseInt(CmdLine.getArg(args, argName, String.valueOf(dflt)));
        }
        catch (NumberFormatException e) {
            result = dflt;
        }
        return result;
    }

    public static boolean getBooleanArg(String[] args, String argName, boolean dflt) {
        return Boolean.valueOf(CmdLine.getArg(args, argName, String.valueOf(dflt)));
    }
}

