/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.iip_aas.config;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.representer.Representer;

public abstract class AbstractSetup {
    public static final String DEFAULT_NAME = "iipecosphere";
    public static final String DEFAULT_FNAME = "iipecosphere.yml";

    public static <C> C readFromYaml(Class<C> cls) throws IOException {
        return AbstractSetup.readFromYaml(cls, DEFAULT_FNAME);
    }

    public static <C> C readFromYaml(Class<C> cls, String filename) throws IOException {
        InputStream in;
        String fname = filename;
        if (!fname.startsWith("/")) {
            fname = "/" + fname;
        }
        if (null == (in = AbstractSetup.class.getResourceAsStream(fname))) {
            throw new IOException("Cannot read " + fname);
        }
        return AbstractSetup.readFromYaml(cls, in);
    }

    public static <C> C readFromYaml(Class<C> cls, InputStream in) throws IOException {
        Object result = null;
        if (in != null) {
            try {
                Representer representer = new Representer();
                representer.getPropertyUtils().setSkipMissingProperties(true);
                Yaml yaml = new Yaml((BaseConstructor)new Constructor(cls), representer);
                result = yaml.load(in);
                in.close();
            }
            catch (YAMLException e) {
                in.close();
                throw new IOException(e);
            }
        }
        if (null == result) {
            LoggerFactory.getLogger(AbstractSetup.class).info("No input YAML file, falling back to default instance for " + cls.getName());
            try {
                result = cls.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new IOException(e);
            }
        }
        return (C)result;
    }
}

