/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.iip_aas;

import java.util.Arrays;
import java.util.regex.Pattern;

public class Version
implements Comparable<Version> {
    private static final Pattern PATTERN = Pattern.compile("\\d+(\\.\\d+)*");
    private static final String SEPARATOR = ".";
    private int[] segments;

    public Version(String version) throws IllegalArgumentException {
        if (null != version) {
            if (version.trim().length() == 0) {
                this.segments = new int[0];
            } else {
                String[] tmp = version.split("\\.");
                this.segments = new int[tmp.length];
                for (int i = 0; i < tmp.length; ++i) {
                    try {
                        this.segments[i] = Integer.parseInt(tmp[i]);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException(version + "is not valid");
                    }
                }
            }
        } else {
            this.segments = new int[1];
            this.segments[0] = 0;
        }
    }

    public Version(int ... version) {
        this.segments = version;
        if (null == this.segments || 0 == this.segments.length) {
            this.segments = new int[1];
            this.segments[0] = 0;
        }
    }

    public static final boolean isVersion(String string) {
        boolean isVersion = null == string ? false : PATTERN.matcher(string).matches();
        return isVersion;
    }

    public int getSegmentCount() {
        return this.segments.length;
    }

    public int getSegment(int index) {
        return this.segments[index];
    }

    @Override
    public int compareTo(Version version) {
        int unset = 3;
        int result = 3;
        int segmentCount = Math.min(this.getSegmentCount(), version.getSegmentCount());
        if (result == 3) {
            for (int i = 0; i < segmentCount; ++i) {
                if (this.getSegment(i) > version.getSegment(i)) {
                    result = 1;
                    break;
                }
                if (this.getSegment(i) >= version.getSegment(i)) continue;
                result = -1;
                break;
            }
        }
        if (result == 3 && version.getSegmentCount() < this.getSegmentCount()) {
            result = 1;
        } else if (result == 3 && version.getSegmentCount() > this.getSegmentCount()) {
            result = -1;
        } else if (result == 3) {
            result = 0;
        }
        return result;
    }

    public String toString() {
        StringBuilder version = new StringBuilder();
        for (int i = 0; i < this.segments.length; ++i) {
            if (version.length() > 0) {
                version.append(SEPARATOR);
            }
            version.append(this.segments[i]);
        }
        return version.toString();
    }

    public static boolean equals(Version version1, Version version2) {
        boolean equals = false;
        if (null == version1) {
            equals = null == version2;
        } else if (null != version2) {
            equals = 0 == version1.compareTo(version2);
        }
        return equals;
    }

    public static int compare(Version version1, Version version2) {
        int result = null == version1 ? (null == version2 ? 0 : -1) : (null == version2 ? 1 : version1.compareTo(version2));
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.segments);
        return result;
    }

    public boolean equals(Object obj) {
        boolean equal;
        boolean bl = equal = this == obj;
        if (!equal && obj instanceof Version) {
            Version other = (Version)obj;
            equal = Arrays.equals(this.segments, other.segments);
        }
        return equal;
    }
}

