/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.iip_aas;

import de.iip_ecosphere.platform.support.aas.Operation;
import de.iip_ecosphere.platform.support.aas.Property;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.aas.SubmodelElementCollection;
import de.iip_ecosphere.platform.support.iip_aas.AasUtils;
import de.iip_ecosphere.platform.support.iip_aas.ActiveAasBase;
import de.iip_ecosphere.platform.support.iip_aas.SubmodelClient;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubmodelElementsCollectionClient
extends SubmodelClient {
    private String collectionId;

    public SubmodelElementsCollectionClient(String submodel, String collectionId) throws IOException {
        this(ActiveAasBase.getSubmodel(submodel), collectionId);
    }

    public SubmodelElementsCollectionClient(Submodel submodel, String collectionId) {
        super(submodel);
        this.collectionId = collectionId;
    }

    @Override
    protected Operation getOperation(String idShort) throws ExecutionException {
        Operation result = null;
        SubmodelElementCollection resource = this.getSubmodel().getSubmodelElementCollection(AasUtils.fixId(this.collectionId));
        if (resource != null) {
            result = resource.getOperation(idShort);
        }
        if (null == result) {
            throw new ExecutionException("Operation `" + idShort + "` on resource `" + this.collectionId + "` not found.", null);
        }
        return result;
    }

    @Override
    protected Property getProperty(String idShort) throws ExecutionException {
        Property result = null;
        SubmodelElementCollection resource = this.getSubmodel().getSubmodelElementCollection(AasUtils.fixId(this.collectionId));
        if (resource != null) {
            result = resource.getProperty(idShort);
        }
        if (null == result) {
            throw new ExecutionException("Property `" + idShort + "` on resource `" + this.collectionId + "` not found.", null);
        }
        return result;
    }

    protected Logger getLogger() {
        return LoggerFactory.getLogger(this.getClass());
    }
}

