/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.iip_aas;

import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.AasFactory;
import de.iip_ecosphere.platform.support.aas.InvocablesCreator;
import de.iip_ecosphere.platform.support.aas.ProtocolServerBuilder;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.aas.SubmodelElementCollection;
import de.iip_ecosphere.platform.support.aas.SubmodelElementContainerBuilder;
import de.iip_ecosphere.platform.support.aas.Type;
import de.iip_ecosphere.platform.support.iip_aas.AasContributor;
import de.iip_ecosphere.platform.support.iip_aas.AasPartRegistry;
import de.iip_ecosphere.platform.support.iip_aas.AasUtils;
import de.iip_ecosphere.platform.support.iip_aas.ApplicationSetup;
import de.iip_ecosphere.platform.support.iip_aas.json.JsonResultWrapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import org.apache.commons.io.FileUtils;

public class PlatformAas
implements AasContributor {
    public static final String NAME_SUBMODEL = "platform";
    public static final String SUBMODEL_NAMEPLATE = "TechnicalData";
    public static final String NAME_PROPERTY_NAME = "name";
    public static final String NAME_PROPERTY_VERSION = "version";
    public static final String NAME_PROPERTY_RELEASE = "isRelease";
    public static final String NAME_PROPERTY_BUILDID = "buildId";
    public static final String NAME_OPERATION_SNAPSHOTAAS = "snapshotAas";
    public static final String NAME_PROPERTY_ID = "Id";
    public static final String NAME_PROPERTY_PRODUCTIMAGE = "ProductImage";
    public static final String NAME_PROPERTY_MANUFACTURER_LOGO = "ManufacturerLogo";
    public static final String NAME_PROPERTY_MANUFACTURER_NAME = "ManufacturerName";
    public static final String NAME_PROPERTY_MANUFACTURER_PRODUCT_DESIGNATION = "ManufacturerProductDesignation";
    public static final String NAME_SMC_ADDRESS = "Address";
    public static final String NAME_PROPERTY_CITYTOWN = "CityTown";
    public static final String NAME_PROPERTY_DEPARTMENT = "Department";
    public static final String NAME_PROPERTY_STREET = "Street";
    public static final String NAME_PROPERTY_ZIPCODE = "ZipCode";
    private static final String MAVEN_SNAPSHOT_POSTFIX = "-SNAPSHOT";
    private static AasUtils.ResourceResolver imageResolver = AasUtils.CLASSPATH_RESOURCE_RESOLVER;

    public static void setImageResolver(AasUtils.ResourceResolver resolver) {
        if (null != resolver) {
            imageResolver = resolver;
        }
    }

    public static AasUtils.ResourceResolver getImageResolver() {
        return imageResolver;
    }

    @Override
    public Aas contributeTo(Aas.AasBuilder aasBuilder, InvocablesCreator iCreator) {
        Submodel.SubmodelBuilder smB = aasBuilder.createSubmodelBuilder(NAME_SUBMODEL, null);
        if (smB.isNew()) {
            String ver = "";
            String buildId = "??";
            boolean isRelease = false;
            InputStream is = this.getClass().getClassLoader().getResourceAsStream("iip-version.properties");
            if (null != is) {
                Properties prop = new Properties();
                try {
                    prop.load(is);
                    is.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                ver = prop.getOrDefault((Object)NAME_PROPERTY_VERSION, ver).toString();
                if (ver.endsWith(MAVEN_SNAPSHOT_POSTFIX)) {
                    ver = ver.substring(0, ver.length() - MAVEN_SNAPSHOT_POSTFIX.length());
                } else {
                    isRelease = true;
                }
                buildId = prop.getOrDefault((Object)NAME_PROPERTY_BUILDID, buildId).toString();
            }
            ApplicationSetup setup = new ApplicationSetup();
            setup.setVersion(ver);
            setup.setName("IIP-Ecosphere platform");
            setup.setManufacturerName("IIP-Ecosphere Consortium@de");
            setup.setManufacturerLogo("IIP-Ecosphere-Logo.png");
            setup.setProductImage("IIP-Ecosphere-Platform.png");
            setup.setDescription("The IIP-Ecosphere AI-enabled I4.0 platform.@de");
            ApplicationSetup.Address addr = new ApplicationSetup.Address();
            addr.setDepartment("University of Hildesheim, SSE - Software Systems Engineering@de");
            addr.setStreet("Universit\u00e4tsplatz 1@de");
            addr.setZipCode("31141@de");
            addr.setCityTown("Hildesheim/Hannover@de");
            setup.setAddress(addr);
            Submodel.SubmodelBuilder smBuilder = PlatformAas.createNameplate(aasBuilder, setup);
            PlatformAas.addSoftwareInfo(smBuilder, setup);
            smBuilder.build();
            PlatformAas.addSoftwareInfo(smB, setup);
            smB.createPropertyBuilder(NAME_PROPERTY_RELEASE).setValue(Type.BOOLEAN, (Object)isRelease).build();
            smB.createPropertyBuilder(NAME_PROPERTY_BUILDID).setValue(Type.STRING, (Object)buildId).build();
            smB.createOperationBuilder(NAME_OPERATION_SNAPSHOTAAS).addInputVariable("id", Type.STRING).setInvocable(iCreator.createInvocable(NAME_OPERATION_SNAPSHOTAAS)).build(Type.STRING);
            smB.build();
        }
        return null;
    }

    public static void addSoftwareInfo(Submodel.SubmodelBuilder smB, ApplicationSetup appSetup) {
        if (null != appSetup.getId()) {
            smB.createPropertyBuilder(NAME_PROPERTY_ID).setValue(Type.STRING, (Object)appSetup.getId()).build();
        }
        smB.createPropertyBuilder(NAME_PROPERTY_NAME).setValue(Type.STRING, (Object)appSetup.getName()).build();
        smB.createPropertyBuilder(NAME_PROPERTY_VERSION).setValue(Type.STRING, (Object)(null == appSetup.getVersion() ? "" : appSetup.getVersion().toString())).build();
    }

    public static Submodel.SubmodelBuilder createNameplate(Aas.AasBuilder aasBuilder, ApplicationSetup appSetup) {
        Submodel.SubmodelBuilder sBuilder = aasBuilder.createSubmodelBuilder(SUBMODEL_NAMEPLATE, null);
        AasUtils.resolveImage(appSetup.getProductImage(), imageResolver, true, (n, r, m) -> sBuilder.createFileDataElementBuilder(NAME_PROPERTY_PRODUCTIMAGE, r, m).build());
        AasUtils.resolveImage(appSetup.getManufacturerLogo(), imageResolver, true, (n, r, m) -> sBuilder.createFileDataElementBuilder(NAME_PROPERTY_MANUFACTURER_LOGO, r, m).build());
        sBuilder.createPropertyBuilder(NAME_PROPERTY_MANUFACTURER_NAME).setValue(Type.LANG_STRING, (Object)appSetup.getManufacturerName()).build();
        sBuilder.createPropertyBuilder(NAME_PROPERTY_MANUFACTURER_PRODUCT_DESIGNATION).setValue(Type.LANG_STRING, (Object)appSetup.getManufacturerProductDesignation()).build();
        PlatformAas.createAddress((SubmodelElementContainerBuilder)sBuilder, appSetup.getAddress());
        return sBuilder;
    }

    public static void createAddress(SubmodelElementContainerBuilder smBuilder, ApplicationSetup.Address address) {
        if (null != address) {
            SubmodelElementCollection.SubmodelElementCollectionBuilder aBuilder = smBuilder.createSubmodelElementCollectionBuilder(NAME_SMC_ADDRESS, false, false);
            aBuilder.createPropertyBuilder(NAME_PROPERTY_CITYTOWN).setValue(Type.LANG_STRING, (Object)address.getCityTown()).build();
            aBuilder.createPropertyBuilder(NAME_PROPERTY_DEPARTMENT).setValue(Type.LANG_STRING, (Object)address.getDepartment()).build();
            aBuilder.createPropertyBuilder(NAME_PROPERTY_STREET).setValue(Type.LANG_STRING, (Object)address.getStreet()).build();
            aBuilder.createPropertyBuilder(NAME_PROPERTY_ZIPCODE).setValue(Type.LANG_STRING, (Object)address.getZipCode()).build();
            aBuilder.build();
        }
    }

    @Override
    public void contributeTo(ProtocolServerBuilder sBuilder) {
        sBuilder.defineOperation(NAME_OPERATION_SNAPSHOTAAS, (Function)new JsonResultWrapper(p -> PlatformAas.snapshotAas(AasUtils.readString(p))));
    }

    static String snapshotAas(String id) throws ExecutionException {
        String result = "";
        List<Aas> aas = AasPartRegistry.getIipAasInstance();
        if (null != aas) {
            String name = "platform-";
            if (null != id && id.length() > 0) {
                name = name + id + "-";
            }
            name = name + System.currentTimeMillis() + ".aasx";
            try {
                File file = new File(FileUtils.getTempDirectory(), name);
                AasFactory.getInstance().createPersistenceRecipe().writeTo(aas, file);
                result = file.getAbsolutePath();
            }
            catch (IOException e) {
                throw new ExecutionException(e);
            }
        } else {
            throw new ExecutionException("No suitable AAS instance available. Cannot write AAS.", null);
        }
        return result;
    }

    @Override
    public AasContributor.Kind getKind() {
        return AasContributor.Kind.ACTIVE;
    }

    @Override
    public boolean isValid() {
        return true;
    }
}

