/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.iip_aas;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.InvocablesCreator;
import de.iip_ecosphere.platform.support.aas.Property;
import de.iip_ecosphere.platform.support.aas.ProtocolServerBuilder;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.aas.Type;
import de.iip_ecosphere.platform.support.iip_aas.AasContributor;
import de.iip_ecosphere.platform.support.iip_aas.AasUtils;
import de.iip_ecosphere.platform.support.iip_aas.config.ServerAddressHolder;
import de.iip_ecosphere.platform.support.iip_aas.json.JsonUtils;
import de.iip_ecosphere.platform.support.net.ManagedServerAddress;
import de.iip_ecosphere.platform.support.net.NetworkManagerFactory;

public class NetworkManagerAas
implements AasContributor {
    public static final String NAME_SUBMODEL = "netMgt";
    public static final String OP_RELEASE_PORT = "releasePort";
    public static final String OP_IS_IN_USE_PORT = "isInUsePortPort";
    public static final String OP_IS_IN_USE_ADR = "isInUsePortAdr";
    public static final String OP_GET_PORT = "getPort";
    public static final String PROP_HIGH_PORT = "highPort";
    public static final String PROP_LOW_PORT = "lowPort";
    public static final String OP_OBTAIN_PORT = "obtainPort";
    public static final String OP_RESERVE_PORT = "reservePort";

    @Override
    public Aas contributeTo(Aas.AasBuilder aasBuilder, InvocablesCreator iCreator) {
        Submodel.SubmodelBuilder smB = aasBuilder.createSubmodelBuilder(NAME_SUBMODEL, null);
        if (smB.isNew()) {
            smB.createOperationBuilder(OP_RESERVE_PORT).addInputVariable("key", Type.STRING).addInputVariable("address", Type.STRING).setInvocable(iCreator.createInvocable(NetworkManagerAas.getQName(OP_RESERVE_PORT))).build(Type.STRING);
            smB.createOperationBuilder(OP_OBTAIN_PORT).addInputVariable("key", Type.STRING).setInvocable(iCreator.createInvocable(NetworkManagerAas.getQName(OP_OBTAIN_PORT))).build(Type.STRING);
            smB.createOperationBuilder(OP_GET_PORT).addInputVariable("key", Type.STRING).setInvocable(iCreator.createInvocable(NetworkManagerAas.getQName(OP_GET_PORT))).build(Type.STRING);
            smB.createOperationBuilder(OP_IS_IN_USE_PORT).addInputVariable("port", Type.INTEGER).setInvocable(iCreator.createInvocable(NetworkManagerAas.getQName(OP_IS_IN_USE_PORT))).build(Type.BOOLEAN);
            smB.createOperationBuilder(OP_IS_IN_USE_ADR).addInputVariable("adr", Type.STRING).setInvocable(iCreator.createInvocable(NetworkManagerAas.getQName(OP_IS_IN_USE_ADR))).build(Type.BOOLEAN);
            smB.createOperationBuilder(OP_RELEASE_PORT).addInputVariable("key", Type.STRING).setInvocable(iCreator.createInvocable(NetworkManagerAas.getQName(OP_RELEASE_PORT))).build(Type.NONE);
            smB.createPropertyBuilder(PROP_HIGH_PORT).setType(Type.INTEGER).bind(iCreator.createGetter(NetworkManagerAas.getQName(PROP_HIGH_PORT)), Property.PropertyBuilder.READ_ONLY).build();
            smB.createPropertyBuilder(PROP_LOW_PORT).setType(Type.INTEGER).bind(iCreator.createGetter(NetworkManagerAas.getQName(PROP_LOW_PORT)), Property.PropertyBuilder.READ_ONLY).build();
            smB.build();
        }
        return null;
    }

    @Override
    public void contributeTo(ProtocolServerBuilder sBuilder) {
        sBuilder.defineOperation(NetworkManagerAas.getQName(OP_RESERVE_PORT), p -> NetworkManagerAas.toJson(NetworkManagerFactory.getInstance().reservePort(AasUtils.readString(p, 0, null), JsonUtils.serverAddressFromJson(AasUtils.readString(p, 1, null)))));
        sBuilder.defineOperation(NetworkManagerAas.getQName(OP_OBTAIN_PORT), p -> NetworkManagerAas.toJson(NetworkManagerFactory.getInstance().obtainPort(AasUtils.readString(p, 0, null))));
        sBuilder.defineOperation(NetworkManagerAas.getQName(OP_GET_PORT), p -> NetworkManagerAas.toJson(NetworkManagerFactory.getInstance().getPort(AasUtils.readString(p, 0, null))));
        sBuilder.defineOperation(NetworkManagerAas.getQName(OP_IS_IN_USE_PORT), p -> NetworkManagerFactory.getInstance().isInUse(AasUtils.readInt(p, 0, -1)));
        sBuilder.defineOperation(NetworkManagerAas.getQName(OP_IS_IN_USE_ADR), p -> NetworkManagerFactory.getInstance().isInUse(JsonUtils.serverAddressFromJson(AasUtils.readString(p, 0, null))));
        sBuilder.defineOperation(NetworkManagerAas.getQName(OP_RELEASE_PORT), p -> {
            NetworkManagerFactory.getInstance().releasePort(AasUtils.readString(p, 0, null));
            return null;
        });
        sBuilder.defineProperty(NetworkManagerAas.getQName(PROP_HIGH_PORT), () -> NetworkManagerFactory.getInstance().getHighPort(), Property.PropertyBuilder.READ_ONLY);
        sBuilder.defineProperty(NetworkManagerAas.getQName(PROP_LOW_PORT), () -> NetworkManagerFactory.getInstance().getLowPort(), Property.PropertyBuilder.READ_ONLY);
    }

    public static String getQName(String elementName) {
        return "netMgt_" + elementName;
    }

    public static ManagedServerAddress managedServerAddressFromJson(Object json) {
        ManagedServerAddress result = null;
        if (null != json) {
            try {
                ObjectMapper objectMapper = new ObjectMapper();
                ManagedServerAddressHolder tmp = (ManagedServerAddressHolder)objectMapper.readValue(json.toString(), ManagedServerAddressHolder.class);
                result = new ManagedServerAddress(tmp.getSchema(), tmp.getHost(), tmp.getPort(), tmp.isNew());
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
        }
        return result;
    }

    public static String toJson(ManagedServerAddress address) {
        String result = "";
        if (null != address) {
            try {
                ObjectMapper objectMapper = new ObjectMapper();
                ManagedServerAddressHolder tmp = new ManagedServerAddressHolder(address);
                result = objectMapper.writeValueAsString((Object)tmp);
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public AasContributor.Kind getKind() {
        return AasContributor.Kind.ACTIVE;
    }

    @Override
    public boolean isValid() {
        return NetworkManagerFactory.getInstance() != null;
    }

    static class ManagedServerAddressHolder
    extends ServerAddressHolder {
        private boolean isNew;

        ManagedServerAddressHolder() {
        }

        ManagedServerAddressHolder(ManagedServerAddress addr) {
            super((ServerAddress)addr);
            this.isNew = addr.isNew();
        }

        public boolean isNew() {
            return this.isNew;
        }

        public void setNew(boolean isNew) {
            this.isNew = isNew;
        }
    }
}

