/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.iip_aas;

import de.iip_ecosphere.platform.support.iip_aas.IdProvider;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import org.slf4j.LoggerFactory;

public class MacIdProvider
implements IdProvider {
    @Override
    public String provideId() {
        String macAddress = null;
        try {
            Enumeration<NetworkInterface> ne;
            InetAddress localHost = InetAddress.getLocalHost();
            NetworkInterface ni = NetworkInterface.getByInetAddress(localHost);
            if (ni == null && (ne = NetworkInterface.getNetworkInterfaces()).hasMoreElements()) {
                ni = ne.nextElement();
            }
            if (null != ni) {
                byte[] hardwareAddress = ni.getHardwareAddress();
                CharSequence[] hexadecimal = new String[hardwareAddress.length];
                for (int i = 0; i < hardwareAddress.length; ++i) {
                    hexadecimal[i] = String.format("%02X", hardwareAddress[i]);
                }
                macAddress = String.join((CharSequence)"", hexadecimal);
            }
        }
        catch (IOException e) {
            LoggerFactory.getLogger(MacIdProvider.class).error("Obtaining MAC-based device ID: " + e.getMessage());
        }
        return macAddress;
    }

    @Override
    public boolean allowsConsoleOverride() {
        return true;
    }
}

