/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.iip_aas;

import de.iip_ecosphere.platform.support.LifecycleHandler;
import de.iip_ecosphere.platform.support.iip_aas.AasUtils;
import de.iip_ecosphere.platform.support.iip_aas.IdProvider;
import de.iip_ecosphere.platform.support.iip_aas.IdProviderDescriptor;
import de.iip_ecosphere.platform.support.iip_aas.MacIdProvider;
import de.iip_ecosphere.platform.support.iip_aas.config.CmdLine;
import de.iip_ecosphere.platform.support.jsl.ServiceLoaderUtils;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.util.Optional;
import org.slf4j.LoggerFactory;

public class Id {
    private static final String JVM_NAME;
    private static final String JVM_NAME_AAS;
    private static final String DEVICE_ID;
    private static final String DEVICE_ID_AAS;
    private static final String DEVICE_NAME;
    private static final String DEVICE_NAME_AAS;
    private static final String DEVICE_IP;
    private static final String DEVICE_IP_AAS;

    public static final String getEnvId() {
        return JVM_NAME;
    }

    public static final String getEnvIdAas() {
        return JVM_NAME_AAS;
    }

    public static final String getDeviceId() {
        return DEVICE_ID;
    }

    public static final String getDeviceIdAas() {
        return DEVICE_ID_AAS;
    }

    public static final String getDeviceName() {
        return DEVICE_NAME;
    }

    public static final String getDeviceNameAas() {
        return DEVICE_NAME_AAS;
    }

    public static final String getDeviceIp() {
        return DEVICE_IP;
    }

    public static final String getDeviceIpAas() {
        return DEVICE_IP_AAS;
    }

    static {
        String overrideId;
        JVM_NAME = ManagementFactory.getRuntimeMXBean().getName();
        JVM_NAME_AAS = AasUtils.fixId(JVM_NAME);
        Optional desc = ServiceLoaderUtils.findFirst(IdProviderDescriptor.class);
        IdProvider provider = desc.isPresent() ? ((IdProviderDescriptor)desc.get()).createProvider() : new MacIdProvider();
        String deviceId = null;
        String hostName = null;
        String ip = null;
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            hostName = localHost.getHostName();
            ip = localHost.getHostAddress();
        }
        catch (IOException e) {
            LoggerFactory.getLogger(Id.class).error("Obtaining device ID: " + e.getMessage());
            hostName = JVM_NAME;
            ip = "";
        }
        String providerName = "?";
        if (provider.allowsConsoleOverride() && null != LifecycleHandler.getCmdArgs() && null != (overrideId = CmdLine.getArg(LifecycleHandler.getCmdArgs(), "iip.id", null))) {
            deviceId = overrideId;
            providerName = "command line";
        }
        if (null == deviceId) {
            deviceId = provider.provideId();
            providerName = provider.getClass().getName();
        }
        if (null == deviceId) {
            deviceId = JVM_NAME;
            providerName = "fallback";
        }
        LoggerFactory.getLogger(Id.class).info("USING id " + deviceId + " from " + providerName);
        DEVICE_ID = deviceId;
        DEVICE_ID_AAS = AasUtils.fixId(deviceId);
        DEVICE_NAME = hostName;
        DEVICE_NAME_AAS = AasUtils.fixId(hostName);
        DEVICE_IP = ip;
        DEVICE_IP_AAS = AasUtils.fixId(ip);
    }
}

