/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.iip_aas;

import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.Reference;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.aas.SubmodelElement;
import de.iip_ecosphere.platform.support.aas.SubmodelElementCollection;
import de.iip_ecosphere.platform.support.aas.SubmodelElementContainerBuilder;
import de.iip_ecosphere.platform.support.aas.Type;
import de.iip_ecosphere.platform.support.iip_aas.AasUtils;
import de.iip_ecosphere.platform.support.iip_aas.Id;
import de.iip_ecosphere.platform.support.iip_aas.Skip;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;

public class ClassUtility {
    public static final String NAME_TYPE_SUBMODEL = "types";
    public static final String ATTRIBUTE_PREFIX = "attr_";
    public static final String NAME_ARRAY_PROPERTY_TYPE = "type";
    public static final String NAME_ARRAY_PROPERTY_DIMENSIONS = "nesting";
    private static final Map<Class<?>, String> NAME_MAPPING = new HashMap();

    private static void registerBySimpleName(Class<?> type) {
        NAME_MAPPING.put(type, type.getSimpleName());
    }

    private static void registerBySimpleName(Class<?> type, Class<?> nameType) {
        NAME_MAPPING.put(type, nameType.getSimpleName());
    }

    public static Reference addType(Aas.AasBuilder aasBuilder, Class<?> type) {
        Submodel.SubmodelBuilder smb = aasBuilder.createSubmodelBuilder(NAME_TYPE_SUBMODEL, null);
        SubmodelElementCollection.SubmodelElementCollectionBuilder typeCollection = smb.createSubmodelElementCollectionBuilder(ClassUtility.getName(type), false, false);
        Reference result = ClassUtility.addType(typeCollection, type);
        typeCollection.build();
        smb.build();
        return result;
    }

    private static Reference addType(SubmodelElementCollection.SubmodelElementCollectionBuilder builder, Class<?> type) {
        Reference result;
        if (type.isPrimitive() || type.isArray()) {
            result = null;
        } else {
            if (builder.isNew()) {
                for (Field f : type.getDeclaredFields()) {
                    if (Modifier.isStatic(f.getModifiers()) || null != f.getAnnotation(Skip.class)) continue;
                    ClassUtility.addTypeSubModelElement((SubmodelElementContainerBuilder)builder, ATTRIBUTE_PREFIX + AasUtils.fixId(f.getName()), f.getType());
                }
                if (Object.class != type.getSuperclass()) {
                    ClassUtility.addType(builder, type.getSuperclass());
                }
            }
            result = builder.createReference();
        }
        return result;
    }

    public static SubmodelElement addTypeSubModelElement(SubmodelElementContainerBuilder subModelBuilder, String idShort, Class<?> type) {
        SubmodelElement result;
        if (NAME_MAPPING.containsKey(type)) {
            result = (SubmodelElement)subModelBuilder.createPropertyBuilder(idShort).setType(Type.STRING).setValue((Object)NAME_MAPPING.get(type)).build();
        } else if (type.isArray()) {
            SubmodelElementCollection.SubmodelElementCollectionBuilder cBuilder = subModelBuilder.createSubmodelElementCollectionBuilder(idShort, false, false);
            ClassUtility.addTypeSubModelElement((SubmodelElementContainerBuilder)cBuilder, NAME_ARRAY_PROPERTY_TYPE, type.getComponentType());
            cBuilder.createPropertyBuilder(NAME_ARRAY_PROPERTY_DIMENSIONS).setType(Type.INTEGER).setValue((Object)((int)type.getSimpleName().chars().filter(c -> c == 91).count())).build();
            result = (SubmodelElement)cBuilder.build();
        } else {
            Reference aRef = ClassUtility.addType(subModelBuilder.getAasBuilder(), type);
            result = (SubmodelElement)subModelBuilder.createReferenceElementBuilder(idShort).setValue(aRef).build();
        }
        return result;
    }

    public static String getName(Class<?> type) {
        return AasUtils.fixId(type.getName());
    }

    public static String getId(String prefix, Object object) {
        return AasUtils.fixId(prefix + Id.getEnvId() + "_" + System.identityHashCode(object));
    }

    static {
        ClassUtility.registerBySimpleName(Integer.TYPE);
        ClassUtility.registerBySimpleName(Long.TYPE);
        ClassUtility.registerBySimpleName(Double.TYPE);
        ClassUtility.registerBySimpleName(Float.TYPE);
        ClassUtility.registerBySimpleName(Boolean.TYPE);
        ClassUtility.registerBySimpleName(Short.TYPE);
        ClassUtility.registerBySimpleName(Character.TYPE);
        ClassUtility.registerBySimpleName(String.class);
        ClassUtility.registerBySimpleName(Integer.class, Integer.TYPE);
        ClassUtility.registerBySimpleName(Long.class, Long.TYPE);
        ClassUtility.registerBySimpleName(Double.class, Double.TYPE);
        ClassUtility.registerBySimpleName(Float.class, Float.TYPE);
        ClassUtility.registerBySimpleName(Boolean.class, Boolean.TYPE);
        ClassUtility.registerBySimpleName(Short.class, Short.TYPE);
        ClassUtility.registerBySimpleName(Character.class, Character.TYPE);
    }
}

