/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.iip_aas;

import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.AasFactory;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.iip_aas.AasPartRegistry;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveAasBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActiveAasBase.class);
    private static NotificationMode mode = NotificationMode.ASYNCHRONOUS;
    private static ExecutorService exec = Executors.newFixedThreadPool(5);

    public static void processNotification(String subId, NotificationProcessor processor) {
        ActiveAasBase.processNotification(subId, mode, processor);
    }

    public static void processNotification(String subId, NotificationMode mode, NotificationProcessor processor) {
        if (ActiveAasBase.mode != NotificationMode.NONE) {
            if (null == mode) {
                mode = ActiveAasBase.mode;
            }
            try {
                Aas aas = AasPartRegistry.retrieveIipAas();
                if (null != aas) {
                    Submodel submodel = aas.getSubmodel(subId);
                    if (null != submodel) {
                        if (NotificationMode.SYNCHRONOUS == mode) {
                            processor.process(submodel, aas);
                        } else {
                            exec.execute(() -> processor.process(submodel, aas));
                        }
                    }
                } else if (!AasFactory.isNoInstanceWarningEmitted()) {
                    LOGGER.error("Cannot find submodel: " + subId);
                }
            }
            catch (IOException e) {
                LOGGER.error("While retrieving the IIP-Ecosphere AAS: " + e.getMessage());
            }
        }
    }

    public static NotificationMode setNotificationMode(NotificationMode mo) {
        NotificationMode old = mode;
        mode = mo;
        return old;
    }

    public static Submodel getSubmodel(String name) throws IOException {
        Aas aas = AasPartRegistry.retrieveIipAas();
        if (null == aas) {
            throw new IOException("No IIP-AAS found");
        }
        Submodel submodel = aas.getSubmodel(name);
        if (null == submodel) {
            throw new IOException("No submodel '" + name + "' found");
        }
        return submodel;
    }

    public static interface NotificationProcessor {
        public void process(Submodel var1, Aas var2);
    }

    public static enum NotificationMode {
        ASYNCHRONOUS,
        SYNCHRONOUS,
        NONE;

    }
}

