/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.iip_aas;

import de.iip_ecosphere.platform.support.LifecycleDescriptor;
import de.iip_ecosphere.platform.support.Server;
import de.iip_ecosphere.platform.support.aas.AasFactory;
import de.iip_ecosphere.platform.support.iip_aas.AasPartRegistry;
import de.iip_ecosphere.platform.support.iip_aas.config.CmdLine;
import java.io.IOException;
import java.util.function.Supplier;
import org.slf4j.LoggerFactory;

public class AbstractAasLifecycleDescriptor
implements LifecycleDescriptor {
    public static final String PARAM_IIP_PORT = "iip.port";
    private String name;
    private Supplier<AasPartRegistry.AasSetup> setupSupplier;
    private Server implServer;
    private Server aasServer;

    protected AbstractAasLifecycleDescriptor(String name, Supplier<AasPartRegistry.AasSetup> setupSupplier) {
        this.name = name;
        this.setupSupplier = setupSupplier;
    }

    public void startup(String[] args) {
        int port = CmdLine.getIntArg(args, PARAM_IIP_PORT, -1);
        if (port > 0) {
            this.setupSupplier.get().getImplementation().setPort(port);
            LoggerFactory.getLogger(this.getClass()).info("Using port " + port + " for the AAS implementation server.");
        }
        if (AasFactory.isFullInstance()) {
            AasPartRegistry.AasSetup setup = this.setupSupplier.get();
            AasPartRegistry.setAasSetup(setup);
            AasPartRegistry.AasBuildResult res = AasPartRegistry.build(true);
            this.implServer = res.getProtocolServer();
            boolean success = true;
            if (AasPartRegistry.AasMode.REGISTER == setup.getMode()) {
                try {
                    this.aasServer = AasPartRegistry.register(res.getAas(), setup.getRegistryEndpoint(), new String[0]);
                    this.aasServer.start();
                }
                catch (IOException e) {
                    LoggerFactory.getLogger(this.getClass()).error("Cannot register AAS " + this.name + " with " + setup.getRegistryEndpoint().toUri() + ":" + e.getMessage());
                    success = false;
                }
            } else {
                try {
                    AasPartRegistry.remoteDeploy(res.getAas());
                }
                catch (IOException e) {
                    LoggerFactory.getLogger(this.getClass()).error("Cannot deploy AAS " + this.name + ": " + e.getMessage());
                    success = false;
                }
            }
            if (success) {
                AasPartRegistry.setAasSupplier(() -> res.getAas());
            }
        } else {
            LoggerFactory.getLogger(this.getClass()).warn("No full AAS implementation registered. Cannot build up " + this.name + " AAS. Please add an appropriate dependency.");
        }
    }

    public void shutdown() {
        if (null != this.implServer) {
            this.implServer.stop(true);
        }
        if (null != this.aasServer) {
            this.implServer.stop(true);
        }
    }

    public Thread getShutdownHook() {
        return null;
    }

    public int priority() {
        return 100;
    }
}

