/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.iip_aas;

import de.iip_ecosphere.platform.support.FileUtils;
import de.iip_ecosphere.platform.support.aas.AasFactory;
import de.iip_ecosphere.platform.support.iip_aas.PlatformAas;
import de.iip_ecosphere.platform.support.iip_aas.json.JsonUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.util.Map;
import org.slf4j.LoggerFactory;

public class AasUtils {
    public static final URI EMPTY_URI;
    public static final ResourceResolver CLASSPATH_RESOLVER;
    public static final ResourceResolver CLASSPATH_RESOURCE_RESOLVER;

    public static final String prependSlash(String text) {
        if (!text.startsWith("/")) {
            text = "/" + text;
        }
        return text;
    }

    public static String readString(Object[] args) {
        return AasUtils.readString(args, 0);
    }

    public static String readString(Object[] args, int index) {
        return AasUtils.readString(args, index, "");
    }

    public static String readString(Object[] args, int index, String dflt) {
        Object param = index >= 0 && index < args.length ? args[index] : null;
        return null == param ? dflt : param.toString();
    }

    public static int readInt(Object[] args, int index, int dflt) {
        Object param = index >= 0 && index < args.length ? args[index] : null;
        int result = dflt;
        if (null != param) {
            try {
                result = Integer.parseInt(param.toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    public static URI readUriEx(Object[] args, int index, URI dflt) throws URISyntaxException {
        Object param = index >= 0 && index < args.length ? args[index] : null;
        URI result = dflt;
        if (null != param) {
            result = new URI(param.toString());
        }
        return result;
    }

    public static URI readUri(Object[] args, int index, URI dflt) {
        URI result;
        try {
            result = AasUtils.readUriEx(args, index, dflt);
        }
        catch (URISyntaxException e) {
            result = dflt;
        }
        return result;
    }

    public static String fixId(String id) {
        return AasFactory.getInstance().fixId(id);
    }

    public static Map<String, String> readMap(Object[] args, int index, Map<String, String> dflt) {
        Object param = index >= 0 && index < args.length ? args[index] : null;
        Map result = dflt;
        if (null != param) {
            result = JsonUtils.fromJson(result, Map.class);
        }
        return result;
    }

    public static String writeMap(Map<String, String> map) {
        return JsonUtils.toJson(map);
    }

    public static void resolveImage(String image, ResourceResolver resolver, boolean handleAlways, ResourceHandler handler) {
        boolean resolved = false;
        if (null == resolver) {
            resolver = CLASSPATH_RESOURCE_RESOLVER;
        }
        if (null != image && image.length() > 0) {
            String prevMsg = "";
            try {
                String fName = FileUtils.sanitizeFileName((String)image);
                File f = new File(FileUtils.getTempDirectory(), fName);
                FileUtils.deleteOnExit((File)f);
                InputStream is = resolver.resolve(image);
                if (null != is) {
                    org.apache.commons.io.FileUtils.copyInputStreamToFile((InputStream)is, (File)f);
                    String contents = FileUtils.fileToBase64((File)f);
                    String mimeType = Files.probeContentType(f.toPath());
                    handler.handle(fName, contents, mimeType);
                    resolved = true;
                }
            }
            catch (IOException e) {
                prevMsg = e.getMessage();
            }
            if (!resolved) {
                try {
                    URL url = new URL(image);
                    if ("http".equals(url.getProtocol()) || "https".equals(url.getProtocol())) {
                        String name = url.getFile();
                        int pos = name.lastIndexOf(47);
                        if (pos > 0) {
                            name = name.substring(pos + 1);
                        }
                        name = AasUtils.fixId(name);
                        handler.handle(name, url.toString(), "text/x-uri");
                        resolved = true;
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            if (!resolved) {
                LoggerFactory.getLogger(PlatformAas.class).warn("Cannot resolve image '{}' {}", (Object)image, (Object)prevMsg);
            }
        }
        if (!resolved && handleAlways) {
            handler.handle("", "", "");
        }
    }

    static {
        URI tmp;
        CLASSPATH_RESOLVER = n -> PlatformAas.class.getResourceAsStream(AasUtils.prependSlash(n));
        CLASSPATH_RESOURCE_RESOLVER = n -> PlatformAas.class.getResourceAsStream("/resources" + AasUtils.prependSlash(n));
        try {
            tmp = new URI("");
        }
        catch (URISyntaxException e) {
            tmp = null;
        }
        EMPTY_URI = tmp;
    }

    public static interface ResourceHandler {
        public void handle(String var1, String var2, String var3);
    }

    public static interface ResourceResolver {
        public InputStream resolve(String var1);
    }
}

