/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.support.iip_aas;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.iip_ecosphere.platform.support.Endpoint;
import de.iip_ecosphere.platform.support.NetUtils;
import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.Server;
import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.AasFactory;
import de.iip_ecosphere.platform.support.aas.AssetKind;
import de.iip_ecosphere.platform.support.aas.DeploymentRecipe;
import de.iip_ecosphere.platform.support.aas.InvocablesCreator;
import de.iip_ecosphere.platform.support.aas.ProtocolServerBuilder;
import de.iip_ecosphere.platform.support.aas.Registry;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.iip_aas.AasContributor;
import de.iip_ecosphere.platform.support.iip_aas.config.EndpointHolder;
import de.iip_ecosphere.platform.support.iip_aas.config.ProtocolAddressHolder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.slf4j.LoggerFactory;

public class AasPartRegistry {
    public static final String NAME_AAS = "IIP_Ecosphere";
    public static final String NAME_SUBMODEL_RESOURCES = "resources";
    public static final String URN_AAS = "urn:::AAS:::iipEcosphere#";
    public static final String URN_AAS_ASSET = "urn:::AAS:::iipEcosphere#asset";
    public static final Schema DEFAULT_SCHEMA = Schema.HTTP;
    public static final String DEFAULT_HOST = "localhost";
    public static final String NO_SPECIFIC_SERVER_HOST = "-";
    public static final int DEFAULT_PORT = 8080;
    public static final int DEFAULT_REGISTRY_PORT = 8081;
    public static final int DEFAULT_PROTOCOL_PORT = 9000;
    public static final String DEFAULT_AAS_ENDPOINT = "";
    public static final String DEFAULT_REGISTRY_ENDPOINT = "registry";
    public static final String DEFAULT_PROTOCOL = "";
    private static AasSetup setup = new AasSetup();
    private static Supplier<List<Aas>> aasSupplier;

    public static void setAasSupplier(Supplier<List<Aas>> supplier) {
        aasSupplier = supplier;
    }

    public static AasSetup getSetup() {
        return setup;
    }

    public static AasSetup setAasSetup(AasSetup aasSetup) {
        AasSetup old = aasSetup;
        setup = aasSetup;
        return old;
    }

    private static ServiceLoader<AasContributor> getContributorLoader() {
        return ServiceLoader.load(AasContributor.class);
    }

    public static Iterator<AasContributor> contributors() {
        return AasPartRegistry.getContributorLoader().iterator();
    }

    public static Set<Class<? extends AasContributor>> contributorClasses() {
        HashSet<Class<? extends AasContributor>> result = new HashSet<Class<? extends AasContributor>>();
        Iterator<AasContributor> iter = AasPartRegistry.contributors();
        while (iter.hasNext()) {
            result.add(iter.next().getClass());
        }
        return result;
    }

    public static AasBuildResult build() {
        return AasPartRegistry.build(c -> true, false);
    }

    public static AasBuildResult build(boolean startImplServer) {
        return AasPartRegistry.build(c -> true, startImplServer);
    }

    public static AasBuildResult build(Predicate<AasContributor> filter) {
        return AasPartRegistry.build(filter, false);
    }

    public static AasBuildResult build(Predicate<AasContributor> filter, boolean startImplServer) {
        Aas.AasBuilder aasBuilder;
        ArrayList<Object> aas = new ArrayList<Object>();
        AasFactory factory = AasFactory.getInstance();
        try {
            aasBuilder = AasPartRegistry.retrieveIipAas().createAasBuilder();
        }
        catch (IOException e) {
            aasBuilder = factory.createAasBuilder(NAME_AAS, URN_AAS);
            aasBuilder.createAssetBuilder(NAME_AAS, URN_AAS_ASSET, AssetKind.INSTANCE).build();
        }
        ProtocolAddressHolder impl = setup.getImplementation();
        int implPort = ServerAddress.validatePort((int)impl.getPort());
        String implHost = impl.getHost();
        if (implHost.equals("127.0.0.1")) {
            implHost = NetUtils.getOwnIP((String)impl.getNetmask());
            LoggerFactory.getLogger(AasPartRegistry.class).warn("Using IP " + implHost + " for AAS implementation server");
        }
        InvocablesCreator iCreator = factory.createInvocablesCreator(impl.getProtocol(), implHost, implPort, impl.getKeystoreDescriptor());
        ProtocolServerBuilder sBuilder = factory.createProtocolServerBuilder(impl.getProtocol(), implPort, impl.getKeystoreDescriptor());
        Iterator<AasContributor> iter = AasPartRegistry.contributors();
        while (iter.hasNext()) {
            AasContributor contributor = iter.next();
            if (!filter.test(contributor) || !contributor.isValid()) continue;
            Aas partAas = contributor.contributeTo(aasBuilder, iCreator);
            contributor.contributeTo(sBuilder);
            if (null == partAas) continue;
            aas.add(partAas);
        }
        Server protocolServer = null;
        if (startImplServer) {
            LoggerFactory.getLogger(AasPartRegistry.class).info("Starting implementation server on " + implPort);
            protocolServer = ((Server)sBuilder.build()).start();
        }
        aas.add(0, aasBuilder.build());
        return new AasBuildResult(aas, sBuilder, protocolServer);
    }

    public static Aas retrieveIipAas() throws IOException {
        return AasPartRegistry.retrieveAas(URN_AAS);
    }

    public static Aas retrieveAas(String identifier) throws IOException {
        return AasPartRegistry.retrieveAas(setup, identifier);
    }

    public static Aas retrieveAas(AasSetup setup, String identifier) throws IOException {
        Registry reg = AasFactory.getInstance().obtainRegistry(setup.getRegistryEndpoint(), setup.getServer().getSchema());
        if (null == reg) {
            throw new IOException("No AAS registry at " + setup.getRegistryEndpoint().toUri());
        }
        try {
            return AasFactory.getInstance().obtainRegistry(setup.getRegistryEndpoint()).retrieveAas(identifier);
        }
        catch (Throwable t) {
            throw new IOException(t);
        }
    }

    public static List<Aas> getIipAasInstance() {
        return null != aasSupplier ? aasSupplier.get() : null;
    }

    public static Server deploy(List<Aas> aas, String ... options) {
        DeploymentRecipe.ImmediateDeploymentRecipe dBuilder = AasFactory.getInstance().createDeploymentRecipe(setup.getServerEndpoint()).addInMemoryRegistry(setup.getRegistry().getPath());
        for (Aas a : aas) {
            dBuilder.deploy(a);
        }
        return dBuilder.createServer(options);
    }

    public static Server register(List<Aas> aas, Endpoint registry, String ... options) throws IOException {
        DeploymentRecipe.RegistryDeploymentRecipe dBuilder = AasFactory.getInstance().createDeploymentRecipe(setup.getServerEndpoint(), setup.getServer().getKeystoreDescriptor()).setRegistryUrl(registry);
        Registry reg = dBuilder.obtainRegistry();
        for (Aas a : aas) {
            for (Submodel s : a.submodels()) {
                reg.register(a, s, null);
            }
        }
        return dBuilder.createServer(options);
    }

    public static void remoteDeploy(List<Aas> aas) throws IOException {
        AasPartRegistry.remoteDeploy(setup, aas);
    }

    public static void remoteDeploy(AasSetup setup, List<Aas> aas) throws IOException {
        Endpoint aasEndpoint = setup.getServerEndpoint();
        DeploymentRecipe.RegistryDeploymentRecipe regD = AasFactory.getInstance().createDeploymentRecipe(aasEndpoint, setup.getServer().getKeystoreDescriptor()).setRegistryUrl(setup.getRegistryEndpoint());
        Registry reg = regD.obtainRegistry();
        for (Aas a : aas) {
            try {
                reg.createAas(a, aasEndpoint.toServerUri());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            for (Submodel s : a.submodels()) {
                try {
                    reg.createSubmodel(a, s);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
    }

    public static Aas getAas(List<Aas> list, String idShort) {
        return list.stream().filter(a -> a.getIdShort().equals(idShort)).findFirst().orElse(null);
    }

    public static class AasBuildResult {
        private List<Aas> aas;
        private ProtocolServerBuilder sBuilder;
        private Server protocolServer;

        private AasBuildResult(List<Aas> aas, ProtocolServerBuilder sBuilder, Server protocolServer) {
            this.aas = aas;
            this.sBuilder = sBuilder;
            this.protocolServer = protocolServer;
        }

        public List<Aas> getAas() {
            return this.aas;
        }

        public ProtocolServerBuilder getProtocolServerBuilder() {
            return this.sBuilder;
        }

        public Server getProtocolServer() {
            return this.protocolServer;
        }
    }

    public static class AasSetup {
        private EndpointHolder server = new EndpointHolder(DEFAULT_SCHEMA, "localhost", 8080, "");
        private EndpointHolder registry = new EndpointHolder(DEFAULT_SCHEMA, "localhost", 8081, "registry");
        private ProtocolAddressHolder implementation = new ProtocolAddressHolder(Schema.IGNORE, "localhost", 9000, "");
        private String serverHost = "-";
        private AasMode mode = AasMode.REMOTE_DEPLOY;

        public AasSetup() {
        }

        public AasSetup(AasSetup setup) {
            this.server = setup.server;
            this.registry = setup.registry;
            this.implementation = setup.implementation;
            this.mode = setup.mode;
        }

        @JsonIgnore
        public Endpoint getServerEndpoint() {
            return this.server.getEndpoint();
        }

        @JsonIgnore
        public Endpoint getRegistryEndpoint() {
            return this.registry.getEndpoint();
        }

        @JsonIgnore
        public ServerAddress getImplementationServer() {
            return this.implementation.getServerAddress();
        }

        @JsonIgnore
        public String getImplementationProtocol() {
            return this.implementation.getProtocol();
        }

        public EndpointHolder getServer() {
            return this.server;
        }

        public void setServer(EndpointHolder aas) {
            this.server = aas;
        }

        public EndpointHolder getRegistry() {
            return this.registry;
        }

        public AasMode getMode() {
            return this.mode;
        }

        public void setMode(AasMode mode) {
            this.mode = mode;
        }

        public String getServerHost() {
            return this.serverHost;
        }

        public Endpoint adaptEndpoint(Endpoint endpoint) {
            Endpoint result = AasPartRegistry.NO_SPECIFIC_SERVER_HOST.equals(this.serverHost) ? endpoint : new Endpoint(endpoint.getSchema(), this.serverHost, endpoint.getPort(), endpoint.getEndpoint());
            return result;
        }

        public void setServerHost(String serverHost) {
            this.serverHost = serverHost;
        }

        public void setRegistry(EndpointHolder registry) {
            this.registry = registry;
        }

        public ProtocolAddressHolder getImplementation() {
            return this.implementation;
        }

        public void setImplementation(ProtocolAddressHolder implementation) {
            this.implementation = implementation;
        }

        @JsonIgnore
        public static AasSetup createLocalEphemeralSetup() {
            return AasSetup.createLocalEphemeralSetup(null, true);
        }

        @JsonIgnore
        public static AasSetup createLocalEphemeralSetup(AasSetup setup, boolean regPortSame) {
            return AasSetup.createLocalEphemeralSetup(setup, regPortSame, () -> new AasSetup());
        }

        @JsonIgnore
        public static <A extends AasSetup> A createLocalEphemeralSetup(A setup, boolean regPortSame, Supplier<A> supplier) {
            Object result = setup;
            if (null == result) {
                result = (AasSetup)supplier.get();
            }
            result.getServer().setHost(AasPartRegistry.DEFAULT_HOST);
            result.getServer().setPort(NetUtils.getEphemeralPort());
            result.getRegistry().setHost(AasPartRegistry.DEFAULT_HOST);
            result.getRegistry().setPort(regPortSame ? result.getServer().getPort() : NetUtils.getEphemeralPort());
            result.getImplementation().setHost(AasPartRegistry.DEFAULT_HOST);
            result.getImplementation().setPort(NetUtils.getEphemeralPort());
            return result;
        }
    }

    public static enum AasMode {
        REMOTE_DEPLOY,
        REGISTER;

    }
}

