/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.support.net;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.net.UriResolver;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Test;

public class UriResolverTest {
    private static final String TEST_TEXT = "TEST!";

    @Test
    public void testUriResolution() throws IOException, URISyntaxException {
        File f = new File("target/resolutionTest.txt");
        FileUtils.copyFile((File)new File("src/test/resolutionTest.txt"), (File)f);
        File resolved = UriResolver.resolveToFile((URI)f.toURI(), null);
        Assert.assertNotNull((Object)resolved);
        Assert.assertTrue((boolean)resolved.exists());
        Assert.assertTrue((boolean)resolved.isFile());
        Assert.assertEquals((long)f.length(), (long)resolved.length());
        FileUtils.deleteQuietly((File)resolved);
        ServerAddress addr = new ServerAddress(Schema.HTTP);
        HttpServer server = HttpServer.create(new InetSocketAddress(addr.getPort()), 0);
        server.createContext("/test", new MyHandler());
        server.setExecutor(null);
        server.start();
        URI uri = new URI("http://localhost:" + addr.getPort() + "/test/resolutionTest1.txt");
        try {
            resolved = UriResolver.resolveToFile((URI)uri, null);
            Assert.fail((String)"no exception");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        File dir = Files.createTempDirectory("iip", new FileAttribute[0]).toFile();
        uri = new URI("http://localhost:" + addr.getPort() + "/test/resolutionTest.txt");
        resolved = UriResolver.resolveToFile((URI)uri, (File)dir);
        Assert.assertNotNull((Object)resolved);
        Assert.assertTrue((boolean)resolved.exists());
        Assert.assertTrue((boolean)resolved.isFile());
        Assert.assertEquals((long)TEST_TEXT.length(), (long)resolved.length());
        FileUtils.deleteQuietly((File)dir);
        resolved = UriResolver.resolveToFile((URI)uri, null);
        Assert.assertNotNull((Object)resolved);
        Assert.assertTrue((boolean)resolved.exists());
        Assert.assertTrue((boolean)resolved.isFile());
        Assert.assertEquals((long)TEST_TEXT.length(), (long)resolved.length());
        FileUtils.deleteQuietly((File)resolved);
        server.stop(0);
    }

    static class MyHandler
    implements HttpHandler {
        MyHandler() {
        }

        @Override
        public void handle(HttpExchange ex) throws IOException {
            String reqUri = ex.getRequestURI().toString();
            if (reqUri.endsWith("/resolutionTest.txt")) {
                byte[] response = UriResolverTest.TEST_TEXT.getBytes();
                ex.sendResponseHeaders(200, response.length);
                OutputStream os = ex.getResponseBody();
                os.write(response);
                os.close();
            } else {
                ex.sendResponseHeaders(404, 0L);
            }
        }
    }
}

