/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.support.net;

import de.iip_ecosphere.platform.support.NetUtils;
import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.net.LocalNetworkManagerImpl;
import de.iip_ecosphere.platform.support.net.ManagedServerAddress;
import de.iip_ecosphere.platform.support.net.NetworkManager;
import de.iip_ecosphere.platform.support.net.NetworkManagerDescriptor;
import de.iip_ecosphere.platform.support.net.NetworkManagerFactory;
import de.iip_ecosphere.platform.support.net.NetworkManagerSetup;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Test;

public class NetworkManagerTest {
    @Test
    public void testNetworkManagers() {
        NetworkManager nm = NetworkManagerFactory.getInstance();
        Assert.assertTrue((boolean)(nm instanceof LocalNetworkManagerImpl));
        NetworkManagerTest.testNetworkManager(nm, "");
        NetworkManagerSetup setup = new NetworkManagerSetup();
        setup.setLowPort(nm.getLowPort());
        setup.setHighPort(nm.getHighPort());
        NetworkManagerFactory.configure((NetworkManagerSetup)setup);
        NetworkManagerTest.testNetworkManagerSetup(nm);
        LocalNetworkManagerImpl parent = new LocalNetworkManagerImpl();
        ServerAddress resAdr = new ServerAddress(Schema.IGNORE, "me.here", 1223);
        parent.reservePort("reserved", resAdr);
        LocalNetworkManagerImpl mgr = new LocalNetworkManagerImpl((NetworkManager)parent);
        ManagedServerAddress adr = mgr.getPort("reserved");
        Assert.assertNotNull((Object)adr);
        Assert.assertEquals((Object)resAdr.getSchema(), (Object)adr.getSchema());
        Assert.assertEquals((Object)resAdr.getHost(), (Object)adr.getHost());
        Assert.assertEquals((long)resAdr.getPort(), (long)adr.getPort());
        NetworkManagerTest.testNetworkManagerSetup((NetworkManager)mgr);
        NetworkManagerTest.testNetworkManager((NetworkManager)mgr, "");
    }

    private static void testNetworkManagerSetup(NetworkManager manager) {
        Assert.assertTrue((manager.getLowPort() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((manager.getHighPort() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((manager.getLowPort() < manager.getHighPort() ? 1 : 0) != 0);
        int low = manager.getLowPort();
        int high = manager.getHighPort();
        NetworkManagerSetup setup = new NetworkManagerSetup();
        setup.setLowPort(1);
        setup.setHighPort(10);
        manager.configure(setup);
        Assert.assertEquals((long)1L, (long)manager.getLowPort());
        Assert.assertEquals((long)10L, (long)manager.getHighPort());
        setup.setLowPort(low);
        setup.setHighPort(high);
        manager.configure(setup);
        Assert.assertTrue((manager.getLowPort() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((manager.getHighPort() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((manager.getLowPort() < manager.getHighPort() ? 1 : 0) != 0);
    }

    public static void testNetworkManager(NetworkManager manager, String suffix) {
        Assert.assertTrue((manager.getLowPort() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((manager.getHighPort() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((manager.getLowPort() < manager.getHighPort() ? 1 : 0) != 0);
        int port = NetUtils.getEphemeralPort();
        while (port < manager.getLowPort() || port > manager.getHighPort()) {
            port = NetUtils.getEphemeralPort();
        }
        ServerAddress adr = new ServerAddress(Schema.IGNORE, "localhost", port);
        Assert.assertFalse((boolean)manager.isInUse(port));
        Assert.assertFalse((boolean)manager.isInUse(adr));
        try {
            manager.obtainPort(null);
            Assert.fail((String)"No exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            manager.getPort(null);
            Assert.fail((String)"No exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            manager.releasePort(null);
            Assert.fail((String)"No exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        String key1 = "key1";
        String key2 = "key2";
        Assert.assertNull((Object)manager.getPort("key1"));
        ManagedServerAddress adr1 = manager.obtainPort("key1");
        Assert.assertTrue((boolean)adr1.isNew());
        Assert.assertTrue((adr1.getPort() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((adr1.getHost().length() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)manager.isInUse(adr1.getPort()));
        Assert.assertTrue((boolean)manager.isInUse((ServerAddress)adr1));
        ManagedServerAddress g1 = manager.getPort("key1");
        Assert.assertNotNull((Object)g1);
        Assert.assertEquals((long)adr1.getPort(), (long)g1.getPort());
        Assert.assertEquals((Object)adr1.getHost(), (Object)g1.getHost());
        Assert.assertFalse((boolean)g1.isNew());
        ManagedServerAddress re1 = manager.obtainPort("key1");
        Assert.assertFalse((boolean)re1.isNew());
        Assert.assertEquals((long)adr1.getPort(), (long)re1.getPort());
        Assert.assertEquals((Object)adr1.getHost(), (Object)re1.getHost());
        Assert.assertTrue((boolean)manager.isInUse(re1.getPort()));
        Assert.assertTrue((boolean)manager.isInUse((ServerAddress)re1));
        ManagedServerAddress adr2 = manager.obtainPort("key2");
        Assert.assertTrue((boolean)adr1.isNew());
        Assert.assertTrue((adr2.getPort() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((adr2.getHost().length() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((adr1.getPort() != adr2.getPort() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)manager.isInUse(adr2.getPort()));
        Assert.assertTrue((boolean)manager.isInUse((ServerAddress)adr2));
        ManagedServerAddress re2 = manager.obtainPort("key2");
        Assert.assertFalse((boolean)re2.isNew());
        Assert.assertEquals((long)adr2.getPort(), (long)re2.getPort());
        Assert.assertEquals((Object)adr2.getHost(), (Object)re2.getHost());
        Assert.assertTrue((boolean)manager.isInUse(re2.getPort()));
        Assert.assertTrue((boolean)manager.isInUse((ServerAddress)re2));
        NetworkManagerTest.assertInstances(manager);
        manager.releasePort("key1");
        Assert.assertFalse((boolean)manager.isInUse((ServerAddress)adr1));
        Assert.assertTrue((boolean)manager.isInUse((ServerAddress)adr2));
        manager.releasePort("key2");
        Assert.assertFalse((boolean)manager.isInUse((ServerAddress)adr1));
        Assert.assertFalse((boolean)manager.isInUse((ServerAddress)adr2));
        NetworkManagerTest.testPortReservation(manager, suffix);
        NetworkManagerTest.testPrefixes(manager, suffix);
    }

    private static void assertInstances(NetworkManager manager) {
        String key1 = "key1";
        String key2 = "key2";
        String hostId0 = "HOST0";
        String hostId1 = "HOST1";
        String hostId2 = "HOST2";
        Assert.assertEquals((long)0L, (long)manager.getRegisteredInstances("key2"));
        Assert.assertEquals((long)0L, (long)manager.getRegisteredInstances("key1"));
        manager.registerInstance("key2", "HOST1");
        manager.registerInstance("key2", "HOST2");
        manager.registerInstance("key2", "HOST1");
        manager.registerInstance("key1", "HOST1");
        Assert.assertEquals((long)3L, (long)manager.getRegisteredInstances("key2"));
        Assert.assertEquals((long)1L, (long)manager.getRegisteredInstances("key1"));
        manager.unregisterInstance("key1", "HOST1");
        Assert.assertEquals((long)0L, (long)manager.getRegisteredInstances("key1"));
        manager.unregisterInstance("key2", "HOST0");
        Assert.assertEquals((long)3L, (long)manager.getRegisteredInstances("key2"));
        manager.unregisterInstance("key2", "HOST1");
        Assert.assertEquals((long)2L, (long)manager.getRegisteredInstances("key2"));
        manager.unregisterInstance("key2", "HOST1");
        Assert.assertEquals((long)1L, (long)manager.getRegisteredInstances("key2"));
        manager.unregisterInstance("key2", "HOST2");
        Assert.assertEquals((long)0L, (long)manager.getRegisteredInstances("key2"));
    }

    private static void testPortReservation(NetworkManager manager, String suffix) {
        String httpKey = "external-http" + suffix;
        ServerAddress addr = new ServerAddress(Schema.HTTP, "external.de", 80);
        try {
            manager.reservePort(null, null);
            Assert.fail((String)"No exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            manager.reservePort(null, addr);
            Assert.fail((String)"No exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            manager.reservePort(httpKey, null);
            Assert.fail((String)"No exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        ManagedServerAddress tmp = manager.reservePort(httpKey, addr);
        Assert.assertNotNull((Object)tmp);
        Assert.assertTrue((boolean)tmp.isNew());
        Assert.assertEquals((Object)addr.getSchema(), (Object)tmp.getSchema());
        Assert.assertEquals((Object)addr.getHost(), (Object)tmp.getHost());
        Assert.assertEquals((long)addr.getPort(), (long)tmp.getPort());
        tmp = manager.reservePort(httpKey, new ServerAddress(Schema.TCP, "here.local", 90));
        Assert.assertNotNull((Object)tmp);
        Assert.assertFalse((boolean)tmp.isNew());
        Assert.assertEquals((Object)addr.getSchema(), (Object)tmp.getSchema());
        Assert.assertEquals((Object)addr.getHost(), (Object)tmp.getHost());
        Assert.assertEquals((long)addr.getPort(), (long)tmp.getPort());
        tmp = manager.obtainPort(httpKey);
        Assert.assertNotNull((Object)tmp);
        Assert.assertFalse((boolean)tmp.isNew());
        Assert.assertEquals((Object)addr.getSchema(), (Object)tmp.getSchema());
        Assert.assertEquals((Object)addr.getHost(), (Object)tmp.getHost());
        Assert.assertEquals((long)addr.getPort(), (long)tmp.getPort());
        manager.releasePort(httpKey);
        tmp = manager.obtainPort(httpKey);
        Assert.assertNotNull((Object)tmp);
        Assert.assertTrue((boolean)tmp.isNew());
        Assert.assertNotEquals((Object)addr.getSchema(), (Object)tmp.getSchema());
    }

    @Test
    public void testStoreLoad() throws IOException {
        LocalNetworkManagerImpl mgr = new LocalNetworkManagerImpl();
        mgr.reserveGlobalPort("key", new ServerAddress(Schema.HTTP, 1232));
        File f = new File(FileUtils.getTempDirectory(), "mgrTestLoadStore.ser");
        ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(f));
        mgr.writeTo(oos);
        oos.close();
        LocalNetworkManagerImpl mgr2 = new LocalNetworkManagerImpl();
        ObjectInputStream ois = new ObjectInputStream(new FileInputStream(f));
        mgr2.readFrom(ois);
        ois.close();
        ManagedServerAddress adr = mgr2.getPort("key");
        Assert.assertNotNull((Object)adr);
        Assert.assertEquals((long)1232L, (long)adr.getPort());
    }

    private static void testPrefixes(NetworkManager manager, String suffix) {
        ServerAddress addr = new ServerAddress(Schema.TCP, "here.local", 90);
        manager.reservePort("a.b.", addr);
        ManagedServerAddress res = manager.getPort("a.b.c");
        Assert.assertNotNull((Object)res);
        Assert.assertEquals((Object)addr.getSchema(), (Object)res.getSchema());
        Assert.assertEquals((Object)addr.getHost(), (Object)res.getHost());
        Assert.assertEquals((long)addr.getPort(), (long)res.getPort());
        manager.releasePort("a.b.");
        Assert.assertNull((Object)manager.getPort("a.b.c"));
        Assert.assertNull((Object)manager.getPort("a.b.c.d"));
        ManagedServerAddress addr1 = manager.obtainPort("a.");
        Assert.assertNotNull((Object)addr1);
        Assert.assertTrue((boolean)addr1.isNew());
        res = manager.getPort("a.b.c");
        Assert.assertNotNull((Object)res);
        Assert.assertEquals((Object)addr1.getSchema(), (Object)res.getSchema());
        Assert.assertEquals((Object)addr1.getHost(), (Object)res.getHost());
        Assert.assertEquals((long)addr1.getPort(), (long)res.getPort());
        manager.releasePort("a.");
        Assert.assertNull((Object)manager.getPort("a.b.c"));
        Assert.assertNull((Object)manager.getPort("a.b.c.d"));
    }

    @Test
    public void testNetMgrSetup() {
        NetworkManagerSetup setup = new NetworkManagerSetup();
        setup.setLowPort(1);
        setup.setHighPort(10);
        Assert.assertEquals((long)1L, (long)setup.getLowPort());
        Assert.assertEquals((long)10L, (long)setup.getHighPort());
    }

    @Test
    public void testNetMgrLoadFromProperty() {
        String prop = System.getProperty("iip.networkManager");
        Optional tmp = NetworkManagerFactory.loadFromProperty();
        Assert.assertNotNull((Object)tmp);
        System.setProperty("iip.networkManager", Object.class.getName());
        tmp = NetworkManagerFactory.loadFromProperty();
        Assert.assertNotNull((Object)tmp);
        Assert.assertTrue((boolean)tmp.isEmpty());
        System.setProperty("iip.networkManager", MyDescriptor.class.getName());
        tmp = NetworkManagerFactory.loadFromProperty();
        Assert.assertNotNull((Object)tmp);
        Assert.assertFalse((boolean)tmp.isEmpty());
        Assert.assertTrue((boolean)tmp.isPresent());
        Assert.assertTrue((boolean)(tmp.get() instanceof MyDescriptor));
        System.setProperty("iip.networkManager", prop == null ? "" : prop);
    }

    public static class MyDescriptor
    implements NetworkManagerDescriptor {
        public NetworkManager createInstance() {
            return null;
        }
    }
}

