/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.support.metrics;

import de.iip_ecosphere.platform.support.metrics.DefaultSystemMetricsDescriptor;
import de.iip_ecosphere.platform.support.metrics.LinuxSystemMetricsUtils;
import de.iip_ecosphere.platform.support.metrics.SystemMetrics;
import java.io.File;
import org.apache.commons.lang.SystemUtils;
import org.junit.Assert;
import org.junit.Test;

public class MetricsTests {
    @Test
    public void testDefaultSystemMetrics() {
        DefaultSystemMetricsDescriptor desc = new DefaultSystemMetricsDescriptor();
        Assert.assertFalse((boolean)desc.isEnabled());
        Assert.assertTrue((boolean)desc.isFallback());
        SystemMetrics inst = desc.createInstance();
        Assert.assertNotNull((Object)inst);
        Assert.assertEquals((double)-274.0, (double)inst.getCaseTemperature(), (double)0.01);
        Assert.assertEquals((double)-274.0, (double)inst.getCpuTemperature(), (double)0.01);
        Assert.assertTrue((null != inst.getOsArch() && inst.getOsArch().length() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((null != inst.getOsName() && inst.getOsName().length() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((inst.getNumCpuCores() > 0 ? 1 : 0) != 0);
        inst.getNumGpuCores();
        inst.getNumTpuCores();
    }

    @Test
    public void testLinuxSystemMetricsUtils() {
        String old = LinuxSystemMetricsUtils.setThermalFolder((String)"./src/test/resources/metrics/sys/thermal");
        Assert.assertNotNull((Object)old);
        File tempFile = LinuxSystemMetricsUtils.getSysTempFile(null, (String)"x86");
        Assert.assertNotNull((Object)tempFile);
        File tempFile2 = LinuxSystemMetricsUtils.getSysTempFile((File)tempFile, (String)"x86");
        Assert.assertEquals((Object)tempFile2, (Object)tempFile);
        Assert.assertTrue((LinuxSystemMetricsUtils.getSysTemp((File)tempFile) > 10.0f ? 1 : 0) != 0);
        Assert.assertTrue((LinuxSystemMetricsUtils.getSysTemp((File)tempFile) < 100.0f ? 1 : 0) != 0);
        String[] args = SystemUtils.IS_OS_WINDOWS ? new String[]{"cmd.exe", "/c", "dir"} : new String[]{"ls"};
        String res = LinuxSystemMetricsUtils.readStdoutFromProgram((String)"***", (String[])args);
        Assert.assertNotNull((Object)res);
        Assert.assertTrue((!res.equals("***") ? 1 : 0) != 0);
        Assert.assertEquals((long)-1L, (long)LinuxSystemMetricsUtils.readIntStdoutFromProgram((int)-1, (String[])args));
        Assert.assertEquals((long)1234L, (long)LinuxSystemMetricsUtils.readIntStdoutFromProgram((int)-1, s -> "1234", (String[])args));
        LinuxSystemMetricsUtils.setThermalFolder((String)old);
    }
}

