/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.support.identities;

import de.iip_ecosphere.platform.support.identities.IdentityToken;
import de.iip_ecosphere.platform.support.identities.YamlIdentityFile;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.junit.Assert;
import org.junit.Test;

public class YamlIdentityFileTest {
    @Test
    public void testIdentityFile() throws IOException {
        YamlIdentityFile file = YamlIdentityFile.load(null);
        Assert.assertNotNull((Object)file);
        FileInputStream fis = new FileInputStream("src/test/resources/identityStore.yml");
        file = YamlIdentityFile.load((InputStream)fis);
        Assert.assertNotNull((Object)file);
        YamlIdentityFile.IdentityInformation info = file.getData("axc3151-1");
        Assert.assertNull((Object)info);
        info = file.getData("axc3151-2");
        Assert.assertNotNull((Object)info);
        Assert.assertEquals((Object)IdentityToken.TokenType.USERNAME, (Object)info.getType());
        Assert.assertEquals((Object)"abba", (Object)info.getUserName());
        Assert.assertEquals((Object)"babbab", (Object)info.getTokenData());
        Assert.assertNotNull((Object)info.getTokenDataAsBytes());
        Assert.assertEquals((Object)"UTF-8", (Object)info.getTokenEncryptionAlgorithm());
        info = file.getData("aas");
        Assert.assertEquals((Object)IdentityToken.TokenType.ANONYMOUS, (Object)info.getType());
        info = file.getData("secureStore");
        Assert.assertEquals((Object)IdentityToken.TokenType.X509, (Object)info.getType());
        Assert.assertEquals((Object)"polId", (Object)info.getTokenPolicyId());
        Assert.assertEquals((Object)"mySigAlg", (Object)info.getSignatureAlgorithm());
        Assert.assertEquals((Object)"sig-1", (Object)info.getSignature());
        Assert.assertNotNull((Object)info.getSignatureAsBytes());
        Assert.assertEquals((Object)"token-1", (Object)info.getTokenData());
        info = file.getData("UI");
        Assert.assertEquals((Object)IdentityToken.TokenType.ISSUED, (Object)info.getType());
        Assert.assertEquals((Object)"polId-2", (Object)info.getTokenPolicyId());
        Assert.assertEquals((Object)"yourSigAlg", (Object)info.getSignatureAlgorithm());
        Assert.assertEquals((Object)"sig-2", (Object)info.getSignature());
        Assert.assertNotNull((Object)info.getSignatureAsBytes());
        Assert.assertEquals((Object)"token", (Object)info.getTokenData());
        Assert.assertEquals((Object)"bla", (Object)info.getTokenEncryptionAlgorithm());
        info = file.getData("keystore");
        Assert.assertNotNull((Object)info);
        Assert.assertEquals((Object)IdentityToken.TokenType.USERNAME, (Object)info.getType());
        Assert.assertEquals((Object)"a1234567", (Object)info.getTokenData());
        Assert.assertNotNull((Object)info.getTokenDataAsBytes());
        Assert.assertEquals((Object)"UTF-8", (Object)info.getTokenEncryptionAlgorithm());
        Assert.assertEquals((Object)"keystore.jks", (Object)info.getFile());
    }
}

