/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.support.identities;

import de.iip_ecosphere.platform.support.identities.IdentityStore;
import de.iip_ecosphere.platform.support.identities.IdentityToken;
import de.iip_ecosphere.platform.support.identities.YamlIdentityStore;
import java.io.IOException;
import java.security.KeyStore;
import org.junit.Assert;
import org.junit.Test;

public class IdentityStoreTest {
    @Test
    public void testIdentityStore() {
        IdentityStore store = IdentityStore.getInstance();
        Assert.assertNotNull((Object)store);
        if (!(store instanceof YamlIdentityStore)) {
            store = new YamlIdentityStore();
        }
        Assert.assertNull((Object)store.getToken("xxx", new String[0]));
        Assert.assertEquals((Object)IdentityToken.TokenType.ANONYMOUS, (Object)store.getToken("xxx", true, new String[0]).getType());
        Assert.assertEquals((Object)IdentityToken.TokenType.ANONYMOUS, (Object)store.getToken("aas", false, new String[0]).getType());
        Assert.assertEquals((Object)IdentityToken.TokenType.X509, (Object)store.getToken("secureStore", false, new String[0]).getType());
        Assert.assertEquals((Object)IdentityToken.TokenType.USERNAME, (Object)store.getToken("axc3151-2", false, new String[0]).getType());
        Assert.assertEquals((Object)IdentityToken.TokenType.ISSUED, (Object)store.getToken("UI", false, new String[0]).getType());
        Assert.assertEquals((Object)IdentityToken.TokenType.USERNAME, (Object)store.getToken("myEdge", false, new String[]{"plcEdges", "axc3151-2"}).getType());
        try {
            KeyStore ks = store.getKeystoreFile("keystore", new String[0]);
            Assert.assertNotNull((Object)ks);
        }
        catch (IOException e) {
            Assert.fail((String)"No exception shall occur here");
        }
    }
}

