/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.support.fakeAas;

import de.iip_ecosphere.platform.support.Builder;
import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.AasVisitor;
import de.iip_ecosphere.platform.support.aas.DataElement;
import de.iip_ecosphere.platform.support.aas.DeferredBuilder;
import de.iip_ecosphere.platform.support.aas.FileDataElement;
import de.iip_ecosphere.platform.support.aas.Operation;
import de.iip_ecosphere.platform.support.aas.Property;
import de.iip_ecosphere.platform.support.aas.Reference;
import de.iip_ecosphere.platform.support.aas.ReferenceElement;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.aas.SubmodelElement;
import de.iip_ecosphere.platform.support.aas.SubmodelElementCollection;
import de.iip_ecosphere.platform.support.aas.SubmodelElementContainerBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import test.de.iip_ecosphere.platform.support.fakeAas.FakeAas;
import test.de.iip_ecosphere.platform.support.fakeAas.FakeElement;
import test.de.iip_ecosphere.platform.support.fakeAas.FakeFileDataElement;
import test.de.iip_ecosphere.platform.support.fakeAas.FakeOperation;
import test.de.iip_ecosphere.platform.support.fakeAas.FakeProperty;
import test.de.iip_ecosphere.platform.support.fakeAas.FakeReference;
import test.de.iip_ecosphere.platform.support.fakeAas.FakeReferenceElement;
import test.de.iip_ecosphere.platform.support.fakeAas.FakeSubmodelElementCollection;
import test.de.iip_ecosphere.platform.support.fakeAas.FakeSubmodelElementContainerBuilder;

public class FakeSubmodel
extends FakeElement
implements Submodel {
    private FakeAas parent;
    private Map<String, SubmodelElement> elements = new HashMap<String, SubmodelElement>();
    private Map<String, Builder<?>> deferred;
    private String identifier;

    protected FakeSubmodel(String idShort, String identifier) {
        super(idShort);
        this.identifier = identifier;
    }

    public void accept(AasVisitor visitor) {
        visitor.visitSubmodel((Submodel)this);
        for (SubmodelElement elt : this.elements.values()) {
            elt.accept(visitor);
        }
        visitor.endSubmodel((Submodel)this);
    }

    public Iterable<SubmodelElement> submodelElements() {
        return this.elements.values();
    }

    public int getSubmodelElementsCount() {
        return this.elements.size();
    }

    private <T extends SubmodelElement> List<T> filter(Class<T> type) {
        ArrayList<SubmodelElement> result = new ArrayList<SubmodelElement>();
        for (SubmodelElement sm : this.submodelElements()) {
            if (!type.isInstance(sm)) continue;
            result.add((SubmodelElement)type.cast(sm));
        }
        return result;
    }

    private <T extends SubmodelElement> T filter(String idShort, Class<T> type) {
        SubmodelElement result = null;
        for (SubmodelElement sm : this.submodelElements()) {
            if (!sm.getIdShort().equals(idShort) || !type.isInstance(sm)) continue;
            result = (SubmodelElement)type.cast(sm);
        }
        return (T)result;
    }

    public Iterable<DataElement> dataElements() {
        return this.filter(DataElement.class);
    }

    public Iterable<Property> properties() {
        return this.filter(Property.class);
    }

    public int getDataElementsCount() {
        return this.filter(DataElement.class).size();
    }

    public Iterable<Operation> operations() {
        return this.filter(Operation.class);
    }

    public int getOperationsCount() {
        return this.filter(Operation.class).size();
    }

    public int getPropertiesCount() {
        return this.filter(Property.class).size();
    }

    public DataElement getDataElement(String idShort) {
        return null;
    }

    public Property getProperty(String idShort) {
        return this.filter(idShort, Property.class);
    }

    public ReferenceElement getReferenceElement(String idShort) {
        return this.filter(idShort, ReferenceElement.class);
    }

    public Operation getOperation(String idShort) {
        return this.filter(idShort, Operation.class);
    }

    public SubmodelElement getSubmodelElement(String idShort) {
        return this.filter(idShort, SubmodelElement.class);
    }

    public SubmodelElementCollection getSubmodelElementCollection(String idShort) {
        return this.filter(idShort, SubmodelElementCollection.class);
    }

    public SubmodelElementCollection.SubmodelElementCollectionBuilder createSubmodelElementCollectionBuilder(String idShort, boolean ordered, boolean allowDuplicates) {
        SubmodelElementCollection.SubmodelElementCollectionBuilder result = this.getDeferred(idShort, SubmodelElementCollection.SubmodelElementCollectionBuilder.class);
        if (null == result) {
            FakeSubmodelBuilder secb = new FakeSubmodelBuilder(new FakeAas.FakeAasBuilder(this.parent), this);
            result = new FakeSubmodelElementCollection.FakeSubmodelElementCollectionBuilder(secb, idShort, ordered, allowDuplicates);
        }
        return result;
    }

    public Reference createReference() {
        return new FakeReference();
    }

    public void deleteElement(String idShort) {
        this.elements.remove(idShort);
    }

    void defer(String shortId, Builder<?> builder) {
        this.deferred = DeferredBuilder.defer((String)shortId, builder, this.deferred);
    }

    public void buildDeferred() {
        DeferredBuilder.buildDeferred(this.deferred);
    }

    <B extends Builder<?>> B getDeferred(String shortId, Class<B> cls) {
        return (B)DeferredBuilder.getDeferred((String)shortId, cls, this.deferred);
    }

    public String getIdentification() {
        return this.identifier;
    }

    public boolean create(Consumer<SubmodelElementContainerBuilder> func, boolean propagate, String ... path) {
        return false;
    }

    public <T extends SubmodelElement> boolean iterate(Submodel.IteratorFunction<T> func, Class<T> cls, String ... path) {
        return false;
    }

    protected static class FakeSubmodelBuilder
    extends FakeSubmodelElementContainerBuilder
    implements Submodel.SubmodelBuilder {
        private FakeAas.FakeAasBuilder parent;
        private FakeSubmodel instance;
        private boolean isNew = true;

        protected FakeSubmodelBuilder(FakeAas.FakeAasBuilder parent, String idShort) {
            this(parent, idShort, null);
        }

        FakeSubmodelBuilder(FakeAas.FakeAasBuilder parent, String idShort, String identifier) {
            this.parent = parent;
            this.instance = this.createInstance(idShort, identifier);
            this.instance.parent = null != parent ? parent.getInstance() : null;
        }

        public FakeSubmodelBuilder(FakeAas.FakeAasBuilder parent, FakeSubmodel instance) {
            this.parent = parent;
            this.instance = instance;
            this.isNew = false;
        }

        protected FakeSubmodel createInstance(String idShort, String identifier) {
            return new FakeSubmodel(idShort, identifier);
        }

        public SubmodelElementCollection.SubmodelElementCollectionBuilder createSubmodelElementCollectionBuilder(String idShort, boolean ordered, boolean allowDuplicates) {
            SubmodelElementCollection.SubmodelElementCollectionBuilder result = this.instance.getDeferred(idShort, SubmodelElementCollection.SubmodelElementCollectionBuilder.class);
            if (null == result) {
                result = new FakeSubmodelElementCollection.FakeSubmodelElementCollectionBuilder(this, idShort, ordered, allowDuplicates);
            }
            return result;
        }

        public Reference createReference() {
            return new FakeReference();
        }

        public void defer() {
            this.parent.defer(this.instance.getIdShort(), (Builder<?>)this);
        }

        public void buildDeferred() {
            this.parent.buildMyDeferred();
        }

        public Submodel build() {
            return this.parent.register(this.instance);
        }

        @Override
        FakeFileDataElement register(FakeFileDataElement element) {
            this.instance.elements.put(element.getIdShort(), (SubmodelElement)element);
            return element;
        }

        @Override
        FakeOperation register(FakeOperation operation) {
            this.instance.elements.put(operation.getIdShort(), (SubmodelElement)operation);
            return operation;
        }

        @Override
        FakeProperty register(FakeProperty property) {
            this.instance.elements.put(property.getIdShort(), (SubmodelElement)property);
            return property;
        }

        @Override
        FakeReferenceElement register(FakeReferenceElement reference) {
            this.instance.elements.put(reference.getIdShort(), (SubmodelElement)reference);
            return reference;
        }

        @Override
        FakeSubmodelElementCollection register(FakeSubmodelElementCollection collection) {
            this.instance.elements.put(collection.getIdShort(), (SubmodelElement)collection);
            return collection;
        }

        public SubmodelElementContainerBuilder getParentBuilder() {
            return null;
        }

        public Aas.AasBuilder getAasBuilder() {
            return this.parent;
        }

        public boolean isNew() {
            return this.isNew;
        }

        public boolean hasElement(String idShort) {
            return this.instance.elements.containsKey(idShort);
        }

        @Override
        void defer(String shortId, Builder<?> builder) {
            this.instance.defer(shortId, builder);
        }

        @Override
        void buildMyDeferred() {
            this.instance.buildDeferred();
        }

        public FileDataElement.FileDataElementBuilder createFileDataElementBuilder(String idShort, String contents, String mimeType) {
            return new FakeFileDataElement.FakeFileDataElementBuilder(this, idShort, contents, mimeType);
        }
    }
}

