/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.support.fakeAas;

import de.iip_ecosphere.platform.support.aas.AasVisitor;
import de.iip_ecosphere.platform.support.aas.LangString;
import de.iip_ecosphere.platform.support.aas.Property;
import de.iip_ecosphere.platform.support.aas.SubmodelElementContainerBuilder;
import de.iip_ecosphere.platform.support.aas.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import test.de.iip_ecosphere.platform.support.fakeAas.FakeElement;
import test.de.iip_ecosphere.platform.support.fakeAas.FakeSubmodelElementContainerBuilder;

public class FakeProperty
extends FakeElement
implements Property {
    private Object value;
    private Type type;
    private String semanticId;
    private Map<String, LangString> description;

    protected FakeProperty(String idShort) {
        super(idShort);
    }

    public void accept(AasVisitor visitor) {
        visitor.visitProperty((Property)this);
    }

    public Object getValue() throws ExecutionException {
        return this.value;
    }

    public void setValue(Object value) throws ExecutionException {
        this.value = value;
    }

    public String getSemanticId(boolean stripPrefix) {
        return this.semanticId;
    }

    public Map<String, LangString> getDescription() {
        return Collections.unmodifiableMap(this.description);
    }

    static class FakePropertyBuilder
    implements Property.PropertyBuilder {
        private FakeSubmodelElementContainerBuilder parent;
        private FakeProperty instance;

        FakePropertyBuilder(FakeSubmodelElementContainerBuilder parent, String idShort) {
            this.parent = parent;
            this.instance = new FakeProperty(idShort);
        }

        public SubmodelElementContainerBuilder getParentBuilder() {
            return this.parent;
        }

        public Property.PropertyBuilder setType(Type type) {
            this.instance.type = type;
            return this;
        }

        public Property.PropertyBuilder setValue(Object value) {
            this.instance.value = value;
            return this;
        }

        public Property.PropertyBuilder setValue(Type type, Object value) {
            this.instance.type = type;
            this.instance.value = value;
            return this;
        }

        public Property.PropertyBuilder bind(Supplier<Object> get, Consumer<Object> set) {
            return this;
        }

        public Property.PropertyBuilder setSemanticId(String refValue) {
            this.instance.semanticId = refValue;
            return this;
        }

        public Property build() {
            return this.parent.register(this.instance);
        }

        public Object getValue() throws ExecutionException {
            return this.instance.getValue();
        }

        public Property.PropertyBuilder setDescription(LangString ... description) {
            if (description.length > 0) {
                this.instance.description = new HashMap<String, LangString>();
                for (LangString d : description) {
                    this.instance.description.put(d.getLanguage(), d);
                }
            } else {
                this.instance.description = null;
            }
            return this;
        }
    }
}

