/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.support.fakeAas;

import de.iip_ecosphere.platform.support.Builder;
import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.AasVisitor;
import de.iip_ecosphere.platform.support.aas.Asset;
import de.iip_ecosphere.platform.support.aas.AssetKind;
import de.iip_ecosphere.platform.support.aas.DeferredBuilder;
import de.iip_ecosphere.platform.support.aas.Reference;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.aas.types.technicaldata.TechnicalDataSubmodel;
import java.util.HashMap;
import java.util.Map;
import test.de.iip_ecosphere.platform.support.fakeAas.FakeAsset;
import test.de.iip_ecosphere.platform.support.fakeAas.FakeElement;
import test.de.iip_ecosphere.platform.support.fakeAas.FakeReference;
import test.de.iip_ecosphere.platform.support.fakeAas.FakeSubmodel;

public class FakeAas
extends FakeElement
implements Aas {
    private Map<String, Submodel> submodels = new HashMap<String, Submodel>();
    private Asset asset;
    private Map<String, Builder<?>> deferred;
    private String identifier;

    FakeAas(String idShort, String identifier) {
        super(idShort);
        this.identifier = identifier;
    }

    public void accept(AasVisitor visitor) {
        visitor.visitAas((Aas)this);
        if (null != this.asset) {
            this.asset.accept(visitor);
        }
        for (Submodel submodel : this.submodels()) {
            submodel.accept(visitor);
        }
        visitor.endAas((Aas)this);
    }

    public Iterable<? extends Submodel> submodels() {
        return this.submodels.values();
    }

    public int getSubmodelCount() {
        return this.submodels.size();
    }

    public Submodel getSubmodel(String idShort) {
        return this.submodels.get(idShort);
    }

    public Submodel.SubmodelBuilder createSubmodelBuilder(String idShort, String urn) {
        Submodel.SubmodelBuilder result = this.getDeferred(idShort, Submodel.SubmodelBuilder.class);
        if (null == result) {
            result = new FakeSubmodel.FakeSubmodelBuilder(new FakeAasBuilder(this), idShort);
        }
        return result;
    }

    public Reference createReference() {
        return new FakeReference();
    }

    void setAsset(FakeAsset asset) {
        this.asset = asset;
    }

    public Asset getAsset() {
        return this.asset;
    }

    public void delete(Submodel submodel) {
        this.submodels.remove(submodel.getIdShort());
    }

    void defer(String shortId, Builder<?> builder) {
        this.deferred = DeferredBuilder.defer((String)shortId, builder, this.deferred);
    }

    public void buildDeferred() {
        DeferredBuilder.buildDeferred(this.deferred);
    }

    <B extends Builder<?>> B getDeferred(String shortId, Class<B> cls) {
        return (B)DeferredBuilder.getDeferred((String)shortId, cls, this.deferred);
    }

    public Aas.AasBuilder createAasBuilder() {
        return new FakeAasBuilder(this);
    }

    public TechnicalDataSubmodel getTechnicalDataSubmodel() {
        return null;
    }

    public String getIdentification() {
        return this.identifier;
    }

    public static class FakeAasBuilder
    implements Aas.AasBuilder {
        private FakeAas instance;

        FakeAasBuilder(String idShort, String identifier) {
            this.instance = new FakeAas(idShort, identifier);
        }

        FakeAasBuilder(FakeAas instance) {
            this.instance = instance;
        }

        public Submodel.SubmodelBuilder createSubmodelBuilder(String idShort, String identifier) {
            Submodel.SubmodelBuilder result = this.instance.getDeferred(idShort, Submodel.SubmodelBuilder.class);
            if (null == result) {
                result = new FakeSubmodel.FakeSubmodelBuilder(this, idShort, identifier);
            }
            return result;
        }

        Submodel register(Submodel submodel) {
            this.instance.submodels.put(submodel.getIdShort(), submodel);
            return submodel;
        }

        public Aas build() {
            this.buildMyDeferred();
            return this.instance;
        }

        FakeAas getInstance() {
            return this.instance;
        }

        public Reference createReference() {
            return new FakeReference();
        }

        public Asset.AssetBuilder createAssetBuilder(String idShort, String urn, AssetKind kind) {
            return new FakeAsset.FakeAssetBuilder(this, idShort, urn, kind);
        }

        void defer(String shortId, Builder<?> builder) {
            this.getInstance().defer(shortId, builder);
        }

        void buildMyDeferred() {
            this.getInstance().buildDeferred();
        }

        public TechnicalDataSubmodel.TechnicalDataSubmodelBuilder createTechnicalDataSubmodelBuilder(String identifier) {
            return null;
        }
    }
}

