/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.support.fakeAas;

import de.iip_ecosphere.platform.support.Endpoint;
import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.AasFactory;
import de.iip_ecosphere.platform.support.aas.AssetKind;
import de.iip_ecosphere.platform.support.aas.DeploymentRecipe;
import de.iip_ecosphere.platform.support.aas.InvocablesCreator;
import de.iip_ecosphere.platform.support.aas.LangString;
import de.iip_ecosphere.platform.support.aas.PersistenceRecipe;
import de.iip_ecosphere.platform.support.aas.ProtocolDescriptor;
import de.iip_ecosphere.platform.support.aas.ProtocolServerBuilder;
import de.iip_ecosphere.platform.support.aas.Registry;
import de.iip_ecosphere.platform.support.aas.ServerRecipe;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.aas.Type;
import de.iip_ecosphere.platform.support.net.KeyStoreDescriptor;
import java.io.File;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import test.de.iip_ecosphere.platform.support.fakeAas.FakeServerReceipe;

public class FactoryTest {
    public static AasFactory createDisabledFactory() {
        return new DisabledFactory();
    }

    @Test
    public void testFakeFactory() throws IOException {
        AasFactory instance = AasFactory.getInstance();
        Assert.assertNotNull((Object)instance);
        Assert.assertEquals((Object)"fake", (Object)instance.getName());
        Assert.assertNotNull((Object)instance.createAasBuilder("", ""));
        Assert.assertNotNull((Object)instance.createSubmodelBuilder("", ""));
        Endpoint ep = new Endpoint(Schema.HTTP, "", 1234, "");
        ServerRecipe serverRecipe = instance.createServerRecipe();
        Assert.assertNotNull((Object)serverRecipe);
        Endpoint regEp = new Endpoint((ServerAddress)ep, "/registry");
        Assert.assertNull((Object)serverRecipe.createRegistryServer(regEp, (ServerRecipe.PersistenceType)ServerRecipe.LocalPersistenceType.INMEMORY, new String[]{""}));
        Assert.assertNull((Object)serverRecipe.createAasServer(new Endpoint((ServerAddress)ep, "/aas"), (ServerRecipe.PersistenceType)ServerRecipe.LocalPersistenceType.INMEMORY, regEp, new String[0]));
        Assert.assertNull((Object)instance.obtainRegistry(ep));
        Assert.assertNull((Object)instance.obtainRegistry(ep, Schema.HTTPS));
        Assert.assertNull((Object)instance.createDeploymentRecipe(ep));
        Assert.assertNull((Object)instance.createPersistenceRecipe());
        Assert.assertNotNull((Object)instance.getProtocols());
        Assert.assertTrue((instance.getProtocols().length > 0 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)instance.createInvocablesCreator("", "localhost", 123));
        Assert.assertNotNull((Object)instance.createProtocolServerBuilder("", 123));
        Assert.assertEquals((Object)"id", (Object)instance.fixId("id"));
        Assert.assertEquals((Object)ServerRecipe.LocalPersistenceType.INMEMORY, (Object)serverRecipe.toPersistenceType(""));
        Assert.assertEquals((Object)ServerRecipe.LocalPersistenceType.INMEMORY, (Object)serverRecipe.toPersistenceType(ServerRecipe.LocalPersistenceType.INMEMORY.name()));
        Assert.assertTrue((instance.getFullRegistryUri(regEp).length() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((instance.getServerBaseUri(regEp).length() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testDummyFactory() throws IOException {
        AasFactory old = AasFactory.setInstance((AasFactory)FactoryTest.createDisabledFactory());
        AasFactory instance = AasFactory.getInstance();
        Assert.assertNotNull((Object)instance);
        Assert.assertEquals((Object)AasFactory.DUMMY.getName(), (Object)instance.getName());
        Assert.assertNull((Object)instance.createAasBuilder("", ""));
        Assert.assertNull((Object)instance.createSubmodelBuilder("", ""));
        Endpoint ep = new Endpoint(Schema.HTTP, "", 1234, "");
        ServerRecipe serverRecipe = instance.createServerRecipe();
        Assert.assertNotNull((Object)serverRecipe);
        Endpoint regEp = new Endpoint((ServerAddress)ep, "/registry");
        Assert.assertNull((Object)serverRecipe.createRegistryServer(regEp, (ServerRecipe.PersistenceType)ServerRecipe.LocalPersistenceType.INMEMORY, new String[]{""}));
        Assert.assertNull((Object)serverRecipe.createAasServer(new Endpoint((ServerAddress)ep, "/aas"), (ServerRecipe.PersistenceType)ServerRecipe.LocalPersistenceType.INMEMORY, regEp, new String[0]));
        FactoryTest.assertRegistry(instance.obtainRegistry(ep));
        Assert.assertNull((Object)instance.createDeploymentRecipe(ep));
        Assert.assertNull((Object)instance.createDeploymentRecipe(ep, new KeyStoreDescriptor(new File("."), "xxx", "xyz")));
        Assert.assertNull((Object)instance.createPersistenceRecipe());
        Assert.assertNotNull((Object)instance.getProtocols());
        Assert.assertTrue((instance.getProtocols().length > 0 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)instance.createInvocablesCreator("", "localhost", 123));
        Assert.assertNotNull((Object)instance.createProtocolServerBuilder("", 123));
        AasFactory.setInstance((AasFactory)old);
    }

    private static void assertRegistry(Registry reg) throws IOException {
        Assert.assertNotNull((Object)reg);
        Assert.assertNull((Object)reg.retrieveAas(""));
        reg.createAas(null, "");
        reg.createSubmodel(null, null);
        reg.register(null, null, "");
        Assert.assertNull((Object)reg.retrieveSubmodel("", ""));
    }

    @Test
    public void assertConstants() {
        for (Type type : Type.values()) {
            Assert.assertNotNull((Object)type);
        }
        for (Type type : AssetKind.values()) {
            Assert.assertNotNull((Object)type);
        }
    }

    @Test
    public void langStringTest() {
        LangString ls = new LangString("EN", "Desig");
        Assert.assertEquals((Object)LangString.formatLanguage((String)"EN"), (Object)ls.getLanguage());
        Assert.assertEquals((Object)"Desig", (Object)ls.getDescription());
        Assert.assertTrue((ls.toString().length() > 0 ? 1 : 0) != 0);
        ls.hashCode();
        LangString ls2 = new LangString("DE", "Desig");
        Assert.assertFalse((boolean)ls.equals((Object)ls2));
        LangString ls3 = new LangString("EN", "Desig");
        Assert.assertTrue((boolean)ls.equals((Object)ls3));
    }

    private static class DisabledFactory
    extends AasFactory {
        private DisabledFactory() {
        }

        public String getName() {
            return DUMMY.getName();
        }

        public Submodel.SubmodelBuilder createSubmodelBuilder(String idShort, String urn) {
            return DUMMY.createSubmodelBuilder(idShort, urn);
        }

        protected ServerRecipe createDefaultServerRecipe() {
            return new FakeServerReceipe();
        }

        public Registry obtainRegistry(Endpoint regEndpoint) throws IOException {
            return DUMMY.obtainRegistry(regEndpoint);
        }

        public Registry obtainRegistry(Endpoint regEndpoint, Schema aasSchema) throws IOException {
            return DUMMY.obtainRegistry(regEndpoint, aasSchema);
        }

        public DeploymentRecipe createDeploymentRecipe(Endpoint endpoint) {
            return DUMMY.createDeploymentRecipe(endpoint);
        }

        public DeploymentRecipe createDeploymentRecipe(Endpoint endpoint, KeyStoreDescriptor kstore) {
            return DUMMY.createDeploymentRecipe(endpoint, kstore);
        }

        public Aas.AasBuilder createAasBuilder(String idShort, String urn) {
            return DUMMY.createAasBuilder(idShort, urn);
        }

        public PersistenceRecipe createPersistenceRecipe() {
            return DUMMY.createPersistenceRecipe();
        }

        public String[] getProtocols() {
            return DUMMY.getProtocols();
        }

        public InvocablesCreator createInvocablesCreator(String protocol, String host, int port) {
            return DUMMY.createInvocablesCreator(protocol, host, port);
        }

        public ProtocolServerBuilder createProtocolServerBuilder(String protocol, int port) {
            return DUMMY.createProtocolServerBuilder(protocol, port);
        }

        public String fixId(String id) {
            return DUMMY.fixId(id);
        }

        protected boolean accept(ProtocolDescriptor creator) {
            return true;
        }

        public String getFullRegistryUri(Endpoint regEndpoint) {
            return DUMMY.getFullRegistryUri(regEndpoint);
        }

        public String getServerBaseUri(Endpoint serverEndpoint) {
            return DUMMY.getServerBaseUri(serverEndpoint);
        }
    }
}

