/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.support.aas;

import de.iip_ecosphere.platform.support.CollectionUtils;
import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.AasFactory;
import de.iip_ecosphere.platform.support.aas.FileDataElement;
import de.iip_ecosphere.platform.support.aas.LangString;
import de.iip_ecosphere.platform.support.aas.types.technicaldata.FurtherInformation;
import de.iip_ecosphere.platform.support.aas.types.technicaldata.GeneralInformation;
import de.iip_ecosphere.platform.support.aas.types.technicaldata.ProductClassificationItem;
import de.iip_ecosphere.platform.support.aas.types.technicaldata.ProductClassifications;
import de.iip_ecosphere.platform.support.aas.types.technicaldata.TechnicalDataSubmodel;
import de.iip_ecosphere.platform.support.aas.types.technicaldata.TechnicalProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.junit.Assert;
import org.junit.Test;

public abstract class TechnicalDataSubmodelTest {
    private XMLGregorianCalendar cal;
    private String manufacturerName = "manu AG";
    private String manufacturerPartNumber = "12345";
    private LangString manufacturerProductDesignation = new LangString("EN", "Desig");
    private String manufacturerOrderCode = "O12345O";
    private LangString furtherInformationStmt1 = new LangString("EN", "My Statement");
    private LangString furtherInformationStmt2 = new LangString("DE", "Mein Text");

    protected abstract String toFurtherInformationStatementId(String var1);

    protected abstract String getGeneralInformationManufacturerLogoId();

    protected abstract String toGeneralInformationProductImageFileId(String var1);

    protected abstract String toTechnicalPropertiesMainSectionId(String var1);

    protected abstract String toTechnicalPropertiesSubSectionId(String var1);

    @Test
    public void testTechnicalDataSubmodel() throws DatatypeConfigurationException {
        AasFactory factory = AasFactory.getInstance();
        Aas.AasBuilder aasBuilder = factory.createAasBuilder("MyAas", null);
        TechnicalDataSubmodel.TechnicalDataSubmodelBuilder tdSmBuilder = aasBuilder.createTechnicalDataSubmodelBuilder(null);
        TechnicalDataSubmodelTest.assertBuildFail(tdSmBuilder);
        this.createFurtherInformation(tdSmBuilder);
        TechnicalDataSubmodelTest.assertBuildFail(tdSmBuilder);
        this.createGeneralInformation(tdSmBuilder);
        TechnicalDataSubmodelTest.assertBuildFail(tdSmBuilder);
        this.createProductClassifications(tdSmBuilder);
        TechnicalDataSubmodelTest.assertBuildFail(tdSmBuilder);
        this.createTechnicalProperties(tdSmBuilder);
        tdSmBuilder.build();
        Aas aas = (Aas)aasBuilder.build();
        TechnicalDataSubmodel tsub = aas.getTechnicalDataSubmodel();
        Assert.assertNotNull((Object)tsub);
        this.assertFurtherInformation(tsub);
        this.assertGeneralInformation(tsub);
        this.assertProductClassifications(tsub);
        this.assertTechnicalProperties(tsub);
    }

    private void createFurtherInformation(TechnicalDataSubmodel.TechnicalDataSubmodelBuilder tdSmBuilder) throws DatatypeConfigurationException {
        GregorianCalendar now = new GregorianCalendar();
        this.cal = DatatypeFactory.newInstance().newXMLGregorianCalendar(now);
        FurtherInformation.FurtherInformationBuilder fiBuilder = tdSmBuilder.createFurtherInformationBuilder(this.cal);
        fiBuilder.addStatement("myId", this.furtherInformationStmt1);
        fiBuilder.build();
    }

    private void createGeneralInformation(TechnicalDataSubmodel.TechnicalDataSubmodelBuilder tdSmBuilder) {
        GeneralInformation.GeneralInformationBuilder giBuilder = tdSmBuilder.createGeneralInformationBuilder(this.manufacturerName, this.manufacturerProductDesignation, this.manufacturerPartNumber, this.manufacturerOrderCode);
        giBuilder.addProductImageFile("imgP0", "imgP0.png", "PNG");
        giBuilder.setManufacturerLogo("manuAg.png", "PNG");
        giBuilder.build();
    }

    private void createProductClassifications(TechnicalDataSubmodel.TechnicalDataSubmodelBuilder tdSmBuilder) {
        ProductClassifications.ProductClassificationsBuilder pcBuilder = tdSmBuilder.createProductClassificationsBuilder();
        pcBuilder.createProductClassificationItemBuilder("pc1", "ECLASS", "a1274858").setClassificationSystemVersion("1.2.3").build();
        pcBuilder.createProductClassificationItemBuilder("pc2", "ICS", "a-1274858").build();
        pcBuilder.build();
    }

    private void createTechnicalProperties(TechnicalDataSubmodel.TechnicalDataSubmodelBuilder tdSmBuilder) {
        TechnicalProperties.TechnicalPropertiesBuilder tpBuilder = tdSmBuilder.createTechnicalPropertiesBuilder();
        tpBuilder.createMainSectionBuilder("main1", false, false).build();
        tpBuilder.createMainSectionBuilder("main2", false, false).build();
        tpBuilder.createSubSectionBuilder("sub1", false, false).build();
        tpBuilder.createSubSectionBuilder("sub2", false, false).build();
        tpBuilder.build();
    }

    private static void assertBuildFail(TechnicalDataSubmodel.TechnicalDataSubmodelBuilder tdSmBuilder) {
        try {
            tdSmBuilder.build();
            Assert.fail((String)"No exception throwh");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void assertFurtherInformation(TechnicalDataSubmodel tsub) {
        FurtherInformation fi = tsub.getFurtherInformation();
        Assert.assertNotNull((Object)fi);
        XMLGregorianCalendar fiCal = fi.getValidDate();
        Assert.assertNotNull((Object)fiCal);
        Assert.assertEquals((Object)this.cal, (Object)fiCal);
        Map fiStmts = fi.getStatements();
        Assert.assertNotNull((Object)fiStmts);
        String myId = this.toFurtherInformationStatementId("myId");
        Assert.assertNotNull(fiStmts.get(myId));
        Assert.assertTrue((boolean)((Collection)fiStmts.get(myId)).contains(this.furtherInformationStmt1));
        fi.setValidDate(this.cal);
        HashMap stmts = new HashMap();
        ArrayList<LangString> stmts1 = new ArrayList<LangString>();
        stmts1.add(this.furtherInformationStmt1);
        stmts1.add(this.furtherInformationStmt2);
        stmts.put("myId", stmts1);
        fi.setStatements(stmts);
        fiStmts = fi.getStatements();
        Assert.assertNotNull((Object)fiStmts);
        Assert.assertNotNull(fiStmts.get(myId));
        Assert.assertTrue((boolean)((Collection)fiStmts.get(myId)).contains(this.furtherInformationStmt1));
        Assert.assertTrue((boolean)((Collection)fiStmts.get(myId)).contains(this.furtherInformationStmt2));
    }

    private void assertGeneralInformation(TechnicalDataSubmodel tsub) {
        GeneralInformation gi = tsub.getGeneralInformation();
        Assert.assertNotNull((Object)gi);
        Assert.assertEquals((Object)this.manufacturerName, (Object)gi.getManufacturerName());
        List desig = gi.getManufacturerProductDesignation();
        Assert.assertNotNull((Object)desig);
        Assert.assertTrue((desig.size() == 1 ? 1 : 0) != 0);
        TechnicalDataSubmodelTest.assertEquals(this.manufacturerProductDesignation, (LangString)desig.get(0));
        Assert.assertEquals((Object)this.manufacturerPartNumber, (Object)gi.getManufacturerPartNumber());
        Assert.assertEquals((Object)this.manufacturerOrderCode, (Object)gi.getManufacturerOrderCode());
        FileDataElement logo = gi.getManufacturerLogo();
        TechnicalDataSubmodelTest.assertEquals(this.getGeneralInformationManufacturerLogoId(), "manuAg.png", "PNG", logo);
        List files = CollectionUtils.toList(gi.getProductImages().iterator());
        Assert.assertNotNull((Object)files);
        Assert.assertTrue((files.size() == 1 ? 1 : 0) != 0);
        TechnicalDataSubmodelTest.assertEquals(this.toGeneralInformationProductImageFileId("imgP0"), "imgP0.png", "PNG", (FileDataElement)files.get(0));
    }

    private static void assertEquals(LangString expected, LangString actual) {
        Assert.assertEquals((Object)expected.getLanguage(), (Object)actual.getLanguage());
        Assert.assertEquals((Object)expected.getDescription(), (Object)actual.getDescription());
    }

    private static void assertEquals(String id, String file, String mime, FileDataElement actual) {
        if (null == id) {
            Assert.assertNull((Object)actual);
        } else {
            Assert.assertNotNull((Object)actual);
            Assert.assertEquals((Object)id, (Object)actual.getIdShort());
            Assert.assertEquals((Object)file, (Object)actual.getContents());
            Assert.assertEquals((Object)mime, (Object)actual.getMimeType());
        }
    }

    private void assertProductClassifications(TechnicalDataSubmodel tsub) {
        ProductClassifications pc = tsub.getProductClassifications();
        Assert.assertNotNull((Object)pc);
        Assert.assertEquals((long)2L, (long)pc.getProductClassificationItemsCount());
        ProductClassificationItem i = pc.getProductClassificationItem("pc1");
        Assert.assertNotNull((Object)i);
        TechnicalDataSubmodelTest.assertEquals("pc1", "ECLASS", "1.2.3", "a1274858", i);
        i = pc.getProductClassificationItem("pc2");
        Assert.assertNotNull((Object)i);
        TechnicalDataSubmodelTest.assertEquals("pc2", "ICS", null, "a-1274858", i);
    }

    private static void assertEquals(String id, String classSystem, String classSystemVer, String classId, ProductClassificationItem actual) {
        if (null == id) {
            Assert.assertNull((Object)actual);
        } else {
            Assert.assertNotNull((Object)actual);
            Assert.assertEquals((Object)id, (Object)actual.getIdShort());
            Assert.assertEquals((Object)classSystem, (Object)actual.getProductClassificationSystem());
            if (null == classSystemVer) {
                Assert.assertNull((Object)actual.getClassificationSystemVersion());
            } else {
                Assert.assertEquals((Object)classSystemVer, (Object)actual.getClassificationSystemVersion());
            }
            Assert.assertEquals((Object)classId, (Object)actual.getProductClassId());
        }
    }

    private void assertTechnicalProperties(TechnicalDataSubmodel tsub) {
        List s2;
        TechnicalProperties tp = tsub.getTechnicalProperties();
        Assert.assertNotNull((Object)tp);
        List c = CollectionUtils.toList(tp.mainSections().iterator());
        Assert.assertNotNull((Object)c);
        Assert.assertTrue((c.size() == 2 ? 1 : 0) != 0);
        Set ids = c.stream().map(x -> x.getIdShort()).collect(Collectors.toSet());
        Assert.assertTrue((boolean)ids.contains(this.toTechnicalPropertiesMainSectionId("main1")));
        Assert.assertTrue((boolean)ids.contains(this.toTechnicalPropertiesMainSectionId("main2")));
        c = CollectionUtils.toList(tp.subSections().iterator());
        Assert.assertNotNull((Object)c);
        Assert.assertTrue((c.size() == 2 ? 1 : 0) != 0);
        ids = c.stream().map(x -> x.getIdShort()).collect(Collectors.toSet());
        Assert.assertTrue((boolean)ids.contains(this.toTechnicalPropertiesSubSectionId("sub1")));
        Assert.assertTrue((boolean)ids.contains(this.toTechnicalPropertiesSubSectionId("sub2")));
        try {
            s2 = CollectionUtils.toList(tp.arbitrary().iterator());
            Assert.assertNotNull((Object)s2);
            Assert.assertTrue((boolean)s2.isEmpty());
        }
        catch (NullPointerException s2) {
            // empty catch block
        }
        try {
            s2 = CollectionUtils.toList(tp.sMENotDescribedBySemanticId().iterator());
            Assert.assertNotNull((Object)s2);
            Assert.assertTrue((boolean)s2.isEmpty());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

