/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.support.aas;

import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.AasFactory;
import de.iip_ecosphere.platform.support.aas.AssetKind;
import de.iip_ecosphere.platform.support.aas.PersistenceRecipe;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.aas.Type;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Test;

public abstract class PersistenceTest {
    @Test
    public void testWriteRead() throws IOException {
        AasFactory factory = AasFactory.getInstance();
        ArrayList<Aas> aas = new ArrayList<Aas>();
        Aas.AasBuilder aasB = factory.createAasBuilder("MyAas", "urnText:myAAs");
        aasB.createAssetBuilder("asset", "urnText:myAAsasset", AssetKind.INSTANCE).build();
        Submodel.SubmodelBuilder smB = aasB.createSubmodelBuilder("MySubModel", "urnText:myAAsMySubModel");
        smB.createPropertyBuilder("MyP").setValue(Type.BOOLEAN, (Object)true).build();
        smB.build();
        aasB.createSubmodelBuilder("MySubModel1", "urnText:myAasMySubModel1").build();
        aas.add((Aas)aasB.build());
        aasB = factory.createAasBuilder("MyAas1", "urnText:myAAs1");
        aasB.createAssetBuilder("asset1", "urnText:myAAsAsset1", AssetKind.INSTANCE);
        aas.add((Aas)aasB.build());
        aas = Collections.unmodifiableList(aas);
        PersistenceRecipe recipe = factory.createPersistenceRecipe();
        for (File f : this.filesToTest()) {
            System.out.println("Testing " + f);
            List<Aas> aasxList = this.selectedAas(f, aas);
            recipe.writeTo(aasxList, f);
            PersistenceTest.assertAas(recipe.readFrom(f), this.assertOnlyFirst(f), this.assertAsset(f));
            f.delete();
        }
    }

    protected abstract File[] filesToTest();

    protected abstract List<Aas> selectedAas(File var1, List<Aas> var2);

    protected abstract boolean assertOnlyFirst(File var1);

    protected abstract boolean assertAsset(File var1);

    protected static File obtainTmpFile(String name) {
        File file = new File(FileUtils.getTempDirectory(), name);
        file.delete();
        return file;
    }

    private static void assertAas(List<Aas> aasIn, boolean justFirst, boolean testAsset) {
        Assert.assertEquals((long)(justFirst ? 1L : 2L), (long)aasIn.size());
        Aas aas = aasIn.get(0);
        Assert.assertEquals((Object)"MyAas", (Object)aas.getIdShort());
        Assert.assertEquals((long)2L, (long)aas.getSubmodelCount());
        Assert.assertNotNull((Object)aas.getSubmodel("MySubModel"));
        Assert.assertNotNull((Object)aas.getSubmodel("MySubModel").getProperty("MyP"));
        Assert.assertNotNull((Object)aas.getSubmodel("MySubModel1"));
        if (testAsset) {
            Assert.assertNotNull((Object)aas.getAsset());
            Assert.assertEquals((Object)AssetKind.INSTANCE, (Object)aas.getAsset().getAssetKind());
        }
        if (!justFirst) {
            Assert.assertEquals((Object)"MyAas1", (Object)aasIn.get(1).getIdShort());
        }
    }
}

