/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.support.aas;

import de.iip_ecosphere.platform.support.aas.AasFactory;
import de.iip_ecosphere.platform.support.aas.InvocablesCreator;
import de.iip_ecosphere.platform.support.aas.LocalInvocablesCreator;
import de.iip_ecosphere.platform.support.aas.LocalProtocolServerBuilder;
import de.iip_ecosphere.platform.support.aas.OperationsProvider;
import de.iip_ecosphere.platform.support.aas.ProtocolServerBuilder;
import de.iip_ecosphere.platform.support.aas.SerialPayloadCodec;
import de.iip_ecosphere.platform.support.aas.SimpleOperationsProvider;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.junit.Assert;
import org.junit.Test;

public class LocalInvocationTest {
    private int propVal = 0;

    @Test
    public void testSerialPayloadCodec() {
        SerialPayloadCodec codec = new SerialPayloadCodec();
        final AtomicBoolean decoded = new AtomicBoolean(false);
        String info = "info";
        final byte[] payload = "PAYLOAD".getBytes();
        byte[] data = codec.encode("info", payload);
        codec.decode(data, new ProtocolServerBuilder.PayloadConsumer(){

            public void decoded(String inf, byte[] pload) {
                Assert.assertEquals((Object)"info", (Object)inf);
                Assert.assertArrayEquals((byte[])payload, (byte[])pload);
                decoded.set(true);
            }
        });
        Assert.assertTrue((boolean)decoded.get());
        Assert.assertNotNull((Object)codec.getCharset());
        codec.setCharset(Charset.defaultCharset());
        Assert.assertEquals((Object)Charset.defaultCharset(), (Object)codec.getCharset());
        Assert.assertTrue((codec.getDataBytesLength() >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((codec.decodeDataLength(data) >= 0 ? 1 : 0) != 0);
    }

    private void setPropVal(Object obj) {
        if (obj instanceof Integer) {
            this.propVal = (Integer)obj;
        }
    }

    @Test
    public void testLocalInvocation() {
        SimpleOperationsProvider provider = new SimpleOperationsProvider();
        LocalInvocablesCreator creator = new LocalInvocablesCreator((OperationsProvider)provider);
        LocalProtocolServerBuilder pBuilder = new LocalProtocolServerBuilder((OperationsProvider)provider);
        Supplier myGetter = creator.createGetter("prop");
        Consumer mySetter = creator.createSetter("prop");
        Function myFunc = creator.createInvocable("myFunc");
        provider.defineOperation("myCat", "myFunc", myFunc);
        Assert.assertNull((Object)provider.getGetter("prop"));
        Assert.assertNull((Object)provider.getSetter("prop"));
        Assert.assertNull((Object)provider.getServiceFunction("myFunc"));
        Assert.assertTrue((provider.getOperation("myCat", "myFunc") == myFunc ? 1 : 0) != 0);
        Assert.assertNotNull((Object)pBuilder.createPayloadCodec());
        Assert.assertNotNull((Object)pBuilder.build());
        Function<Object[], Object> implFunc = param -> "FUNC";
        pBuilder.defineOperation("myFunc", implFunc);
        Supplier<Object> implGetter = () -> this.propVal;
        Consumer<Object> implSetter = p -> this.setPropVal(p);
        pBuilder.defineProperty("prop", implGetter, implSetter);
        Assert.assertTrue((provider.getGetter("prop") == implGetter ? 1 : 0) != 0);
        Assert.assertTrue((provider.getSetter("prop") == implSetter ? 1 : 0) != 0);
        Assert.assertTrue((provider.getServiceFunction("myFunc") == implFunc ? 1 : 0) != 0);
        Assert.assertEquals((Object)this.propVal, myGetter.get());
        mySetter.accept(25);
        Assert.assertEquals((long)25L, (long)this.propVal);
        Assert.assertEquals((Object)this.propVal, myGetter.get());
        Assert.assertEquals((Object)"FUNC", myFunc.apply(new Object[0]));
    }

    @Test
    public void testLocalInvocationViaFactory() {
        AasFactory factory = AasFactory.getInstance();
        InvocablesCreator creator = factory.createInvocablesCreator("local", "", 0);
        ProtocolServerBuilder pBuilder = factory.createProtocolServerBuilder("local", 0);
        Supplier myGetter = creator.createGetter("prop");
        Consumer mySetter = creator.createSetter("prop");
        Function myFunc = creator.createInvocable("myFunc");
        Assert.assertNotNull((Object)pBuilder.createPayloadCodec());
        Assert.assertNotNull((Object)pBuilder.build());
        pBuilder.defineOperation("myFunc", param -> "FUNC");
        pBuilder.defineProperty("prop", () -> this.propVal, p -> this.setPropVal(p));
        Assert.assertEquals((Object)this.propVal, myGetter.get());
        mySetter.accept(25);
        Assert.assertEquals((long)25L, (long)this.propVal);
        Assert.assertEquals((Object)this.propVal, myGetter.get());
        Assert.assertEquals((Object)"FUNC", myFunc.apply(new Object[0]));
    }
}

