/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.support.aas;

import de.iip_ecosphere.platform.support.Endpoint;
import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.Server;
import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.AasFactory;
import de.iip_ecosphere.platform.support.aas.AasPrintVisitor;
import de.iip_ecosphere.platform.support.aas.AasServer;
import de.iip_ecosphere.platform.support.aas.AasVisitor;
import de.iip_ecosphere.platform.support.aas.AssetKind;
import de.iip_ecosphere.platform.support.aas.DeploymentRecipe;
import de.iip_ecosphere.platform.support.aas.InvocablesCreator;
import de.iip_ecosphere.platform.support.aas.Property;
import de.iip_ecosphere.platform.support.aas.Registry;
import de.iip_ecosphere.platform.support.aas.ServerRecipe;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.aas.SubmodelElement;
import de.iip_ecosphere.platform.support.aas.SubmodelElementCollection;
import de.iip_ecosphere.platform.support.aas.Type;
import de.iip_ecosphere.platform.support.net.KeyStoreDescriptor;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import org.junit.Assert;
import org.junit.Test;

public class DeploymentTest {
    @Test
    public void localSubmodelDynamicDeployment() throws IOException, ExecutionException {
        String urn = "urn:::AAS:::testMachines#";
        AasFactory factory = AasFactory.getInstance();
        Aas.AasBuilder aasB = factory.createAasBuilder("myAas", "urn:::AAS:::testMachines#");
        aasB.createSubmodelBuilder("initial", null).defer();
        Aas aas = (Aas)aasB.build();
        ServerAddress serverAdr = new ServerAddress(Schema.HTTP);
        Endpoint regEp = new Endpoint(serverAdr, "registry");
        AasServer server = factory.createDeploymentRecipe(new Endpoint(serverAdr, "")).addInMemoryRegistry(regEp).deploy(aas).createServer(new String[0]).start();
        Registry reg = factory.obtainRegistry(regEp);
        aas = reg.retrieveAas("urn:::AAS:::testMachines#");
        Submodel sub = (Submodel)aas.createSubmodelBuilder("dynamic", null).build();
        server.deploy(aas, sub);
        aas = reg.retrieveAas("urn:::AAS:::testMachines#");
        Assert.assertNotNull((Object)aas.getSubmodel("dynamic"));
        Submodel.SubmodelBuilder smb = aas.createSubmodelBuilder("dynamic", null);
        smb.createPropertyBuilder("prop").setValue(Type.STRING, (Object)"bb").build();
        smb.defer();
        aas.buildDeferred();
        aas = reg.retrieveAas("urn:::AAS:::testMachines#");
        sub = aas.getSubmodel("dynamic");
        Assert.assertNotNull((Object)sub);
        Property prop = sub.getProperty("prop");
        Assert.assertNotNull((Object)prop);
        Assert.assertEquals((Object)"bb", (Object)prop.getValue());
        server.stop(true);
    }

    @Test
    public void localDynamicSubmodelElementsCollectionDeployment() throws IOException, ExecutionException {
        String urn = "urn:::AAS:::testMachines#";
        ServerAddress serverAddress = new ServerAddress(Schema.HTTP);
        Endpoint regEp = new Endpoint(serverAddress, "registry");
        AasFactory factory = AasFactory.getInstance();
        Aas.AasBuilder aasB = factory.createAasBuilder("myAas", "urn:::AAS:::testMachines#");
        aasB.createSubmodelBuilder("sub", null).build();
        Aas aas = (Aas)aasB.build();
        AasServer server = factory.createDeploymentRecipe(new Endpoint(serverAddress, "")).addInMemoryRegistry(regEp).deploy(aas).createServer(new String[0]).start();
        Registry reg = factory.obtainRegistry(regEp);
        aas = reg.retrieveAas("urn:::AAS:::testMachines#", true);
        Submodel sub = aas.getSubmodel("sub");
        Assert.assertNotNull((Object)sub);
        SubmodelElementCollection.SubmodelElementCollectionBuilder smcB = sub.createSubmodelElementCollectionBuilder("coll", false, true);
        smcB.createPropertyBuilder("prop").setValue(Type.BOOLEAN, (Object)true).build();
        smcB.build();
        aas = reg.retrieveAas("urn:::AAS:::testMachines#", true);
        Aas aas1 = reg.retrieveAas("urn:::AAS:::testMachines#");
        sub = aas.getSubmodel("sub");
        Assert.assertNotNull((Object)sub);
        SubmodelElementCollection coll = sub.getSubmodelElementCollection("coll");
        Assert.assertNotNull((Object)coll);
        SubmodelElementCollection coll1 = aas1.getSubmodel("sub").getSubmodelElementCollection("coll");
        Assert.assertNull((Object)coll1.getProperty("prop1"));
        smcB = sub.createSubmodelElementCollectionBuilder("coll", false, true);
        smcB.createPropertyBuilder("prop1").setValue(Type.BOOLEAN, (Object)true).build();
        smcB.build();
        Assert.assertNull((Object)coll1.getProperty("prop1"));
        coll1.update();
        Assert.assertNotNull((Object)coll1.getProperty("prop1"));
        sub.deleteElement((SubmodelElement)coll);
        aas = reg.retrieveAas("urn:::AAS:::testMachines#");
        sub = aas.getSubmodel("sub");
        Assert.assertNotNull((Object)sub);
        coll = sub.getSubmodelElementCollection("coll");
        Assert.assertNull((Object)coll);
        server.stop(true);
    }

    @Test
    public void localDynamicSubmodelElementsCollectionPropertyDeployment() throws IOException, ExecutionException {
        String urn = "urn:::AAS:::testMachines#";
        ServerAddress serverAddress = new ServerAddress(Schema.HTTP);
        Endpoint regEp = new Endpoint(serverAddress, "registry");
        AasFactory factory = AasFactory.getInstance();
        Aas.AasBuilder aasB = factory.createAasBuilder("myAas", "urn:::AAS:::testMachines#");
        aasB.createSubmodelBuilder("sub", null).build();
        Aas aas = (Aas)aasB.build();
        AasServer server = factory.createDeploymentRecipe(new Endpoint(serverAddress, "")).addInMemoryRegistry(regEp).deploy(aas).createServer(new String[0]).start();
        Registry reg = factory.obtainRegistry(regEp);
        aas = reg.retrieveAas("urn:::AAS:::testMachines#");
        Submodel sub = aas.getSubmodel("sub");
        Assert.assertNotNull((Object)sub);
        SubmodelElementCollection.SubmodelElementCollectionBuilder smcB = sub.createSubmodelElementCollectionBuilder("coll", false, false);
        Assert.assertTrue((boolean)smcB.isNew());
        smcB.createPropertyBuilder("prop").setValue(Type.BOOLEAN, (Object)true).build();
        smcB.createPropertyBuilder("prop2").setType(Type.INTEGER).bind((Supplier<Object> & Serializable)() -> 5, InvocablesCreator.READ_ONLY).build();
        smcB.build();
        aas = reg.retrieveAas("urn:::AAS:::testMachines#");
        sub = aas.getSubmodel("sub");
        Assert.assertNotNull((Object)sub);
        SubmodelElementCollection coll = sub.getSubmodelElementCollection("coll");
        Assert.assertNotNull((Object)coll);
        this.assertProp(coll);
        this.assertProp2(coll);
        smcB = sub.createSubmodelElementCollectionBuilder("coll", false, false);
        smcB.createPropertyBuilder("prop2").setValue(Type.STRING, (Object)"aa").build();
        SubmodelElementCollection.SubmodelElementCollectionBuilder smcBI = smcB.createSubmodelElementCollectionBuilder("coll_inner", false, false);
        smcBI.createPropertyBuilder("prop2I").setValue(Type.STRING, (Object)"ab").build();
        smcBI.defer();
        smcB.defer();
        smcB = sub.createSubmodelElementCollectionBuilder("coll", false, false);
        smcB.createPropertyBuilder("prop3").setValue(Type.STRING, (Object)"bb").build();
        smcBI = smcB.createSubmodelElementCollectionBuilder("coll_inner", false, false);
        smcBI.createPropertyBuilder("prop3I").setValue(Type.STRING, (Object)"ac").build();
        smcBI.defer();
        smcB.buildDeferred();
        aas.accept((AasVisitor)new AasPrintVisitor());
        aas = reg.retrieveAas("urn:::AAS:::testMachines#");
        sub = aas.getSubmodel("sub");
        Assert.assertNotNull((Object)sub);
        coll = sub.getSubmodelElementCollection("coll");
        Assert.assertNotNull((Object)coll);
        Property prop = coll.getProperty("prop");
        Assert.assertNotNull((Object)prop);
        Assert.assertEquals((Object)false, (Object)prop.getValue());
        prop = coll.getProperty("prop2");
        Assert.assertNotNull((Object)prop);
        Assert.assertEquals((Object)"aa", (Object)prop.getValue());
        prop = coll.getProperty("prop3");
        Assert.assertNotNull((Object)prop);
        Assert.assertEquals((Object)"bb", (Object)prop.getValue());
        SubmodelElementCollection collInner = coll.getSubmodelElementCollection("coll_inner");
        Assert.assertNotNull((Object)collInner);
        prop = collInner.getProperty("prop2I");
        Assert.assertNotNull((Object)prop);
        Assert.assertEquals((Object)"ab", (Object)prop.getValue());
        prop = collInner.getProperty("prop3I");
        Assert.assertNotNull((Object)prop);
        Assert.assertEquals((Object)"ac", (Object)prop.getValue());
        server.stop(true);
    }

    private void assertProp(SubmodelElementCollection coll) throws ExecutionException {
        Property prop = coll.getProperty("prop");
        Assert.assertNotNull((Object)prop);
        Assert.assertEquals((Object)true, (Object)prop.getValue());
        prop.setValue((Object)false);
        Assert.assertEquals((Object)false, (Object)prop.getValue());
    }

    private void assertProp2(SubmodelElementCollection coll) throws ExecutionException {
        Property prop2 = coll.getProperty("prop2");
        Assert.assertNotNull((Object)prop2);
        Assert.assertEquals((Object)5, (Object)prop2.getValue());
        prop2.setValue((Object)8);
        Assert.assertEquals((Object)5, (Object)prop2.getValue());
    }

    @Test
    public void remoteAasDeploymentTest() throws IOException {
        this.remoteAasDeploymentTestImpl(Schema.HTTP, null);
    }

    @Test
    public void remoteAasSslDeploymentTest() throws IOException {
        File keyPath = new File("./src/test/resources/keystore.jks");
        this.remoteAasDeploymentTestImpl(Schema.HTTPS, new KeyStoreDescriptor(keyPath, "a1234567", "tomcat"));
    }

    protected Schema adaptRegistrySchema(Schema schema) {
        return schema;
    }

    private void remoteAasDeploymentTestImpl(Schema schema, KeyStoreDescriptor kstore) throws IOException {
        AasFactory factory = AasFactory.getInstance();
        ServerRecipe srcp = factory.createServerRecipe();
        Endpoint regEp = new Endpoint(this.adaptRegistrySchema(schema), "registry");
        Server regServer = srcp.createRegistryServer(regEp, (ServerRecipe.PersistenceType)ServerRecipe.LocalPersistenceType.INMEMORY, kstore, new String[0]).start();
        Endpoint serverEp = new Endpoint(schema, "cloud");
        DeploymentRecipe.RegistryDeploymentRecipe regD = factory.createDeploymentRecipe(serverEp, kstore).setRegistryUrl(regEp);
        Registry reg = regD.obtainRegistry();
        AasServer cloudServer = regD.createServer(new String[0]).start();
        String aasUrn = "urn:::AAS:::oven#";
        Aas.AasBuilder aasB = factory.createAasBuilder("oven", "urn:::AAS:::oven#");
        aasB.createAssetBuilder("OvenAsset", "urn:::AAS:::ovenAsset#", AssetKind.INSTANCE).build();
        Aas aas = (Aas)aasB.build();
        reg.createAas(aas, serverEp.toUri());
        String smUrn = "urn:::AAS:::ovenDoc#";
        Submodel.SubmodelBuilder smB = factory.createSubmodelBuilder("oven_doc", "urn:::AAS:::ovenDoc#");
        smB.createPropertyBuilder("max_temp").setValue((Object)1000).build();
        reg.createSubmodel(aas, (Submodel)smB.build());
        String smUrn2 = "urn:::AAS:::ovenDoc2#";
        smB = aas.createSubmodelBuilder("oven_doc2", "urn:::AAS:::ovenDoc2#");
        smB.createPropertyBuilder("max_temp").setValue((Object)1000).build();
        smB.build();
        this.assertRemoteAas(regEp, "urn:::AAS:::oven#", "oven_doc", "urn:::AAS:::ovenDoc#", serverEp);
        this.assertRemoteAas(regEp, "urn:::AAS:::oven#", "oven_doc2", "urn:::AAS:::ovenDoc2#", serverEp);
        cloudServer.stop(true);
        regServer.stop(true);
    }

    private void assertRemoteAas(Endpoint regEp, String aasUrn, String submName, String smUrn, Endpoint aasEp) throws IOException {
        Registry reg = AasFactory.getInstance().obtainRegistry(regEp, aasEp.getSchema());
        Aas aas = reg.retrieveAas(aasUrn);
        Assert.assertNotNull((Object)aas);
        Assert.assertEquals((Object)"oven", (Object)aas.getIdShort());
        Submodel sm = reg.retrieveSubmodel(aasUrn, smUrn);
        Assert.assertNotNull((Object)sm);
        Assert.assertEquals((Object)submName, (Object)sm.getIdShort());
        Assert.assertNotNull((Object)sm.getProperty("max_temp"));
    }
}

