/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.support.aas;

import de.iip_ecosphere.platform.support.CollectionUtils;
import de.iip_ecosphere.platform.support.Endpoint;
import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.Server;
import de.iip_ecosphere.platform.support.ServerAddress;
import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.AasFactory;
import de.iip_ecosphere.platform.support.aas.AasPrintVisitor;
import de.iip_ecosphere.platform.support.aas.AasServer;
import de.iip_ecosphere.platform.support.aas.AasVisitor;
import de.iip_ecosphere.platform.support.aas.InvocablesCreator;
import de.iip_ecosphere.platform.support.aas.LangString;
import de.iip_ecosphere.platform.support.aas.Operation;
import de.iip_ecosphere.platform.support.aas.Property;
import de.iip_ecosphere.platform.support.aas.ProtocolServerBuilder;
import de.iip_ecosphere.platform.support.aas.Reference;
import de.iip_ecosphere.platform.support.aas.ReferenceElement;
import de.iip_ecosphere.platform.support.aas.Registry;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.aas.SubmodelElement;
import de.iip_ecosphere.platform.support.aas.SubmodelElementCollection;
import de.iip_ecosphere.platform.support.aas.SubmodelElementContainerBuilder;
import de.iip_ecosphere.platform.support.aas.Type;
import de.iip_ecosphere.platform.support.net.KeyStoreDescriptor;
import java.io.IOException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.junit.Assert;
import org.junit.Test;
import test.de.iip_ecosphere.platform.support.aas.TestMachine;

public class AasTest {
    public static final String QNAME_VAR_LOTSIZE;
    public static final String QNAME_VAR_VENDOR;
    public static final String QNAME_VAR_POWCONSUMPTION;
    public static final String QNAME_OP_STARTMACHINE;
    public static final String QNAME_OP_RECONFIGURE;
    public static final String QNAME_OP_STOPMACHINE;
    public static final String NAME_AAS = "aasTest";
    public static final String NAME_SUBMODEL = "machine";
    private static final String NAME_SUBMODELC_OUTER = "outer";
    private static final String NAME_VAR_SUBMODELC_OUTER_VAR = "outerVar";
    private static final String NAME_VAR_SUBMODELC_OUTER_REF = "outerRef";
    private static final String NAME_SUBMODELC_INNER = "inner";
    private static final String NAME_VAR_SUBMODELC_INNER_VAR = "innerVar";
    private static final String NAME_VAR_SUBMODELC_INNER_INT = "innerInt";
    private static final String NAME_VAR_SUBMODELC_INNER_REF = "innerRef";
    private static final String NAME_VAR_LOTSIZE = "lotSize";
    private static final String NAME_VAR_VENDOR = "vendor";
    private static final String NAME_VAR_POWCONSUMPTION = "powerConsumption";
    private static final String NAME_VAR_DESCRIPTION1 = "description1";
    private static final String NAME_VAR_DESCRIPTION2 = "description2";
    private static final String NAME_OP_STARTMACHINE = "startMachine";
    private static final String NAME_OP_RECONFIGURE = "setLotSize";
    private static final String NAME_OP_STOPMACHINE = "stopMachine";
    private static final ServerAddress VAB_SERVER;
    private static final String URN_AAS = "urn:::AAS:::testMachines#";
    private static final LangString DESCRIPTION;

    public static Server createOperationsServer(int port, TestMachine machine, String protocol, KeyStoreDescriptor kstore) {
        AasFactory factory = AasFactory.getInstance();
        ProtocolServerBuilder builder = factory.createProtocolServerBuilder(protocol, port, kstore);
        builder.defineProperty(NAME_VAR_LOTSIZE, () -> machine.getLotSize(), param -> machine.setLotSize((Integer)param));
        builder.defineProperty(NAME_VAR_VENDOR, () -> machine.getVendor(), param -> machine.setVendor((String)param));
        builder.defineProperty(NAME_VAR_POWCONSUMPTION, () -> machine.getPowerConsumption(), null);
        builder.defineOperation(NAME_OP_STARTMACHINE, params -> {
            machine.start();
            return null;
        });
        builder.defineOperation(NAME_OP_RECONFIGURE, params -> machine.reconfigure((Integer)params[0]));
        builder.defineOperation(NAME_OP_STOPMACHINE, params -> {
            machine.stop();
            return null;
        });
        builder.createPayloadCodec();
        return (Server)builder.build();
    }

    public void createAasOperationsElements(SubmodelElementContainerBuilder subModelBuilder, ServerAddress addr, String protocol) {
        this.createAasOperationsElements(subModelBuilder, addr.getHost(), addr.getPort(), protocol);
    }

    public void createAasOperationsElements(SubmodelElementContainerBuilder subModelBuilder, String host, int port, String protocol) {
        AasFactory factory = AasFactory.getInstance();
        InvocablesCreator invC = factory.createInvocablesCreator(protocol, host, port, this.getKeyStoreDescriptor(protocol));
        subModelBuilder.createPropertyBuilder(NAME_VAR_LOTSIZE).setType(Type.INTEGER).bind(invC.createGetter(NAME_VAR_LOTSIZE), invC.createSetter(NAME_VAR_LOTSIZE)).build();
        subModelBuilder.createPropertyBuilder(NAME_VAR_VENDOR).setType(Type.STRING).bindLazy(invC.createGetter(NAME_VAR_VENDOR), invC.createSetter(NAME_VAR_VENDOR)).build();
        subModelBuilder.createPropertyBuilder(NAME_VAR_POWCONSUMPTION).setType(Type.DOUBLE).setSemanticId("irdi:0173-1#02-AAV232#002").bind(invC.createGetter(NAME_VAR_POWCONSUMPTION), InvocablesCreator.READ_ONLY).build();
        subModelBuilder.createOperationBuilder(NAME_OP_STARTMACHINE).setInvocable(invC.createInvocable(NAME_OP_STARTMACHINE)).build(Type.NONE);
        subModelBuilder.createOperationBuilder(NAME_OP_RECONFIGURE).addInputVariable(NAME_VAR_LOTSIZE, Type.INTEGER).setInvocableLazy(invC.createInvocable(NAME_OP_RECONFIGURE)).build(Type.BOOLEAN);
        subModelBuilder.createOperationBuilder(NAME_OP_STOPMACHINE).setInvocable(invC.createInvocable(NAME_OP_STOPMACHINE)).build(Type.NONE);
    }

    @Test
    public void testVabQuery() throws SocketException, UnknownHostException, ExecutionException, IOException {
        for (String sProto : this.getServerProtocols()) {
            for (String proto : AasFactory.getInstance().getProtocols()) {
                if ("local".equals(proto) || this.excludeProtocol(proto)) continue;
                System.out.println("Testing VAB protocol: " + proto + (String)(sProto.length() > 0 ? " on server protocol " + sProto : ""));
                this.testVabQuery(proto, sProto);
            }
        }
    }

    public String[] getServerProtocols() {
        return new String[]{""};
    }

    protected KeyStoreDescriptor getKeyStoreDescriptor(String protocol) {
        return null;
    }

    protected boolean excludeProtocol(String protocol) {
        return false;
    }

    protected void testVabQuery(String protocol, String serverProtocol) throws SocketException, UnknownHostException, ExecutionException, IOException {
        KeyStoreDescriptor ksd;
        ServerAddress aasServerAddress;
        TestMachine machine = new TestMachine();
        Server ccServer = AasTest.createOperationsServer(VAB_SERVER.getPort(), machine, protocol, this.getKeyStoreDescriptor(protocol));
        ccServer.start();
        ProtocolServerBuilder builder = AasFactory.getInstance().createProtocolServerBuilder(protocol, VAB_SERVER.getPort(), this.getKeyStoreDescriptor(protocol));
        Assert.assertTrue((boolean)builder.isAvailable(VAB_SERVER.getHost(), 5000));
        Aas aas = this.createAas(machine, protocol);
        AasFactory factory = AasFactory.getInstance();
        if (serverProtocol.length() > 0) {
            aasServerAddress = new ServerAddress(Schema.HTTPS);
            ksd = this.getKeyStoreDescriptor(serverProtocol);
        } else {
            aasServerAddress = new ServerAddress(Schema.HTTP);
            ksd = null;
        }
        Endpoint registryEndpoint = new Endpoint(aasServerAddress, "registry");
        AasServer httpServer = factory.createDeploymentRecipe(new Endpoint(aasServerAddress, ""), ksd).addInMemoryRegistry(registryEndpoint).deploy(aas).createServer(new String[0]).start();
        AasTest.queryAas(registryEndpoint, machine);
        Server.stop((Server)httpServer, (boolean)true);
        Server.stop((Server)ccServer, (boolean)true);
    }

    private Aas createAas(TestMachine machine, String protocol) throws SocketException, UnknownHostException {
        AasFactory factory = AasFactory.getInstance();
        Aas.AasBuilder aasBuilder = factory.createAasBuilder(NAME_AAS, URN_AAS);
        Submodel.SubmodelBuilder subModelBuilder = aasBuilder.createSubmodelBuilder(NAME_SUBMODEL, null);
        Assert.assertTrue((boolean)subModelBuilder.isNew());
        this.createAasOperationsElements((SubmodelElementContainerBuilder)subModelBuilder, VAB_SERVER, protocol);
        Reference subModelBuilderRef = subModelBuilder.createReference();
        Assert.assertNotNull((Object)aasBuilder.createSubmodelBuilder(NAME_SUBMODEL, null));
        subModelBuilder.createPropertyBuilder(NAME_VAR_DESCRIPTION1).setValue(Type.LANG_STRING, (Object)LangString.create((String)"test@de")).build();
        subModelBuilder.createPropertyBuilder(NAME_VAR_DESCRIPTION2).setValue(Type.LANG_STRING, (Object)"test2@en").build();
        SubmodelElementCollection.SubmodelElementCollectionBuilder smcBuilderOuter = subModelBuilder.createSubmodelElementCollectionBuilder(NAME_SUBMODELC_OUTER, false, true);
        SubmodelElementCollection.SubmodelElementCollectionBuilder smcBuilderInner = smcBuilderOuter.createSubmodelElementCollectionBuilder(NAME_SUBMODELC_INNER, false, true);
        smcBuilderInner.createPropertyBuilder(NAME_VAR_SUBMODELC_INNER_VAR).setType(Type.AAS_INTEGER).setDescription(new LangString[]{DESCRIPTION}).build();
        smcBuilderInner.createPropertyBuilder(NAME_VAR_SUBMODELC_INNER_INT).setValue(Type.INTEGER, (Object)1).build();
        ReferenceElement re = (ReferenceElement)smcBuilderInner.createReferenceElementBuilder(NAME_VAR_SUBMODELC_INNER_REF).setValue(subModelBuilderRef).build();
        Assert.assertNotNull((Object)re.getValue());
        Assert.assertTrue((boolean)re.getValue().hasReference());
        Reference smcBuilder1Ref = smcBuilderInner.createReference();
        smcBuilderInner.build();
        smcBuilderOuter.createPropertyBuilder(NAME_VAR_SUBMODELC_OUTER_VAR).setType(Type.STRING).build();
        smcBuilderOuter.createReferenceElementBuilder(NAME_VAR_SUBMODELC_OUTER_REF).setValue(smcBuilder1Ref).build();
        SubmodelElementCollection smcOuter = (SubmodelElementCollection)smcBuilderOuter.build();
        AasTest.assertSize(3, smcOuter.elements());
        Assert.assertEquals((long)3L, (long)smcOuter.getElementsCount());
        Assert.assertNotNull((Object)smcOuter.getDataElement(NAME_VAR_SUBMODELC_OUTER_VAR));
        Assert.assertNotNull((Object)smcOuter.getElement(NAME_SUBMODELC_INNER));
        Assert.assertNotNull((Object)subModelBuilder.createSubmodelElementCollectionBuilder(NAME_SUBMODELC_OUTER, false, true));
        Submodel submodel = (Submodel)subModelBuilder.build();
        Assert.assertNotNull((Object)submodel.getIdentification());
        AasTest.assertSize(3, submodel.operations());
        AasTest.assertSize(0, submodel.dataElements());
        AasTest.assertSize(5, submodel.properties());
        AasTest.assertSize(9, submodel.submodelElements());
        Assert.assertNotNull((Object)submodel.getOperation(NAME_OP_RECONFIGURE));
        Assert.assertEquals((long)9L, (long)submodel.getSubmodelElementsCount());
        Assert.assertNull((Object)submodel.getReferenceElement("myRef"));
        Aas aas = (Aas)aasBuilder.build();
        Assert.assertNotNull((Object)aas.getIdentification());
        Submodel subAdd = (Submodel)aas.createSubmodelBuilder("sub_add", null).build();
        Assert.assertNotNull((Object)aas.getSubmodel("sub_add"));
        subAdd.createSubmodelElementCollectionBuilder("sub_coll", true, true).build();
        Assert.assertNotNull((Object)aas.getSubmodel("sub_add").getSubmodelElementCollection("sub_coll"));
        submodel.createSubmodelElementCollectionBuilder("sub_coll2", false, false).build();
        Assert.assertNotNull((Object)submodel.getSubmodelElementCollection("sub_coll2"));
        aas.accept((AasVisitor)new AasPrintVisitor());
        AasTest.testCreateIterate(aas);
        return aas;
    }

    private static void testCreateIterate(Aas aas) {
        int numElts = 10;
        Submodel subAdd = (Submodel)aas.createSubmodelBuilder("sub_ai", null).build();
        SubmodelElementCollection.SubmodelElementCollectionBuilder outerB = subAdd.createSubmodelElementCollectionBuilder(NAME_SUBMODELC_OUTER, true, false);
        SubmodelElementCollection.SubmodelElementCollectionBuilder collsB = outerB.createSubmodelElementCollectionBuilder("colls", true, false);
        for (int i = 1; i <= 10; ++i) {
            SubmodelElementCollection.SubmodelElementCollectionBuilder b = collsB.createSubmodelElementCollectionBuilder("id_" + i, false, false);
            b.createPropertyBuilder("prop").setValue(Type.STRING, (Object)"a").build();
            b.build();
        }
        collsB.createPropertyBuilder("prop").setValue(Type.STRING, (Object)"a").build();
        collsB.build();
        outerB.build();
        Assert.assertFalse((boolean)subAdd.iterate(c -> false, SubmodelElement.class, new String[]{"xyz"}));
        Assert.assertTrue((boolean)subAdd.iterate(c -> {
            SubmodelElement elt = c.getElement("prop");
            if (elt instanceof Property) {
                try {
                    ((Property)elt).setValue((Object)"b");
                }
                catch (ExecutionException e) {
                    Assert.fail((String)("Unexpected exception: " + e.getMessage()));
                }
            }
            return true;
        }, SubmodelElementCollection.class, new String[]{NAME_SUBMODELC_OUTER, "colls"}));
        int count = 0;
        for (SubmodelElement e : subAdd.getSubmodelElementCollection(NAME_SUBMODELC_OUTER).getSubmodelElementCollection("colls").elements()) {
            if (!(e instanceof SubmodelElementCollection)) continue;
            try {
                Property prop = ((SubmodelElementCollection)e).getProperty("prop");
                Assert.assertNotNull((Object)prop);
                Object val = prop.getValue();
                Assert.assertNotNull((Object)val);
                Assert.assertEquals((Object)"b", (Object)val);
                ++count;
            }
            catch (ExecutionException ex) {
                Assert.fail((String)("Unexpected exception: " + ex.getMessage()));
            }
        }
        Assert.assertEquals((long)10L, (long)count);
        Assert.assertFalse((boolean)subAdd.create(c -> {}, true, new String[]{"zyx"}));
        Assert.assertTrue((boolean)subAdd.create(c -> c.createSubmodelElementCollectionBuilder("id_100", false, true).build(), false, new String[]{NAME_SUBMODELC_OUTER, "colls"}));
        SubmodelElementCollection oc = subAdd.getSubmodelElementCollection(NAME_SUBMODELC_OUTER).getSubmodelElementCollection("colls");
        oc.update();
        Assert.assertNotNull((Object)oc.getSubmodelElementCollection("id_100"));
    }

    private static void assertLangString(Object val, String str) {
        Assert.assertNotNull((Object)val);
        Assert.assertTrue((boolean)(val instanceof LangString));
        LangString ls2 = LangString.create((String)str);
        Assert.assertEquals((Object)ls2, (Object)val);
    }

    private static void queryAas(Endpoint registry, TestMachine machine) throws ExecutionException, IOException {
        AasFactory factory = AasFactory.getInstance();
        Registry reg = factory.obtainRegistry(registry);
        Aas aas = reg.retrieveAas(URN_AAS);
        Assert.assertEquals((Object)NAME_AAS, (Object)aas.getIdShort());
        Assert.assertEquals((long)3L, (long)aas.getSubmodelCount());
        Submodel subm = (Submodel)aas.submodels().iterator().next();
        Assert.assertNotNull((Object)subm);
        Assert.assertEquals((long)5L, (long)subm.getPropertiesCount());
        Property lotSize = subm.getProperty(NAME_VAR_LOTSIZE);
        Assert.assertNotNull((Object)lotSize);
        Assert.assertEquals((Object)machine.getLotSize(), (Object)lotSize.getValue());
        Property powConsumption = subm.getProperty(NAME_VAR_POWCONSUMPTION);
        Assert.assertNotNull((Object)powConsumption);
        Assert.assertEquals((Object)machine.getPowerConsumption(), (Object)powConsumption.getValue());
        AasTest.assertLangString(subm.getProperty(NAME_VAR_DESCRIPTION1).getValue(), "test@de");
        AasTest.assertLangString(subm.getProperty(NAME_VAR_DESCRIPTION2).getValue(), "test2@en");
        Assert.assertEquals((long)3L, (long)subm.getOperationsCount());
        Operation op = subm.getOperation(NAME_OP_STARTMACHINE);
        Assert.assertNotNull((Object)op);
        op.invoke(new Object[0]);
        Assert.assertEquals((Object)machine.getLotSize(), (Object)lotSize.getValue());
        Assert.assertEquals((Object)machine.getPowerConsumption(), (Object)powConsumption.getValue());
        op = subm.getOperation(NAME_OP_RECONFIGURE);
        Assert.assertNotNull((Object)op);
        op.invoke(new Object[]{5});
        Assert.assertEquals((Object)machine.getLotSize(), (Object)lotSize.getValue());
        Assert.assertEquals((Object)machine.getPowerConsumption(), (Object)powConsumption.getValue());
        op = subm.getOperation(NAME_OP_STOPMACHINE);
        Assert.assertNotNull((Object)op);
        op.invoke(new Object[0]);
        Assert.assertEquals((Object)machine.getLotSize(), (Object)lotSize.getValue());
        Assert.assertEquals((Object)machine.getPowerConsumption(), (Object)powConsumption.getValue());
        SubmodelElement se = subm.getSubmodelElement(NAME_SUBMODELC_OUTER);
        Assert.assertNotNull((Object)se);
        Assert.assertTrue((boolean)(se instanceof SubmodelElementCollection));
        SubmodelElementCollection secOuter = subm.getSubmodelElementCollection(NAME_SUBMODELC_OUTER);
        Assert.assertNotNull((Object)secOuter);
        Assert.assertTrue((se == secOuter ? 1 : 0) != 0);
        Assert.assertNotNull((Object)secOuter.getProperty(NAME_VAR_SUBMODELC_OUTER_VAR));
        Assert.assertNotNull((Object)secOuter.getReferenceElement(NAME_VAR_SUBMODELC_OUTER_REF));
        SubmodelElementCollection secInner = secOuter.getSubmodelElementCollection(NAME_SUBMODELC_INNER);
        Assert.assertNotNull((Object)secInner);
        Assert.assertNotNull((Object)secInner.getProperty(NAME_VAR_SUBMODELC_INNER_VAR));
        AasTest.assertDescription(secInner.getProperty(NAME_VAR_SUBMODELC_INNER_VAR), DESCRIPTION);
        Assert.assertNotNull((Object)secInner.getProperty(NAME_VAR_SUBMODELC_INNER_INT));
        Assert.assertEquals((Object)1, (Object)secInner.getProperty(NAME_VAR_SUBMODELC_INNER_INT).getValue());
        Assert.assertNotNull((Object)secInner.getReferenceElement(NAME_VAR_SUBMODELC_INNER_REF));
        Assert.assertNotNull((Object)aas.getSubmodel("sub_add"));
        Assert.assertNotNull((Object)aas.getSubmodel("sub_add").getSubmodelElementCollection("sub_coll"));
        Assert.assertNotNull((Object)subm.getSubmodelElementCollection("sub_coll2"));
        Submodel subAdd = (Submodel)aas.createSubmodelBuilder("conn_add", null).build();
        Assert.assertNotNull((Object)aas.getSubmodel("conn_add"));
        subAdd.createSubmodelElementCollectionBuilder("conn_coll", true, true).build();
        Assert.assertNotNull((Object)aas.getSubmodel("conn_add").getSubmodelElementCollection("conn_coll"));
        subm.createSubmodelElementCollectionBuilder("conn_coll2", false, false).build();
        Assert.assertNotNull((Object)subm.getSubmodelElementCollection("conn_coll2"));
        SubmodelElementCollection.SubmodelElementCollectionBuilder cc3 = subm.createSubmodelElementCollectionBuilder("conn_coll3", false, false);
        cc3.createSubmodelElementCollectionBuilder("cc3_1", false, false).build();
        cc3.build();
        Assert.assertNotNull((Object)subm.getSubmodelElementCollection("conn_coll3"));
        Assert.assertNotNull((Object)subm.getSubmodelElementCollection("conn_coll3").getSubmodelElementCollection("cc3_1"));
        subm.getSubmodelElementCollection("conn_coll3").deleteElement("cc3_1");
        Assert.assertNull((Object)subm.getSubmodelElementCollection("conn_coll3").getSubmodelElementCollection("cc3_1"));
        aas.accept((AasVisitor)new AasPrintVisitor());
        Aas aas2 = reg.retrieveAas(reg.getEndpoint(aas));
        Assert.assertNotNull((Object)aas2);
        Assert.assertEquals((Object)aas2.getIdShort(), (Object)aas.getIdShort());
        Assert.assertNull((Object)reg.retrieveAas("http://me.here.de/aas"));
    }

    private static void assertDescription(Property prop, LangString ... expected) {
        Map value = prop.getDescription();
        if (expected.length == 0) {
            Assert.assertTrue((value == null || value.size() == 0 ? 1 : 0) != 0);
        } else {
            for (LangString l : expected) {
                Assert.assertTrue((boolean)value.containsKey(l.getLanguage()));
                LangString v = (LangString)value.get(l.getLanguage());
                Assert.assertEquals((Object)l.getLanguage(), (Object)v.getLanguage());
                Assert.assertEquals((Object)l.getDescription(), (Object)v.getDescription());
            }
        }
    }

    private static <T> void assertSize(int expectedSize, Iterable<T> iter) {
        Assert.assertEquals((long)expectedSize, (long)CollectionUtils.toList(iter.iterator()).size());
    }

    @Test
    public void testFactory() {
        AasFactory factory = AasFactory.getInstance();
        Assert.assertTrue((factory.getName().length() > 0 ? 1 : 0) != 0);
        factory.supportsPropertyFunctions();
    }

    @Test
    public void testIllegalShortId() {
        AasFactory factory = AasFactory.getInstance();
        Aas.AasBuilder aasBuilder = factory.createAasBuilder(NAME_AAS, URN_AAS);
        Submodel.SubmodelBuilder subModelBuilder = aasBuilder.createSubmodelBuilder(NAME_SUBMODEL, null);
        try {
            subModelBuilder.createPropertyBuilder("value").setValue((Object)1).build();
            Assert.fail((String)"No exception due to illegal name");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            subModelBuilder.createPropertyBuilder("1234").setValue((Object)1).build();
            Assert.fail((String)"No exception due to illegal name");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            subModelBuilder.createPropertyBuilder("java.lang.String").setValue((Object)1).build();
            Assert.fail((String)"No exception due to illegal name");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testFixId() {
        AasFactory instance = AasFactory.getInstance();
        Assert.assertNull((Object)instance.fixId(null));
        Assert.assertEquals((Object)"", (Object)instance.fixId(""));
        Assert.assertEquals((Object)"id", (Object)instance.fixId("id"));
        Assert.assertEquals((Object)"a1id", (Object)instance.fixId("1id"));
        Assert.assertEquals((Object)"a_id", (Object)instance.fixId("a_id"));
        Assert.assertEquals((Object)"a_id", (Object)instance.fixId("a id"));
        Assert.assertEquals((Object)"test_log", (Object)instance.fixId("test-log"));
        Assert.assertEquals((Object)"de_uni_hildesheim_sse_Test_TEst", (Object)instance.fixId("de.uni-hildesheim.sse.Test$TEst"));
        Assert.assertEquals((Object)"a1de_uni_hildesheim_sse_Test", (Object)instance.fixId("1de.uni-hildesheim.sse.Test"));
        Assert.assertEquals((Object)"a1de_uni_hildesheim_sse_Test_TEst", (Object)instance.fixId("1de.uni-hildesheim.sse.Test$TEst"));
        Assert.assertEquals((Object)"jenkins_2_localhost", (Object)instance.fixId("jenkins-2@localhost"));
    }

    static {
        VAB_SERVER = new ServerAddress(Schema.HTTP);
        DESCRIPTION = new LangString("en", "A description");
        QNAME_VAR_LOTSIZE = "machine/lotSize";
        QNAME_VAR_VENDOR = "machine/vendor";
        QNAME_VAR_POWCONSUMPTION = "machine/powerConsumption";
        QNAME_OP_STARTMACHINE = "machine/startMachine";
        QNAME_OP_RECONFIGURE = "machine/setLotSize";
        QNAME_OP_STOPMACHINE = "machine/stopMachine";
    }
}

