/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.support;

import de.iip_ecosphere.platform.support.metrics.SystemMetrics;
import de.iip_ecosphere.platform.support.metrics.SystemMetricsFactory;
import org.junit.Assert;
import org.junit.Test;

public class SystemMetricsTest {
    @Test
    public void testSystemMetrics() {
        SystemMetrics m = SystemMetricsFactory.getSystemMetrics();
        Assert.assertNotNull((Object)m);
        SystemMetricsTest.testImplemented(m);
        System.out.println("temp case: " + m.getCaseTemperature());
        System.out.println("temp CPU: " + m.getCpuTemperature());
        System.out.println("temp CPU: " + m.getNumGpuCores());
    }

    public static void testImplemented(SystemMetrics metrics) {
        String osName = metrics.getOsName();
        Assert.assertNotNull((Object)osName);
        Assert.assertTrue((osName.length() > 0 ? 1 : 0) != 0);
        System.out.println("OS: " + osName);
        String osArch = metrics.getOsArch();
        Assert.assertNotNull((Object)osArch);
        Assert.assertTrue((osArch.length() > 0 ? 1 : 0) != 0);
        System.out.println("Arch: " + osArch);
        int cpuNum = metrics.getNumCpuCores();
        Assert.assertTrue((cpuNum >= 0 ? 1 : 0) != 0);
        System.out.println("#CPU: " + cpuNum);
    }

    @Test
    public void testInvalid() {
        Assert.assertTrue((boolean)SystemMetrics.isCelsiusTemperatureValid((float)0.0f));
        Assert.assertTrue((boolean)SystemMetrics.isCelsiusTemperatureValid((float)-10.0f));
        Assert.assertTrue((boolean)SystemMetrics.isCelsiusTemperatureValid((float)25.0f));
        Assert.assertTrue((boolean)SystemMetrics.isCelsiusTemperatureValid((float)-273.0f));
        Assert.assertFalse((boolean)SystemMetrics.isCelsiusTemperatureValid((float)-274.0f));
    }
}

