/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.support;

import de.iip_ecosphere.platform.support.semanticId.DefaultSemanticIdResolutionResult;
import de.iip_ecosphere.platform.support.semanticId.SemanticIdResolutionResult;
import de.iip_ecosphere.platform.support.semanticId.SemanticIdResolver;
import de.iip_ecosphere.platform.support.semanticId.SemanticIdResolverDescriptor;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;

public class SemanticIdResolverTest {
    @Test
    public void testResolver() {
        Assert.assertTrue((boolean)SemanticIdResolver.hasResolver(MyResolver.class));
        Assert.assertFalse((boolean)SemanticIdResolver.hasResolver(MyResolver2.class));
        SemanticIdResolutionResult res = SemanticIdResolver.resolve((String)"myId:abcs");
        Assert.assertNull((Object)res);
        SemanticIdResolver.resolve((String)"abcs");
        Assert.assertNull((Object)res);
        res = SemanticIdResolver.resolve((String)"myId:ab1234");
        Assert.assertNotNull((Object)res);
        Assert.assertNotNull((Object)res.getSemanticId());
        Assert.assertNotNull((Object)res.getPublisher());
        Assert.assertNotNull((Object)res.getKind());
        Assert.assertNotNull((Object)res.getVersion());
        Assert.assertNotNull((Object)res.getNaming());
        SemanticIdResolutionResult.Naming n = (SemanticIdResolutionResult.Naming)res.getNaming().get("de");
        Assert.assertNotNull((Object)n);
        Assert.assertNotNull((Object)n.getName());
        Assert.assertNotNull((Object)n.getDescription());
        Assert.assertNotNull((Object)n.getStructuredName());
    }

    private static final class MyResolver2
    extends SemanticIdResolver {
        private MyResolver2() {
        }

        public SemanticIdResolutionResult resolveSemanticId(String semanticId) {
            return null;
        }

        public boolean isResponsible(String semanticId) {
            return false;
        }
    }

    public static final class MyResolverDescriptor
    implements SemanticIdResolverDescriptor {
        public SemanticIdResolver createResolver() {
            return new MyResolver();
        }
    }

    private static final class MyResolver
    extends SemanticIdResolver {
        private MyResolver() {
        }

        public SemanticIdResolutionResult resolveSemanticId(String semanticId) {
            DefaultSemanticIdResolutionResult result = null;
            if ("myId:ab1234".equals(semanticId)) {
                result = new DefaultSemanticIdResolutionResult();
                result.setSemanticId(semanticId);
                result.setKind("??");
                result.setPublisher("IIP");
                result.setRevision("1");
                result.setVersion("1");
                HashMap<String, DefaultSemanticIdResolutionResult.DefaultNaming> naming = new HashMap<String, DefaultSemanticIdResolutionResult.DefaultNaming>();
                DefaultSemanticIdResolutionResult.DefaultNaming n = new DefaultSemanticIdResolutionResult.DefaultNaming();
                n.setName("whatever");
                n.setStructuredName("whatever");
                n.setDescription("whatever");
                naming.put("de", n);
                result.setNaming(naming);
            }
            return result;
        }

        public boolean isResponsible(String semanticId) {
            return semanticId.startsWith("myId:");
        }
    }
}

